/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.client;

import java.security.Principal;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.cim.CIMArgument;
import org.sblim.wbem.cim.CIMClass;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMQualifierType;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.client.BatchHandle;
import org.sblim.wbem.client.BatchResult;
import org.sblim.wbem.client.CIMClientFactory;
import org.sblim.wbem.client.CIMOMHandle;
import org.sblim.wbem.client.indications.CIMListener;
import org.sblim.wbem.util.Benchmark;
import org.sblim.wbem.util.SessionProperties;

public class CIMClient {
    public static final String ITSANM_CIMXML = "ITSANM_CIMXML";
    public static final String ITSANM_SOAP = "ITSANM_SOAP";
    public static final String ITSANM_LOCAL = "ITSANM_LOCAL";
    public static final String CIM_XML = "CIM_XML";
    public static final String WQL = "WQL";
    public static final String CQL = "CQL";
    public static final String WQL1 = "WBEMSQL1";
    public static final String WQL2 = "WBEMSQL2";
    public static final String WQL3 = "WBEMSQL3";
    public static final String WQL4 = "WBEMSQL4";
    private CIMOMHandle iHandle;

    public CIMClient(CIMNameSpace pNameSpace, Principal pPrincipal, Object pCredential) throws CIMException {
        this(pNameSpace, pPrincipal, pCredential, CIM_XML);
    }

    public CIMClient(CIMNameSpace pNameSpace, Principal pPrincipal, Object pCredential, String pProtocol) throws CIMException {
        this(pNameSpace, pPrincipal, pCredential, pProtocol, null);
    }

    public CIMClient(CIMNameSpace pNameSpace, Principal pPrincipal, Object pCredential, String pProtocol, SessionProperties pProperties) throws CIMException {
        if (pNameSpace == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", "Null namespace");
        }
        this.iHandle = CIMClientFactory.getClient(pNameSpace, pPrincipal, pCredential, pProtocol, pProperties);
    }

    public CIMClient(CIMOMHandle pCimomHandle) throws CIMException {
        if (pCimomHandle == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", "null cimomHandler parameter");
        }
        this.iHandle = pCimomHandle;
    }

    private void preCheck() throws CIMException {
        if (this.iHandle == null) {
            throw new CIMException("CIM_ERR_FAILED", "CIMClient is not bounded to a CIMOM");
        }
    }

    public synchronized Enumeration associatorNames(CIMObjectPath pObjectPath, String pAssociationClass, String pResultClass, String pRole, String pResultRole) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        Enumeration enumeration = this.iHandle.associatorNames(pObjectPath, pAssociationClass, pResultClass, pRole, pResultRole);
        Benchmark.stopTimer();
        return enumeration;
    }

    public synchronized Enumeration associatorNames(CIMObjectPath pObjectPath) throws CIMException {
        return this.associatorNames(pObjectPath, null, null, null, null);
    }

    public synchronized Enumeration associators(CIMObjectPath pObjectPath, String pAssociationClass, String pResultClass, String pRole, String pResultRole, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, String[] pPropertyList) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        Enumeration enumeration = this.iHandle.associators(pObjectPath, pAssociationClass, pResultClass, pRole, pResultRole, pIncludeQualifiers, pIncludeClassOrigin, pPropertyList);
        Benchmark.stopTimer();
        return enumeration;
    }

    public synchronized void deleteInstance(CIMObjectPath pInstancePath) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        this.iHandle.deleteInstance(pInstancePath);
        Benchmark.stopTimer();
    }

    public synchronized Enumeration enumInstances(CIMObjectPath pClassPath, boolean pDeepInheritance) throws CIMException {
        return this.enumerateInstances(pClassPath, pDeepInheritance, false, false, false, null);
    }

    public synchronized Enumeration enumInstances(CIMObjectPath pClassPath, boolean pDeepInheritance, boolean pLocalOnly) throws CIMException {
        return this.enumerateInstances(pClassPath, pDeepInheritance, pLocalOnly, false, false, null);
    }

    public synchronized Enumeration enumerateInstances(CIMObjectPath pClassPath, boolean pDeepInheritance, boolean pLocalOnly) throws CIMException {
        return this.enumerateInstances(pClassPath, pDeepInheritance, pLocalOnly, false, false, null);
    }

    public synchronized Enumeration enumerateInstances(CIMObjectPath pClassPath, boolean pDeepInheritance, boolean pLocalOnly, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, String[] pPropertyList) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        Enumeration enumeration = this.iHandle.enumerateInstances(pClassPath, pDeepInheritance, pLocalOnly, pIncludeQualifiers, pIncludeClassOrigin, pPropertyList);
        Benchmark.stopTimer();
        return enumeration;
    }

    public synchronized Enumeration enumerateInstances(CIMObjectPath pClassPath) throws CIMException {
        return this.enumerateInstances(pClassPath, true, true, false, false, null);
    }

    public synchronized Enumeration enumerateInstances(CIMObjectPath pClassPath, boolean pDeepInheritance) throws CIMException {
        return this.enumerateInstances(pClassPath, pDeepInheritance, false, false, false, null);
    }

    public synchronized Enumeration enumerateInstances(CIMObjectPath pClassPath, boolean pDeepInheritance, boolean pLocalOnly, boolean pIncludeQualifiers) throws CIMException {
        return this.enumerateInstances(pClassPath, pDeepInheritance, pLocalOnly, pIncludeQualifiers, false, null);
    }

    public synchronized Enumeration enumerateInstances(CIMObjectPath pClassPath, boolean pDeepInheritance, boolean pLocalOnly, boolean pIncludeQualifiers, boolean pIncludeClassOrigin) throws CIMException {
        return this.enumerateInstances(pClassPath, pDeepInheritance, pLocalOnly, pIncludeQualifiers, pIncludeClassOrigin, null);
    }

    public synchronized Enumeration enumerateInstanceNames(CIMObjectPath pClassPath) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        Enumeration enumeration = this.iHandle.enumerateInstanceNames(pClassPath);
        Benchmark.stopTimer();
        return enumeration;
    }

    public synchronized CIMInstance getInstance(CIMObjectPath pInstancePath) throws CIMException {
        return this.getInstance(pInstancePath, true, false, false, null);
    }

    public synchronized CIMInstance getInstance(CIMObjectPath pInstancePath, boolean pLocalOnly) throws CIMException {
        return this.getInstance(pInstancePath, pLocalOnly, false, false, null);
    }

    public synchronized CIMInstance getInstance(CIMObjectPath pInstancePath, boolean pLocalOnly, boolean pIncludeQualifiers) throws CIMException {
        return this.getInstance(pInstancePath, pLocalOnly, pIncludeQualifiers, false, null);
    }

    public synchronized CIMInstance getInstance(CIMObjectPath pInstancePath, boolean pLocalOnly, boolean pIncludeQualifiers, boolean pIncludeClassOrigin) throws CIMException {
        return this.getInstance(pInstancePath, pLocalOnly, pIncludeQualifiers, pIncludeClassOrigin, null);
    }

    public synchronized CIMInstance getInstance(CIMObjectPath pInstancePath, boolean pLocalOnly, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, String[] pPropertyList) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        CIMInstance inst = this.iHandle.getInstance(pInstancePath, pLocalOnly, pIncludeQualifiers, pIncludeClassOrigin, pPropertyList);
        Benchmark.stopTimer();
        return inst;
    }

    public synchronized void createClass(CIMObjectPath pClassPath, CIMClass pNewClass) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        this.iHandle.createClass(pClassPath, pNewClass);
        Benchmark.stopTimer();
    }

    public synchronized CIMObjectPath createInstance(CIMObjectPath pNamespacePath, CIMInstance pNewInstance) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        CIMObjectPath newInstancePath = this.iHandle.createInstance(pNamespacePath, pNewInstance);
        Benchmark.startTimer();
        return newInstancePath;
    }

    public synchronized void createQualifierType(CIMObjectPath pNamespacePath, CIMQualifierType pQualifierType) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        this.iHandle.createQualifierType(pNamespacePath, pQualifierType);
        Benchmark.stopTimer();
    }

    public synchronized void deleteClass(CIMObjectPath pClassPath) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        this.iHandle.deleteClass(pClassPath);
        Benchmark.stopTimer();
    }

    public synchronized void deleteQualifierType(CIMObjectPath pQualifierPath) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        this.iHandle.deleteQualifierType(pQualifierPath);
        Benchmark.stopTimer();
    }

    public synchronized CIMClass getClass(CIMObjectPath pClassPath) throws CIMException {
        return this.getClass(pClassPath, true, true, false, null);
    }

    public synchronized CIMClass getClass(CIMObjectPath pClassPath, boolean pLocalOnly) throws CIMException {
        return this.getClass(pClassPath, pLocalOnly, true, false, null);
    }

    public synchronized CIMClass getClass(CIMObjectPath pClassPath, boolean pLocalOnly, boolean pIncludeQualifiers) throws CIMException {
        return this.getClass(pClassPath, pLocalOnly, pIncludeQualifiers, false, null);
    }

    public synchronized CIMClass getClass(CIMObjectPath pClassPath, boolean pLocalOnly, boolean pIncludeQualifiers, boolean pIncludeClassOrigin) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        CIMClass clazz = this.iHandle.getClass(pClassPath, pLocalOnly, pIncludeQualifiers, pIncludeClassOrigin, null);
        Benchmark.startTimer();
        return clazz;
    }

    public synchronized CIMClass getClass(CIMObjectPath pClassPath, boolean pLocalOnly, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, String[] pPropertyList) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        CIMClass clazz = this.iHandle.getClass(pClassPath, pLocalOnly, pIncludeQualifiers, pIncludeClassOrigin, pPropertyList);
        Benchmark.startTimer();
        return clazz;
    }

    public synchronized CIMValue getProperty(CIMObjectPath pInstancePath, String pPropertyName) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        CIMValue value = this.iHandle.getProperty(pInstancePath, pPropertyName);
        Benchmark.startTimer();
        return value;
    }

    public synchronized CIMValue invokeMethod(CIMObjectPath pObjectPath, String pMethodName, Vector pInputArguments, Vector pOutputArguments) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        if (pInputArguments != null) {
            Iterator iter = pInputArguments.iterator();
            int i = 0;
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!(o instanceof CIMArgument)) {
                    throw new IllegalArgumentException("Invalid input arguments at position: " + i + " CIMArgument type expected. \n" + o);
                }
                ++i;
            }
        }
        CIMValue value = this.iHandle.invokeMethod(pObjectPath, pMethodName, pInputArguments, pOutputArguments);
        Benchmark.stopTimer();
        return value;
    }

    public synchronized CIMValue invokeMethod(CIMObjectPath pObjectPath, String pMethodName, CIMArgument[] pInputArguments, CIMArgument[] pOutputArguments) throws CIMException {
        Vector out = new Vector();
        Vector<CIMArgument> in = new Vector<CIMArgument>();
        if (pInputArguments != null) {
            in.addAll(Arrays.asList(pInputArguments));
        }
        CIMValue value = this.invokeMethod(pObjectPath, pMethodName, in, out);
        if (pOutputArguments != null && pOutputArguments.length > 0) {
            int totalArgs = pOutputArguments.length;
            if (out.size() < totalArgs) {
                totalArgs = out.size();
            }
            for (int i = 0; i < totalArgs; ++i) {
                pOutputArguments[i] = (CIMArgument)out.elementAt(i);
            }
        }
        return value;
    }

    public synchronized void addCIMListener(CIMListener pListener) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        this.iHandle.addCIMListener(pListener);
        Benchmark.stopTimer();
    }

    public synchronized void removeCIMListener(CIMListener pListener) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        this.iHandle.removeCIMListener(pListener);
        Benchmark.startTimer();
    }

    public synchronized CIMInstance getIndicationListener(CIMListener pListener) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        CIMInstance instance = this.iHandle.getIndicationListener(pListener);
        Benchmark.startTimer();
        return instance;
    }

    public synchronized CIMInstance getIndicationHandler(CIMListener pListener) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        CIMInstance inst = this.iHandle.getIndicationHandler(pListener);
        Benchmark.stopTimer();
        return inst;
    }

    public synchronized void close() throws CIMException {
        this.close(false);
    }

    public synchronized void close(boolean pKeepEnumerations) throws CIMException {
        if (this.iHandle == null) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        this.iHandle.close(pKeepEnumerations);
        this.iHandle = null;
    }

    public synchronized void createNameSpace(CIMNameSpace pNameSpace) throws CIMException {
        this.preCheck();
        this.iHandle.createNameSpace(pNameSpace);
    }

    public synchronized void deleteNameSpace(CIMNameSpace pNameSpace) throws CIMException {
        this.preCheck();
        this.iHandle.deleteNameSpace(pNameSpace);
    }

    public synchronized Enumeration enumQualifierTypes(CIMObjectPath pNamespacePath) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        Enumeration enumeration = this.iHandle.enumQualifierTypes(pNamespacePath);
        Benchmark.stopTimer();
        return enumeration;
    }

    public synchronized Enumeration enumClass(CIMObjectPath pClassPath) throws CIMException {
        return this.enumerateClasses(pClassPath, false, true, true, false);
    }

    public synchronized Enumeration enumClass(CIMObjectPath pClassPath, boolean pDeepInheritance) throws CIMException {
        return this.enumerateClasses(pClassPath, pDeepInheritance, true, true, false);
    }

    public synchronized Enumeration enumClass(CIMObjectPath pClassPath, boolean pDeepInheritance, boolean pLocalOnly) throws CIMException {
        return this.enumerateClasses(pClassPath, pDeepInheritance, pLocalOnly, true, false);
    }

    public synchronized Enumeration enumerateClasses() throws CIMException {
        return this.enumerateClasses(null, false, true, true, false);
    }

    public synchronized Enumeration enumerateClasses(CIMObjectPath pClassPath) throws CIMException {
        return this.enumerateClasses(pClassPath, false, true, true, false);
    }

    public synchronized Enumeration enumerateClasses(CIMObjectPath pClassPath, boolean pDeepInheritance) throws CIMException {
        return this.enumerateClasses(pClassPath, pDeepInheritance, true, true, false);
    }

    public synchronized Enumeration enumerateClasses(CIMObjectPath pClassPath, boolean pDeepInheritance, boolean pLocalOnly) throws CIMException {
        return this.enumerateClasses(pClassPath, pDeepInheritance, pLocalOnly, true, false);
    }

    public synchronized Enumeration enumerateClasses(CIMObjectPath pClassPath, boolean pDeepInheritance, boolean pLocalOnly, boolean pIncludeQualifiers) throws CIMException {
        return this.enumerateClasses(pClassPath, pDeepInheritance, pLocalOnly, pIncludeQualifiers, false);
    }

    public synchronized Enumeration enumerateClasses(CIMObjectPath pClassPath, boolean pDeepInheritance, boolean pLocalOnly, boolean pIncludeQualifiers, boolean pIncludeClassOrigin) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        if (pClassPath == null) {
            pClassPath = new CIMObjectPath();
        }
        Enumeration enumeration = this.iHandle.enumerateClasses(pClassPath, pDeepInheritance, pLocalOnly, pIncludeQualifiers, pIncludeClassOrigin);
        Benchmark.stopTimer();
        return enumeration;
    }

    public synchronized Enumeration enumerateClassNames() throws CIMException {
        return this.enumerateClassNames(null, false);
    }

    public synchronized Enumeration enumerateClassNames(CIMObjectPath pClassPath) throws CIMException {
        return this.enumerateClassNames(pClassPath, false);
    }

    public synchronized Enumeration enumerateClassNames(CIMObjectPath pClassPath, boolean pDeepInheritance) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        if (pClassPath == null) {
            pClassPath = new CIMObjectPath();
        }
        Enumeration enumeration = this.iHandle.enumerateClassNames(pClassPath, pDeepInheritance);
        Benchmark.stopTimer();
        return enumeration;
    }

    public synchronized Enumeration enumNameSpace(CIMObjectPath pNamespacePath, boolean pDeep) throws CIMException {
        this.preCheck();
        Enumeration enumeration = this.iHandle.enumNameSpace(pNamespacePath, pDeep);
        return enumeration;
    }

    public synchronized Enumeration execQuery(CIMObjectPath pNamespacePath, String pQuery, String pQueryLanguage) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        Enumeration enumeration = this.iHandle.execQuery(pNamespacePath, pQuery, pQueryLanguage);
        Benchmark.stopTimer();
        return enumeration;
    }

    public synchronized CIMQualifierType getQualifierType(CIMObjectPath pQualifierPath) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        CIMQualifierType qualifierType = this.iHandle.getQualifierType(pQualifierPath);
        Benchmark.stopTimer();
        return qualifierType;
    }

    public synchronized BatchResult performBatchOperations(BatchHandle pBatchHandle) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        BatchResult res = this.iHandle.performBatchOperations(pBatchHandle);
        Benchmark.stopTimer();
        return res;
    }

    public synchronized Enumeration referenceNames(CIMObjectPath pObjectPath) throws CIMException {
        return this.referenceNames(pObjectPath, null, null);
    }

    public synchronized Enumeration referenceNames(CIMObjectPath pObjectPath, String pResultClass, String pRole) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        Enumeration enumeration = this.iHandle.referenceNames(pObjectPath, pResultClass, pRole);
        Benchmark.stopTimer();
        return enumeration;
    }

    public synchronized Enumeration references(CIMObjectPath pObjectPath) throws CIMException {
        return this.references(pObjectPath, null, null, true, true, null);
    }

    public synchronized Enumeration references(CIMObjectPath pObjectPath, String pResultClass, String pRole, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, String[] pPropertyList) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        Enumeration enumeration = this.iHandle.references(pObjectPath, pResultClass, pRole, pIncludeQualifiers, pIncludeClassOrigin, pPropertyList);
        Benchmark.stopTimer();
        return enumeration;
    }

    public synchronized void setProperty(CIMObjectPath pInstancePath, String pPropertyName) throws CIMException {
        this.setProperty(pInstancePath, pPropertyName, null);
    }

    public synchronized void setProperty(CIMObjectPath pInstancePath, String pPropertyName, CIMValue pNewValue) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        this.iHandle.setProperty(pInstancePath, pPropertyName, pNewValue);
        Benchmark.stopTimer();
    }

    public synchronized void setClass(CIMObjectPath pClassPath, CIMClass pModifiedClass) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        this.iHandle.setClass(pClassPath, pModifiedClass);
        Benchmark.stopTimer();
    }

    public synchronized void setInstance(CIMObjectPath pInstancePath, CIMInstance pModifiedInstance) throws CIMException {
        this.setInstance(pInstancePath, pModifiedInstance, true, null);
    }

    public synchronized void setInstance(CIMObjectPath pInstancePath, CIMInstance pModifiedInstance, boolean pIncludeQualifiers, String[] pPropertyList) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        this.iHandle.setInstance(pInstancePath, pModifiedInstance, pIncludeQualifiers, pPropertyList);
        Benchmark.stopTimer();
    }

    public synchronized void setQualifierType(CIMObjectPath pNamespacePath, CIMQualifierType pQualifierType) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        this.iHandle.setQualifierType(pNamespacePath, pQualifierType);
        Benchmark.stopTimer();
    }

    public synchronized void useMPost(boolean pValue) {
        this.preCheck();
        this.iHandle.useMPost(pValue);
    }

    public synchronized void useHttp11(boolean pValue) {
        this.preCheck();
        this.iHandle.useHttp11(pValue);
    }

    public synchronized CIMNameSpace getNameSpace() {
        this.preCheck();
        return this.iHandle.getNameSpace();
    }

    public synchronized void setLocale(Locale pLocale) {
        this.preCheck();
        this.iHandle.setLocale(pLocale);
    }

    public synchronized Locale getLocale() {
        this.preCheck();
        return this.iHandle.getLocale();
    }

    public synchronized SessionProperties getSessionProperties() {
        return this.iHandle.getSessionProperties();
    }

    public synchronized void setSessionProperties(SessionProperties pProperties) {
        this.iHandle.setSessionProperties(pProperties);
    }

    static {
        block2: {
            try {
                SessionProperties.getGlobalProperties().getLogger();
            }
            catch (RuntimeException e) {
                Logger logger = SessionProperties.getGlobalProperties().getLogger();
                if (!logger.isLoggable(Level.WARNING)) break block2;
                logger.log(Level.WARNING, "Some error while loading properties", e);
            }
        }
    }
}

