/*
 * Decompiled with CFR 0.152.
 */
package de.imedic.webrcp;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

class ProgressDialog
extends JDialog {
    private JLabel taskLabel;
    private JProgressBar progressBar;
    private boolean canceled = false;
    private static final Font HEAD_FONT = new Font("SansSerif", 1, 18);
    private static final Font LABEL_FONT = new Font("SansSerif", 0, 15);
    private static final Color BGCOLOR = new Color(230, 230, 230);
    private static final int HEIGHT = 168;
    private static final int WIDTH = 500;

    public ProgressDialog() {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createRaisedBevelBorder());
        panel.setBackground(BGCOLOR);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("eclipse.png"));
        JLabel iconLabel = new JLabel(icon);
        iconLabel.setBounds(2, 2, 115, 164);
        panel.add(iconLabel);
        JLabel headLabel = new JLabel("WebRCP Launcher");
        headLabel.setFont(HEAD_FONT);
        headLabel.setBounds(127, 15, 360, 30);
        panel.add(headLabel);
        this.taskLabel = new JLabel();
        this.taskLabel.setFont(LABEL_FONT);
        this.taskLabel.setBounds(127, 50, 360, 30);
        panel.add(this.taskLabel);
        this.progressBar = new JProgressBar();
        this.progressBar.setFont(LABEL_FONT);
        this.progressBar.setBounds(127, 83, 360, 25);
        panel.add(this.progressBar);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setFont(LABEL_FONT);
        cancelButton.setBounds(388, 125, 100, 30);
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("Progress canceled");
                ProgressDialog.this.canceled = true;
                ProgressDialog.this.setVisible(false);
            }
        });
        panel.add(cancelButton);
        this.setContentPane(panel);
        this.setResizable(false);
        this.setUndecorated(true);
        this.setSize(500, 168);
        this.setTitle("WebRCP Launcher");
        this.setLocationRelativeTo(null);
        this.startTask("Loading...");
        this.setVisible(true);
    }

    public void worked(int value) {
        this.progressBar.setValue(value += this.progressBar.getValue());
        this.progressBar.setString(100 * value / this.progressBar.getMaximum() + "% finished");
    }

    public void startTask(String taskName, int total) {
        this.taskLabel.setText(taskName);
        this.progressBar.setValue(0);
        this.progressBar.setMaximum(total);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setStringPainted(true);
        this.worked(0);
    }

    public void startTask(String taskName) {
        this.taskLabel.setText(taskName);
        if (!this.progressBar.isIndeterminate()) {
            this.progressBar.setIndeterminate(true);
            this.progressBar.setStringPainted(false);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

