/*
 * Decompiled with CFR 0.152.
 */
package de.imedic.webrcp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

class UnpackThread
extends Thread {
    private List fileList;
    private File destDir;
    private boolean running;

    public UnpackThread(File destDir) {
        this.destDir = destDir;
        this.fileList = new Vector();
        this.running = true;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.running || !this.fileList.isEmpty()) {
            if (this.fileList.isEmpty()) {
                UnpackThread unpackThread = this;
                synchronized (unpackThread) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.fileList.isEmpty()) {
                return;
            }
            this.unpackFile((File)this.fileList.remove(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(File file) {
        this.fileList.add(file);
        UnpackThread unpackThread = this;
        synchronized (unpackThread) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        this.running = false;
        UnpackThread unpackThread = this;
        synchronized (unpackThread) {
            this.notifyAll();
        }
        try {
            this.join();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    private void unpackFile(final File file) {
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                int size;
                ZipEntry entry = entries.nextElement();
                File entryFile = new File(this.destDir, entry.getName());
                if (entryFile.exists()) continue;
                if (entry.isDirectory()) {
                    entryFile.mkdirs();
                    if (entryFile.exists() && entryFile.isDirectory()) continue;
                    throw new IOException("Could not create directory: " + entryFile);
                }
                entryFile.getParentFile().mkdirs();
                InputStream in = zipFile.getInputStream(entry);
                FileOutputStream out = new FileOutputStream(entryFile);
                byte[] buffer = new byte[32768];
                while ((size = in.read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, size);
                }
                in.close();
                ((OutputStream)out).close();
            }
            zipFile.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(null, "Zip file " + file + " could not be extracted: " + ex, "Extraction Error", 0);
                    }
                });
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
                throw new RuntimeException(ex2);
            }
            System.exit(1);
        }
    }
}

