/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc.remote;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.ObjectName;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.resource.Referenceable;
import javax.sql.DataSource;
import org.jboss.deployment.DeploymentException;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.logging.Logger;
import org.jboss.proxy.GenericProxyFactory;
import org.jboss.resource.adapter.jdbc.remote.DataSourceFactory;
import org.jboss.resource.adapter.jdbc.remote.SerializableInputStream;
import org.jboss.resource.adapter.jdbc.remote.SerializableParameterMetaData;
import org.jboss.resource.adapter.jdbc.remote.SerializableResultSetMetaData;
import org.jboss.resource.adapter.jdbc.remote.WrapperDataSourceServiceMBean;
import org.jboss.resource.connectionmanager.ConnectionFactoryBindingService;
import org.jboss.system.Registry;
import org.jboss.util.naming.NonSerializableFactory;
import org.jboss.util.naming.Util;

public class WrapperDataSourceService
extends ConnectionFactoryBindingService
implements WrapperDataSourceServiceMBean {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$resource$adapter$jdbc$remote$WrapperDataSourceService == null ? (class$org$jboss$resource$adapter$jdbc$remote$WrapperDataSourceService = WrapperDataSourceService.class$("org.jboss.resource.adapter.jdbc.remote.WrapperDataSourceService")) : class$org$jboss$resource$adapter$jdbc$remote$WrapperDataSourceService));
    private ObjectName jmxInvokerName;
    private Invoker delegateInvoker;
    private Object theProxy;
    private HashMap marshalledInvocationMapping = new HashMap();
    private HashMap connectionMap = new HashMap();
    private HashMap statementMap = new HashMap();
    private HashMap resultSetMap = new HashMap();
    private HashMap databaseMetaDataMap = new HashMap();
    private boolean trace = log.isTraceEnabled();
    static /* synthetic */ Class class$org$jboss$resource$adapter$jdbc$remote$WrapperDataSourceService;
    static /* synthetic */ Class class$org$jboss$resource$adapter$jdbc$remote$DataSourceFactory;
    static /* synthetic */ Class class$javax$sql$DataSource;
    static /* synthetic */ Class class$java$sql$Connection;
    static /* synthetic */ Class class$java$sql$Statement;
    static /* synthetic */ Class class$java$sql$PreparedStatement;
    static /* synthetic */ Class class$java$sql$CallableStatement;
    static /* synthetic */ Class class$java$sql$ResultSet;
    static /* synthetic */ Class class$java$sql$DatabaseMetaData;
    static /* synthetic */ Class class$org$jboss$proxy$ClientMethodInterceptor;
    static /* synthetic */ Class class$org$jboss$invocation$InvokerInterceptor;
    static /* synthetic */ Class class$org$jboss$resource$adapter$jdbc$remote$StatementInterceptor;

    protected void startService() throws Exception {
        this.determineBindName();
        this.createConnectionFactory();
        if (this.jmxInvokerName != null) {
            this.createProxy();
            this.calculateMethodHases();
            this.bindConnectionFactory();
        } else {
            super.bindConnectionFactory();
        }
    }

    protected void stopService() throws Exception {
        this.unbindConnectionFactory();
        if (this.jmxInvokerName != null) {
            this.destroyProxy();
        }
    }

    protected void bindConnectionFactory() throws Exception {
        InitialContext ctx = new InitialContext();
        try {
            log.debug((Object)("Binding object '" + this.cf + "' into JNDI at '" + this.bindName + "'"));
            NonSerializableFactory.rebind((String)this.bindName, (Object)this.cf);
            Referenceable referenceable = (Referenceable)this.cf;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.theProxy);
            oos.close();
            byte[] proxyBytes = baos.toByteArray();
            BinaryRefAddr dsAddr = new BinaryRefAddr("ProxyData", proxyBytes);
            String factory = (class$org$jboss$resource$adapter$jdbc$remote$DataSourceFactory == null ? (class$org$jboss$resource$adapter$jdbc$remote$DataSourceFactory = WrapperDataSourceService.class$("org.jboss.resource.adapter.jdbc.remote.DataSourceFactory")) : class$org$jboss$resource$adapter$jdbc$remote$DataSourceFactory).getName();
            Reference dsRef = new Reference("javax.sql.DataSource", dsAddr, factory, null);
            referenceable.setReference(dsRef);
            baos.reset();
            ObjectOutputStream oos2 = new ObjectOutputStream(baos);
            oos2.writeObject(DataSourceFactory.vmID);
            oos2.close();
            byte[] id = baos.toByteArray();
            BinaryRefAddr localAddr = new BinaryRefAddr("VMID", id);
            dsRef.add(localAddr);
            StringRefAddr jndiRef = new StringRefAddr("JndiName", this.bindName);
            dsRef.add(jndiRef);
            Util.rebind((Context)ctx, (String)this.bindName, (Object)this.cf);
            log.info((Object)("Bound ConnectionManager '" + this.serviceName + "' to JNDI name '" + this.bindName + "'"));
        }
        catch (NamingException ne) {
            throw new DeploymentException("Could not bind ConnectionFactory into jndi: " + this.bindName, (Throwable)ne);
        }
        finally {
            ctx.close();
        }
    }

    public ObjectName getJMXInvokerName() {
        return this.jmxInvokerName;
    }

    public void setJMXInvokerName(ObjectName jmxInvokerName) {
        this.jmxInvokerName = jmxInvokerName;
    }

    public Object invoke(Invocation invocation) throws Exception {
        Object value;
        block13: {
            if (invocation instanceof MarshalledInvocation) {
                MarshalledInvocation mi = (MarshalledInvocation)invocation;
                mi.setMethodMap((Map)this.marshalledInvocationMapping);
            }
            Method method = invocation.getMethod();
            Class<?> methodClass = method.getDeclaringClass();
            Object[] args = invocation.getArguments();
            value = null;
            try {
                if (methodClass.isAssignableFrom(class$javax$sql$DataSource == null ? (class$javax$sql$DataSource = WrapperDataSourceService.class$("javax.sql.DataSource")) : class$javax$sql$DataSource)) {
                    InitialContext ctx = new InitialContext();
                    DataSource ds = (DataSource)ctx.lookup(this.bindName);
                    value = this.doDataSourceMethod(ds, method, args);
                    break block13;
                }
                if (methodClass.isAssignableFrom(class$java$sql$Connection == null ? (class$java$sql$Connection = WrapperDataSourceService.class$("java.sql.Connection")) : class$java$sql$Connection)) {
                    Integer id = (Integer)invocation.getId();
                    Connection conn = (Connection)this.connectionMap.get(id);
                    if (conn == null) {
                        throw new IllegalAccessException("Failed to find connection: " + id);
                    }
                    value = this.doConnectionMethod(conn, method, args);
                    break block13;
                }
                if (methodClass.isAssignableFrom(class$java$sql$Statement == null ? (class$java$sql$Statement = WrapperDataSourceService.class$("java.sql.Statement")) : class$java$sql$Statement) || methodClass.isAssignableFrom(class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = WrapperDataSourceService.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement) || methodClass.isAssignableFrom(class$java$sql$CallableStatement == null ? (class$java$sql$CallableStatement = WrapperDataSourceService.class$("java.sql.CallableStatement")) : class$java$sql$CallableStatement)) {
                    Integer id = (Integer)invocation.getId();
                    Statement stmt = (Statement)this.statementMap.get(id);
                    if (stmt == null) {
                        throw new SQLException("Failed to find Statement: " + id);
                    }
                    value = this.doStatementMethod(stmt, method, args);
                    break block13;
                }
                if (methodClass.isAssignableFrom(class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = WrapperDataSourceService.class$("java.sql.ResultSet")) : class$java$sql$ResultSet)) {
                    Integer id = (Integer)invocation.getId();
                    ResultSet results = (ResultSet)this.resultSetMap.get(id);
                    if (results == null) {
                        throw new IllegalAccessException("Failed to find ResultSet: " + id);
                    }
                    value = this.doResultSetMethod(results, method, args);
                    break block13;
                }
                if (methodClass.isAssignableFrom(class$java$sql$DatabaseMetaData == null ? (class$java$sql$DatabaseMetaData = WrapperDataSourceService.class$("java.sql.DatabaseMetaData")) : class$java$sql$DatabaseMetaData)) {
                    Integer id = (Integer)invocation.getId();
                    DatabaseMetaData dbMetaData = (DatabaseMetaData)this.databaseMetaDataMap.get(id);
                    if (dbMetaData == null) {
                        throw new IllegalAccessException("Failed to find DatabaseMetaData: " + id);
                    }
                    value = this.doDatabaseMetaDataMethod(dbMetaData, method, args);
                    break block13;
                }
                throw new UnsupportedOperationException("Do not know how to handle method=" + method);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw new UndeclaredThrowableException(t, method.toString());
            }
        }
        return value;
    }

    protected void createProxy() throws Exception {
        this.delegateInvoker = (Invoker)Registry.lookup((Object)this.jmxInvokerName);
        log.debug((Object)("Using delegate: " + this.delegateInvoker + " for invoker=" + this.jmxInvokerName));
        ObjectName targetName = this.getServiceName();
        Integer nameHash = new Integer(targetName.hashCode());
        Registry.bind((Object)nameHash, (Object)targetName);
        Object cacheID = null;
        String proxyBindingName = null;
        String jndiName = null;
        Class[] ifaces = new Class[]{class$javax$sql$DataSource == null ? (class$javax$sql$DataSource = WrapperDataSourceService.class$("javax.sql.DataSource")) : class$javax$sql$DataSource};
        ArrayList<Class> interceptorClasses = new ArrayList<Class>();
        interceptorClasses.add(class$org$jboss$proxy$ClientMethodInterceptor == null ? (class$org$jboss$proxy$ClientMethodInterceptor = WrapperDataSourceService.class$("org.jboss.proxy.ClientMethodInterceptor")) : class$org$jboss$proxy$ClientMethodInterceptor);
        interceptorClasses.add(class$org$jboss$invocation$InvokerInterceptor == null ? (class$org$jboss$invocation$InvokerInterceptor = WrapperDataSourceService.class$("org.jboss.invocation.InvokerInterceptor")) : class$org$jboss$invocation$InvokerInterceptor);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        GenericProxyFactory proxyFactory = new GenericProxyFactory();
        this.theProxy = proxyFactory.createProxy(cacheID, targetName, this.delegateInvoker, jndiName, proxyBindingName, interceptorClasses, loader, ifaces);
        log.debug((Object)("Created proxy for invoker=" + this.jmxInvokerName + ", targetName=" + targetName + ", nameHash=" + nameHash));
    }

    protected void destroyProxy() throws Exception {
        ObjectName name = this.getServiceName();
        Integer nameHash = new Integer(name.hashCode());
        Registry.unbind((Object)nameHash);
    }

    protected void calculateMethodHases() throws Exception {
        Method[] methods = (class$javax$sql$DataSource == null ? (class$javax$sql$DataSource = WrapperDataSourceService.class$("javax.sql.DataSource")) : class$javax$sql$DataSource).getMethods();
        for (int m = 0; m < methods.length; ++m) {
            Method method = methods[m];
            Long hash = new Long(MarshalledInvocation.calculateHash((Method)method));
            this.marshalledInvocationMapping.put(hash, method);
        }
        Map m = MarshalledInvocation.methodToHashesMap((Class)(class$java$sql$Connection == null ? (class$java$sql$Connection = WrapperDataSourceService.class$("java.sql.Connection")) : class$java$sql$Connection));
        this.displayHashes(m);
        this.marshalledInvocationMapping.putAll(m);
        m = MarshalledInvocation.methodToHashesMap((Class)(class$java$sql$Statement == null ? (class$java$sql$Statement = WrapperDataSourceService.class$("java.sql.Statement")) : class$java$sql$Statement));
        this.displayHashes(m);
        this.marshalledInvocationMapping.putAll(m);
        m = MarshalledInvocation.methodToHashesMap((Class)(class$java$sql$CallableStatement == null ? (class$java$sql$CallableStatement = WrapperDataSourceService.class$("java.sql.CallableStatement")) : class$java$sql$CallableStatement));
        this.displayHashes(m);
        this.marshalledInvocationMapping.putAll(m);
        m = MarshalledInvocation.methodToHashesMap((Class)(class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = WrapperDataSourceService.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement));
        this.displayHashes(m);
        this.marshalledInvocationMapping.putAll(m);
        m = MarshalledInvocation.methodToHashesMap((Class)(class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = WrapperDataSourceService.class$("java.sql.ResultSet")) : class$java$sql$ResultSet));
        this.displayHashes(m);
        this.marshalledInvocationMapping.putAll(m);
        m = MarshalledInvocation.methodToHashesMap((Class)(class$java$sql$DatabaseMetaData == null ? (class$java$sql$DatabaseMetaData = WrapperDataSourceService.class$("java.sql.DatabaseMetaData")) : class$java$sql$DatabaseMetaData));
        this.displayHashes(m);
        this.marshalledInvocationMapping.putAll(m);
    }

    private Object doDataSourceMethod(DataSource ds, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
        Object value = method.invoke((Object)ds, args);
        if (value instanceof Connection) {
            value = this.createConnectionProxy(value);
        } else if (value != null && !(value instanceof Serializable)) {
            throw new IllegalAccessException("Method=" + method + " does not return Serializable");
        }
        return value;
    }

    private Object doConnectionMethod(Connection conn, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException, SQLException {
        Object value;
        if (this.trace) {
            log.trace((Object)("doConnectionMethod, conn=" + conn + ", method=" + method));
        }
        if ((value = method.invoke((Object)conn, args)) instanceof Statement) {
            value = this.createStatementProxy(value);
        } else if (value instanceof DatabaseMetaData) {
            value = this.createDatabaseMetaData(value);
        } else if (value != null && !(value instanceof Serializable)) {
            throw new IllegalAccessException("Method=" + method + " does not return Serializable");
        }
        return value;
    }

    private Object doStatementMethod(Statement stmt, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException, SQLException {
        Object value;
        if (this.trace) {
            log.trace((Object)("doStatementMethod, conn=" + stmt + ", method=" + method));
        }
        if (method.getName().equals("close")) {
            Integer id = new Integer(stmt.hashCode());
            this.statementMap.remove(id);
            log.debug((Object)("Closed Statement=" + id));
        }
        if ((value = method.invoke((Object)stmt, args)) instanceof ResultSet) {
            value = this.createResultSetProxy(value);
        } else if (value instanceof ResultSetMetaData) {
            ResultSetMetaData rmd = (ResultSetMetaData)value;
            value = new SerializableResultSetMetaData(rmd);
        } else if (value instanceof ParameterMetaData) {
            ParameterMetaData pmd = (ParameterMetaData)value;
            value = new SerializableParameterMetaData(pmd);
        } else if (value != null && !(value instanceof Serializable)) {
            throw new IllegalAccessException("Method=" + method + " does not return Serializable");
        }
        return value;
    }

    private Object doResultSetMethod(ResultSet results, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException, SQLException, IOException {
        Object value;
        if (this.trace) {
            log.trace((Object)("doStatementMethod, results=" + results + ", method=" + method));
        }
        if (method.getName().equals("close")) {
            Integer id = new Integer(results.hashCode());
            this.resultSetMap.remove(id);
            log.debug((Object)("Closed ResultSet=" + id));
        }
        if ((value = method.invoke((Object)results, args)) instanceof ResultSetMetaData) {
            ResultSetMetaData rmd = (ResultSetMetaData)value;
            value = new SerializableResultSetMetaData(rmd);
        }
        if ("getAsciiStream".equals(method.getName()) && value instanceof InputStream) {
            InputStream ins = (InputStream)value;
            value = new SerializableInputStream(ins);
        }
        if (value != null && !(value instanceof Serializable)) {
            throw new IllegalAccessException("Method=" + method + " does not return Serializable");
        }
        return value;
    }

    private Object doDatabaseMetaDataMethod(DatabaseMetaData dbMetaData, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
        Object value;
        if (this.trace) {
            log.trace((Object)("doDatabaseMetaDataMethod, dbMetaData=" + dbMetaData + ", method=" + method));
        }
        if ((value = method.invoke((Object)dbMetaData, args)) instanceof ResultSet) {
            value = this.createResultSetProxy(value);
        } else if (value instanceof Connection) {
            value = this.createConnectionProxy(value);
        }
        if (value != null && !(value instanceof Serializable)) {
            throw new IllegalAccessException("Method=" + method + " does not return Serializable");
        }
        return value;
    }

    private Object createConnectionProxy(Object conn) {
        Integer cacheID = new Integer(conn.hashCode());
        ObjectName targetName = this.getServiceName();
        String proxyBindingName = null;
        String jndiName = null;
        Class[] ifaces = new Class[]{class$java$sql$Connection == null ? (class$java$sql$Connection = WrapperDataSourceService.class$("java.sql.Connection")) : class$java$sql$Connection};
        ArrayList<Class> interceptorClasses = new ArrayList<Class>();
        interceptorClasses.add(class$org$jboss$proxy$ClientMethodInterceptor == null ? (class$org$jboss$proxy$ClientMethodInterceptor = WrapperDataSourceService.class$("org.jboss.proxy.ClientMethodInterceptor")) : class$org$jboss$proxy$ClientMethodInterceptor);
        interceptorClasses.add(class$org$jboss$invocation$InvokerInterceptor == null ? (class$org$jboss$invocation$InvokerInterceptor = WrapperDataSourceService.class$("org.jboss.invocation.InvokerInterceptor")) : class$org$jboss$invocation$InvokerInterceptor);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        GenericProxyFactory proxyFactory = new GenericProxyFactory();
        Object connProxy = proxyFactory.createProxy((Object)cacheID, targetName, this.delegateInvoker, jndiName, proxyBindingName, interceptorClasses, loader, ifaces);
        this.connectionMap.put(cacheID, conn);
        log.debug((Object)("Created Connection proxy for invoker=" + this.jmxInvokerName + ", targetName=" + targetName + ", cacheID=" + cacheID));
        return connProxy;
    }

    private Object createStatementProxy(Object stmt) {
        Integer cacheID = new Integer(stmt.hashCode());
        ObjectName targetName = this.getServiceName();
        String proxyBindingName = null;
        String jndiName = null;
        Class[] ifaces = stmt.getClass().getInterfaces();
        ArrayList tmp = new ArrayList();
        for (int i = 0; i < ifaces.length; ++i) {
            Class<?> c = ifaces[i];
            if (!c.getName().startsWith("java")) continue;
            tmp.add(c);
        }
        ifaces = new Class[tmp.size()];
        tmp.toArray(ifaces);
        ArrayList<Class> interceptorClasses = new ArrayList<Class>();
        interceptorClasses.add(class$org$jboss$resource$adapter$jdbc$remote$StatementInterceptor == null ? (class$org$jboss$resource$adapter$jdbc$remote$StatementInterceptor = WrapperDataSourceService.class$("org.jboss.resource.adapter.jdbc.remote.StatementInterceptor")) : class$org$jboss$resource$adapter$jdbc$remote$StatementInterceptor);
        interceptorClasses.add(class$org$jboss$proxy$ClientMethodInterceptor == null ? (class$org$jboss$proxy$ClientMethodInterceptor = WrapperDataSourceService.class$("org.jboss.proxy.ClientMethodInterceptor")) : class$org$jboss$proxy$ClientMethodInterceptor);
        interceptorClasses.add(class$org$jboss$invocation$InvokerInterceptor == null ? (class$org$jboss$invocation$InvokerInterceptor = WrapperDataSourceService.class$("org.jboss.invocation.InvokerInterceptor")) : class$org$jboss$invocation$InvokerInterceptor);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        GenericProxyFactory proxyFactory = new GenericProxyFactory();
        Object stmtProxy = proxyFactory.createProxy((Object)cacheID, targetName, this.delegateInvoker, jndiName, proxyBindingName, interceptorClasses, loader, ifaces);
        this.statementMap.put(cacheID, stmt);
        log.debug((Object)("Created Statement proxy for invoker=" + this.jmxInvokerName + ", targetName=" + targetName + ", cacheID=" + cacheID));
        return stmtProxy;
    }

    private Object createResultSetProxy(Object results) {
        Integer cacheID = new Integer(results.hashCode());
        ObjectName targetName = this.getServiceName();
        String proxyBindingName = null;
        String jndiName = null;
        Class[] ifaces = results.getClass().getInterfaces();
        ArrayList<Class> interceptorClasses = new ArrayList<Class>();
        interceptorClasses.add(class$org$jboss$proxy$ClientMethodInterceptor == null ? (class$org$jboss$proxy$ClientMethodInterceptor = WrapperDataSourceService.class$("org.jboss.proxy.ClientMethodInterceptor")) : class$org$jboss$proxy$ClientMethodInterceptor);
        interceptorClasses.add(class$org$jboss$invocation$InvokerInterceptor == null ? (class$org$jboss$invocation$InvokerInterceptor = WrapperDataSourceService.class$("org.jboss.invocation.InvokerInterceptor")) : class$org$jboss$invocation$InvokerInterceptor);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        GenericProxyFactory proxyFactory = new GenericProxyFactory();
        Object resultsProxy = proxyFactory.createProxy((Object)cacheID, targetName, this.delegateInvoker, jndiName, proxyBindingName, interceptorClasses, loader, ifaces);
        this.resultSetMap.put(cacheID, results);
        log.debug((Object)("Created ResultSet proxy for invoker=" + this.jmxInvokerName + ", targetName=" + targetName + ", cacheID=" + cacheID));
        return resultsProxy;
    }

    private Object createDatabaseMetaData(Object dbMetaData) {
        Integer cacheID = new Integer(dbMetaData.hashCode());
        ObjectName targetName = this.getServiceName();
        String proxyBindingName = null;
        String jndiName = null;
        Class[] ifaces = new Class[]{class$java$sql$DatabaseMetaData == null ? (class$java$sql$DatabaseMetaData = WrapperDataSourceService.class$("java.sql.DatabaseMetaData")) : class$java$sql$DatabaseMetaData};
        ArrayList<Class> interceptorClasses = new ArrayList<Class>();
        interceptorClasses.add(class$org$jboss$proxy$ClientMethodInterceptor == null ? (class$org$jboss$proxy$ClientMethodInterceptor = WrapperDataSourceService.class$("org.jboss.proxy.ClientMethodInterceptor")) : class$org$jboss$proxy$ClientMethodInterceptor);
        interceptorClasses.add(class$org$jboss$invocation$InvokerInterceptor == null ? (class$org$jboss$invocation$InvokerInterceptor = WrapperDataSourceService.class$("org.jboss.invocation.InvokerInterceptor")) : class$org$jboss$invocation$InvokerInterceptor);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        GenericProxyFactory proxyFactory = new GenericProxyFactory();
        Object dbMetaDataProxy = proxyFactory.createProxy((Object)cacheID, targetName, this.delegateInvoker, jndiName, proxyBindingName, interceptorClasses, loader, ifaces);
        this.databaseMetaDataMap.put(cacheID, dbMetaData);
        log.debug((Object)("Created DatabaseMetadata proxy for invoker=" + this.jmxInvokerName + ", targetName=" + targetName + ", cacheID=" + cacheID));
        return dbMetaDataProxy;
    }

    private void displayHashes(Map m) {
        if (!this.trace) {
            return;
        }
        Iterator keys = m.keySet().iterator();
        while (keys.hasNext()) {
            Long key = (Long)keys.next();
            log.trace((Object)(key + "=" + m.get(key)));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

