/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.vm;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.postgresforest.ds.common.BaseDataSource;

public abstract class AbstractForestBaseSource
extends BaseDataSource {
    private transient PrintWriter logger;
    public static final int CON_ROUND_ROBIN = 0;
    public static final int CON_FIX = 1;
    private String m_GSC = "localhost";
    private int m_Cache_Reflesh = 40;
    private int m_Defect_Timeout = 300;
    private int m_Retry_Count = 0;
    private int m_Distributed_Connection = 0;
    private String m_Hash_Class = "org.postgresforest.vm.Hash01";

    public String getHash_Class() {
        return this.m_Hash_Class;
    }

    public String getGSC() {
        return this.m_GSC;
    }

    public void setHash_Class(String string) {
        this.m_Hash_Class = string;
    }

    public void setGSC(String string) {
        this.m_GSC = string;
    }

    public int getCache_Reflesh() {
        return this.m_Cache_Reflesh;
    }

    public int getDefect_Timeout() {
        return this.m_Defect_Timeout;
    }

    public int getDistributed_Connection() {
        return this.m_Distributed_Connection;
    }

    public void setCache_Reflesh(int i) {
        this.m_Cache_Reflesh = i;
    }

    public void setDefect_Timeout(int i) {
        this.m_Defect_Timeout = i;
    }

    public void setDistributed_Connection(int i) {
        this.m_Distributed_Connection = i;
    }

    public Reference getReference() throws NamingException {
        Reference ref = super.getReference();
        ref.add(new StringRefAddr("GSC", this.m_GSC));
        ref.add(new StringRefAddr("Cache_Reflesh", Integer.toString(this.m_Cache_Reflesh)));
        ref.add(new StringRefAddr("Defect_Timeout", Integer.toString(this.m_Defect_Timeout)));
        ref.add(new StringRefAddr("Distributed_Connection", Integer.toString(this.m_Distributed_Connection)));
        ref.add(new StringRefAddr("Hash_Class", this.m_Hash_Class));
        ref.add(new StringRefAddr("Distributed_Connection", Integer.toString(this.m_Distributed_Connection)));
        ref.add(new StringRefAddr("Retry_Count", Integer.toString(this.m_Retry_Count)));
        return ref;
    }

    public Connection getConnection(String user, String password) throws SQLException {
        try {
            Connection con = DriverManager.getConnection(this.getUrl(), user, password);
            if (this.logger != null) {
                this.logger.println("Created a non-pooled connection for " + user + " at " + this.getUrl());
            }
            return con;
        }
        catch (SQLException e) {
            if (this.logger != null) {
                this.logger.println("Failed to create a non-pooled connection for " + user + " at " + this.getUrl() + ": " + e);
            }
            throw e;
        }
    }

    private String getUrl() {
        StringBuffer url = new StringBuffer("jdbc:postgresql:datasource:");
        url.append("GSC=");
        url.append(this.m_GSC);
        url.append(";");
        url.append("Cache_Reflesh=");
        url.append(this.m_Cache_Reflesh);
        url.append(";");
        url.append("Defect_Timeout=");
        url.append(this.m_Defect_Timeout);
        url.append(";");
        url.append("Distributed_Connection=");
        url.append(this.m_Distributed_Connection);
        url.append(";");
        url.append("Hash_Class=");
        url.append(this.m_Hash_Class);
        url.append(";");
        url.append("Retry_Count=");
        url.append(this.m_Retry_Count);
        url.append("@");
        url.append(this.getDatabaseName());
        return url.toString();
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.logger = printWriter;
        super.setLogWriter(printWriter);
    }

    public int getRetry_Count() {
        return this.m_Retry_Count;
    }

    public void setRetry_Count(int i) {
        this.m_Retry_Count = i;
    }
}

