/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.vm;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.postgresforest.Driver;
import org.postgresforest.jdbc3.AbstractJdbc3Connection;
import org.postgresforest.vm.Parser;
import org.postgresforest.vm.QueryInfo;
import org.postgresforest.vm.ReWriter;
import org.postgresforest.vm.gsc.GscData;

public class MetaDataReWriter
extends ReWriter {
    public MetaDataReWriter(GscData gsc) {
        super(gsc);
    }

    public void rewrite(Parser parser) throws SQLException {
        this.clearSrcSql();
        this.m_paser = parser;
        this.m_srcSql = this.m_paser.getSrcSql();
        this.makeSelectQuery(this.m_paser);
        if (Driver.logInfo) {
            for (int i = 0; i < this.m_info.size(); ++i) {
                QueryInfo qi = (QueryInfo)this.m_info.get(i);
                AbstractJdbc3Connection con = (AbstractJdbc3Connection)qi.getConnection();
                this.m_logUtil.info("ReWriter Result: Connection URL = " + con.getURL());
                this.m_logUtil.info("ReWriter Result: Partition No = " + qi.getPartNo());
                this.m_logUtil.info("ReWriter Result: The rewritten SQL = " + qi.getSql());
                String[] tables = qi.getTables();
                String allname = "";
                try {
                    for (int j = 0; j < tables.length; ++j) {
                        allname = allname + tables[j] + ",";
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.m_logUtil.info("ReWriter Result: Extraction Table Name = " + allname);
            }
        }
    }

    protected void makeSelectQuery(Parser ps) throws SQLException {
        if (Driver.forestTestLog) {
            System.out.println("The query type was specified to be dispersion.");
        }
        if (Driver.logInfo) {
            this.m_logUtil.info("The query type was specified to be dispersion.");
        }
        this.m_queyType = 1;
        Connection con = this.m_gsc.getDistServer();
        QueryInfo qf = new QueryInfo();
        qf.setConnection(con);
        qf.setSql(this.m_srcSql);
        this.m_info.add(qf);
    }

    protected void clearSrcSql() {
        this.m_srcSql = null;
        if (this.m_info == null) {
            this.m_info = new ArrayList();
        } else {
            this.m_info.clear();
        }
        this.m_queyType = -1;
    }
}

