/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.examples;

import java.net.InetAddress;
import org.opennms.protocols.snmp.SnmpHandler;
import org.opennms.protocols.snmp.SnmpParameters;
import org.opennms.protocols.snmp.SnmpPduBulk;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpSession;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpVarBind;

public class SnmpBulkRequestExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] st) throws Exception {
        if (st.length != 2) {
            System.out.println("Usage: java SnmpBulkRequestExample host oid...");
            System.exit(0);
        }
        InetAddress remote = InetAddress.getByName(st[0]);
        SnmpPeer peer = new SnmpPeer(remote);
        peer.setPort(161);
        peer.setTimeout(5000);
        peer.setRetries(1);
        SnmpParameters parms = peer.getParameters();
        parms.setVersion(1);
        parms.setReadCommunity("public");
        SnmpSession session = new SnmpSession(peer);
        session.setDefaultHandler(new SnmpHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void snmpTimeoutError(SnmpSession session, SnmpSyntax pdu) {
                System.out.println("SnmpTimeout");
                SnmpSession snmpSession = session;
                synchronized (snmpSession) {
                    session.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void snmpInternalError(SnmpSession session, int err, SnmpSyntax pdu) {
                System.out.println("InternalError");
                SnmpSession snmpSession = session;
                synchronized (snmpSession) {
                    session.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void snmpReceivedPdu(SnmpSession session, int command, SnmpPduPacket pdu) {
                int responseLength = pdu.getLength();
                for (int i = 0; i < responseLength; ++i) {
                    SnmpVarBind varBind = pdu.getVarBindAt(i);
                    System.out.println("Received value: " + varBind.getName() + "=" + varBind.getValue());
                }
                SnmpSession snmpSession = session;
                synchronized (snmpSession) {
                    session.notify();
                }
            }
        });
        SnmpVarBind[] vblist = new SnmpVarBind[st.length - 1];
        for (int i = 1; i < st.length; ++i) {
            vblist[i - 1] = new SnmpVarBind(st[i]);
        }
        int nonRepeaters = 0;
        int maxRepitition = 100;
        SnmpPduBulk requestPDU = new SnmpPduBulk(nonRepeaters, maxRepitition, vblist);
        requestPDU.setRequestId(1);
        try {
            SnmpSession snmpSession = session;
            synchronized (snmpSession) {
                session.send((SnmpPduPacket)requestPDU);
                session.wait();
            }
        }
        catch (InterruptedException e) {
        }
        finally {
            session.close();
        }
    }
}

