/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.util.apllog;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * プロパティユーティルクラス<BR>
 * 
 * メッセージ項目値が指定されている場合、メッセージの項目を置換します。
 * メッセージのプロパティはapllog_ja.properties,apllog_en.propertiesを参照してください。
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class PropertyUtil {
	private static final String RESOURCE_BUNDLE= "com.clustercontrol.util.apllog.apllog";
	private static ResourceBundle m_bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE);
	
	
	/**
	 * メッセージを置換します<BR>
	 * 
	 * @param key リソース名
	 * @param args メッセージの引数
	 * @return the メッセージ
	 */	
	public static String getString(String key, Object[] args) {
		return MessageFormat.format(getString(key),args);
	}
	
	/**
	 * メッセージを置換します<BR>
	 * 
	 * @param key リソース名
	 * @return the メッセージ
	 */	
	public static String getString(String key) {
		try {
			return m_bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}
	
	/**
	 * メッセージを置換します<BR>
	 * 
	 * @param key リソース名
	 * @param def デフォルト値
	 * @return メッセージ（失敗時にはデフォルト値）
	 */	
	public static String getString(String key, String def) {
		try {
			return m_bundle.getString(key);
		} catch (MissingResourceException e) {
			return def;
		}
	}
	

	
}
