/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.accesscontrol.ejb.session.AccessController;
import com.clustercontrol.accesscontrol.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * ユーザを削除するクライアント側アクションクラス<BR>
 * マネージャにSessionBean経由でアクセスし、<BR>
 * 指定されたユーザ用プロパティの情報を元に、ユーザを追加します。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class DeleteUserProperty {

    /**
     * マネージャにアクセスし、ユーザを削除します。
     * 
     * マネージャにSessionBean経由でアクセスし、<BR>
     * 指定されたユーザIDのユーザを削除します。
     * 
     * @param uid ユーザID
     * @return 削除に成功した場合、true
     * 
     * @see com.clustercontrol.accesscontrol.util.EjbConnectionManager
	 * @see com.clustercontrol.accesscontrol.ejb.session.AccessController#deleteUser(java.lang.String)
     */
    public boolean delete(String uid) {
		AccessController access = 
			EjbConnectionManager.getConnectionManager().getAccessController();
		
        try {
        	access.deleteUser(uid);
            return true;
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (FinderException e) {
        } catch (RemoveException e) {
        } catch (NamingException e) {
        }
        return false;
    }
}