/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.Locale;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.accesscontrol.ejb.session.AccessController;
import com.clustercontrol.accesscontrol.util.EjbConnectionManager;
import com.clustercontrol.bean.Property;
import com.clustercontrol.util.Messages;

/**
 * ユーザフィルタ用プロパティを取得するクライアント側アクションクラス<BR>
 * 
 * アクセス管理のユーザではフィルタを設定して<BR>
 * 条件にあるユーザのみを表示可能です。<BR>
 * そのプロパティを取得します。<B>R
 * （ロケールの関係があるので、ダイアログ生成情報も
 * マネージャから取得します。）
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class GetUserFilterProperty {

    /**
 
     * マネージャにSessionBean経由でアクセスし、<BR>
     * ユーザフィルタ用プロパティを取得します。
     * 
     * @return ユーザフィルタ用プロパティ
     * 
     * @see com.clustercontrol.accesscontrol.util.EjbConnectionManager
	 * @see com.clustercontrol.accesscontrol.ejb.session.AccessController#getUserFilterProperty(java.util.Locale)
     */
    public Property getProperty() {
        AccessController access = EjbConnectionManager
                .getConnectionManager().getAccessController();

        Property property = null;
        try {
            property = access.getUserFilterProperty(Locale.getDefault());
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        }
        return property;
    }
}