/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.dialog;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.composite.FacilityTreeComposite;
import com.clustercontrol.util.Messages;

/**
 * スコープツリーからスコープもしくはノードを選択するためのダイアログ<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ScopeTreeDialog extends CommonDialog {

    // ----- instance フィールド ----- //

    /** 選択されたアイテム */
    protected FacilityTreeComposite treeComposite = null;

    /**ノードをツリーに含めるかのフラグ**/
    protected boolean scopeOnly;
    /**未登録ノード　スコープを含めるかのフラグ**/
    protected boolean unregistered;

    // ----- コンストラクタ ----- //

    /**
     * ダイアログのインスタンスを返します。
     * 
     * @param parent
     *            親とするシェル
     */
    public ScopeTreeDialog(Shell parent) {
        super(parent);
        this.scopeOnly = false;
        //未登録ノードスコープはデフォルト非表示
        this.unregistered = false;
    }
    
    
    /**
     * ダイアログのインスタンスを返します。
     * 
     * @param parent
     *            親とするシェル
     * @param scopeOnly
     */
    public ScopeTreeDialog(Shell parent, boolean scopeOnly) {
        super(parent);
        this.scopeOnly = scopeOnly;
        //未登録ノードスコープはデフォルト非表示
        this.unregistered = false;
    }

    public ScopeTreeDialog(Shell parent, boolean scopeOnly, boolean unregistered){
    	 super(parent);
         this.scopeOnly = scopeOnly;
         //未登録ノードスコープはデフォルト非表示
         this.unregistered = unregistered;
    	
    }
    
    
    // ----- instance メソッド ----- //

    protected Point getInitialSize() {
        return new Point(400, 400);
    }

    protected void customizeDialog(Composite parent) {
        // タイトル
        parent.getShell().setText(Messages.getString("select.scope"));

        GridLayout layout = new GridLayout(5, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        treeComposite = new FacilityTreeComposite(parent, SWT.NONE, scopeOnly, unregistered, false);

        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 5;
        treeComposite.setLayoutData(gridData);

        // アイテムをダブルクリックした場合、それを選択したこととする。
        treeComposite.getTreeViewer().addDoubleClickListener(
                new IDoubleClickListener() {
                    public void doubleClick(DoubleClickEvent event) {
                        okPressed();
                    }
                });
    }

    public FacilityTreeItem getSelectItem() {
        return this.treeComposite.getSelectItem();
    }

    protected ValidateResult validate() {
        ValidateResult result = null;

        FacilityTreeItem item = this.getSelectItem();
        if (item instanceof FacilityTreeItem) {
            if (item.getData().getType() == FacilityConstant.TYPE_COMPOSITE) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString("message.hinemos.1"));
                result.setMessage(Messages.getString("message.hinemos.3"));
            }
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.hinemos.3"));
        }

        return result;
    }

    protected String getOkButtonText() {
        return Messages.getString("ok");
    }

    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }
}