/*
 
 Copyright (C) 2008 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.bean;

import com.clustercontrol.bean.EventConfirmConstant;

/**
 * 通知ログエスカレート情報を保持するクラスです。
 * 
 * @author yosuke
 * @version 3.0.0
 * @since 3.0.0
 */
public class NotifyLogEscalateInfo  extends NotifyInfoDetail
{
	private static final long serialVersionUID = -5089086735470199399L;
	

	/**転送メッセージ*/
	private String  m_escalateMessage;
	
	/**シスログ重要度*/
	private Integer m_syslogPriority;
	
	/**シスログファシリティ*/
	private Integer m_syslogFacility;
	
	/**転送先ファシリティフラグ*/
	private Integer m_esaclateFacilityFlg;
	
	/**転送先ファシリティID*/
	private String  m_escalateFacility;
	
	/**転送先スコープテキスト*/
	private String	m_escalateScope;
	
	/**転送先ポート*/
	private Integer m_escalatePort;
	
	/**
	 * コンストラクタ。
	 */
	public NotifyLogEscalateInfo(){
	}
	
	
	/**
	 * コンストラクタ。
	 * 
	 * @param notifyId 通知ID
	 * @param priority 重要度
	 * @param mailTemplateId メールテンプレートID
	 * @param vaildFlg イベント通知フラグ
	 * @param inhibitionFlg イベント抑制フラグ
	 * @param mailAddress メールアドレス（セミコロン区切り）
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.ValidConstant
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	public NotifyLogEscalateInfo(
			String notifyId,
			Integer priority,
			Integer vaildFlg,
			Integer inhibitionFlg,
			String escalateMessage,
			Integer syslogPriority,
			Integer syslogFacility,
			Integer escalateFacilityFlg,
			String  escalateFacility,
			String	escalateScope,
			Integer escalatePort) {
		
		setNotifyId(notifyId);
		setPriority(priority);
		setValidFlg(vaildFlg);
		setInhibitionFlg(inhibitionFlg);
		setEscalateMessage(escalateMessage);
		setSyslogPriority(syslogPriority);
		setSyslogFacility(syslogFacility);
		setEscalateFacilityFlg(escalateFacilityFlg);
		setEscalateFacility(escalateFacility);
		setEscalateScope(escalateScope);
		setEscalatePort(escalatePort);
	}
	
	/**
	 * コンストラクタ。
	 * 
	 * @param otherData コピー元の通知情報
	 */
	public NotifyLogEscalateInfo( NotifyLogEscalateInfo otherData ) {
		setNotifyId(otherData.getNotifyId());
		setPriority(otherData.getPriority());
		setValidFlg(otherData.getValidFlg());
		setInhibitionFlg(otherData.getInhibitionFlg());	
		setEscalateMessage(otherData.getEscalateMessage());
		setSyslogPriority(otherData.getSyslogPriority());
		setSyslogFacility(otherData.getSyslogFacility());
		setEscalateFacilityFlg(otherData.getEscalateFacilityFlg());
		setEscalateFacility(otherData.getEscalateFacility());
		setEscalateScope(otherData.getEscalateScope());
		setEscalatePort(otherData.getEscalatePort());
		
		
	}

	/**
	 * 転送メッセージを返します。
	 * 
	 * @return　転送メッセージ
	 */
	public String getEscalateMessage() {
		return m_escalateMessage;
	}

	/**
	 * 転送メッセージを設定します。
	 * 
	 * @param escalateMessage
	 */
	public void setEscalateMessage(String escalateMessage) {
		this.m_escalateMessage = escalateMessage;
	}

	/**
	 * シスログ重要度を返します。
	 * 
	 * @return シスログ重要度
	 */
	public Integer getSyslogPriority() {
		return m_syslogPriority;
	}

	/**
	 * シスログ重要度を設定します。
	 * 
	 * @param syslogPriority
	 */
	public void setSyslogPriority(Integer syslogPriority) {
		this.m_syslogPriority = syslogPriority;
	}

	/**
	 * シスログファシリティを返します。
	 * @return シスログファシリティ
	 */
	public Integer getSyslogFacility() {
		return m_syslogFacility;
	}

	/**
	 * シスログファシリティを設定します。
	 * 
	 * @param syslogFacility
	 */
	public void setSyslogFacility(Integer syslogFacility) {
		this.m_syslogFacility = syslogFacility;
	}

	/**
	 * 転送先ファシリティフラグを返します。
	 * 
	 * @return 転送先ファシリティフラグ
	 */
	public Integer getEscalateFacilityFlg() {
		return m_esaclateFacilityFlg;
	}

	/**
	 * 転送先ファシリティフラグを設定します。
	 * 
	 * @param esaclateFacilityFlg
	 */
	public void setEscalateFacilityFlg(Integer esaclateFacilityFlg) {
		this.m_esaclateFacilityFlg = esaclateFacilityFlg;
	}

	/**
	 * 転送先ファシリティを返します。
	 * 
	 * @return　転送先ファシリティ
	 */
	public String getEscalateFacility() {
		
		return m_escalateFacility;
	}

	/**
	 * 転送先ファシリティを設定します。
	 * 
	 * @param escalateFacility
	 */
	public void setEscalateFacility(String escalateFacility) {
		this.m_escalateFacility = escalateFacility;
	}

	/**
	 * 転送先スコープを返します。
	 * 
	 * @return　転送先スコープ
	 */
	public String getEscalateScope() {
		
		return m_escalateScope;
	}

	/**
	 * 転送先スコープを設定します。
	 * 
	 * @param escalateScope
	 */
	public void setEscalateScope(String escalateScope) {
		this.m_escalateScope = escalateScope;
	}
	
	/**
	 * 転送先ポートを返します。
	 * 
	 * @return 転送先ポート
	 */
	public Integer getEscalatePort() {
		return m_escalatePort;
	}

	/**
	 * 転送先ポートを設定します。
	 * 
	 * @param escalatePort
	 */
	public void setEscalatePort(Integer escalatePort) {
		this.m_escalatePort = escalatePort;
	}
	

	
}
