/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.factory;

import java.util.Collection;

import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.collectiverun.bean.CommandInfo;
import com.clustercontrol.collectiverun.bean.CommandParameterInfo;
import com.clustercontrol.collectiverun.bean.ItemConstant;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.ParameterInfo;
import com.clustercontrol.collectiverun.bean.ParameterSelectInfo;
import com.clustercontrol.collectiverun.bean.TypeInfo;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdParamMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdParamMstPK;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdParamMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunEndMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstPK;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunTypeMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunTypeMstUtil;

/**
 * マスタ削除クラス
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class DeleteMaster {
    protected static Log m_log = LogFactory.getLog( DeleteMaster.class );

	/**
	 * 一括制御マスタ情報削除
	 * 
	 * @param info
	 * @throws FinderException
	 * @throws NamingException
	 * @throws EJBException
	 * @throws RemoveException
	 */
	public void delete(ItemInfo info, ItemInfo parentInfo) throws FinderException, NamingException, EJBException, RemoveException  {
		
		if(info == null || parentInfo == null){
			return;
		}
		
		//cast出来ない場合はreturnする
		if (!(info instanceof TypeInfo) 
				&& !(info instanceof CommandInfo)
				&& !(info instanceof CommandParameterInfo)
				&& !(info instanceof ParameterInfo)
				&& !(info instanceof ParameterSelectInfo)
				&& !(parentInfo instanceof CommandInfo)
				&& !(parentInfo instanceof TypeInfo))
			return;
		
		if(info.getType() == ItemConstant.TYPE_TYPE){
			//IDで種別を検索し取得
			CRunTypeMstLocal type = 
				CRunTypeMstUtil.getLocalHome().findByPrimaryKey(
					((TypeInfo)info).getId());
			
			//コマンド削除
			deleteCommand(type);
			
			//種別削除
			type.remove();
		}
		else if(info.getType() == ItemConstant.TYPE_COMMAND){
			//IDでコマンドを検索し取得
			CRunCmdMstLocal cmd = 
				CRunCmdMstUtil.getLocalHome().findByPrimaryKey(
					((CommandInfo)info).getId());
			
			//コマンドパラメータ削除
			deleteCommandParameter(cmd);
			
			//終了状態削除
			deleteEndStatus(cmd);
			
			//コマンド削除
			cmd.remove();
		}
		else if(info.getType() == ItemConstant.TYPE_COMMAND_PARAMETER){
			//IDでコマンドパラメータを検索し取得
			CRunCmdParamMstLocal param = 
				CRunCmdParamMstUtil.getLocalHome().findByPrimaryKey(
						new CRunCmdParamMstPK(
								((CommandInfo)parentInfo).getId(), 
								((CommandParameterInfo)info).getId()));
			
			//コマンドパラメータ削除
			param.remove();
		}
		else if(info.getType() == ItemConstant.TYPE_PARAMETER){
			//IDでパラメータを検索し取得
			CRunParamMstLocal param = 
				CRunParamMstUtil.getLocalHome().findByPrimaryKey(
						((ParameterInfo)info).getId());
			
			//パラメータ選択肢削除
			deleteParameterSelect(param);
			
			//パラメータ削除
			param.remove();
		}
		else if(info.getType() == ItemConstant.TYPE_SELECT_ITEM){
			//IDでパラメータ選択肢を検索し取得
			CRunParamSelectMstLocal select = 
				CRunParamSelectMstUtil.getLocalHome().findByPrimaryKey(
						new CRunParamSelectMstPK(
								((ParameterSelectInfo)info).getId(), 
								Integer.valueOf(((ParameterSelectInfo)info).getOrderNo())));
			
			//パラメータ選択肢削除
			select.remove();
		}
	}
	
	/**
	 * コマンド情報削除
	 * 
	 * @param type
	 * @throws EJBException
	 * @throws RemoveException
	 */
	protected void deleteCommand(CRunTypeMstLocal type) throws EJBException, RemoveException  {
		//種別に紐づく全コマンドマスタ取得
	    Collection collection = type.getCmdMst();
	    if(collection != null && collection.size() > 0){
            Object[] objectArray = collection.toArray();
            for(int i = 0; i < objectArray.length; i++){    
			    //コマンドマスタを取得
				CRunCmdMstLocal cmd = (CRunCmdMstLocal)objectArray[i];
				
				//コマンドパラメータ削除
				deleteCommandParameter(cmd);
				
				//コマンド削除
				cmd.remove();
			}
	    }
	}
	
	/**
	 * 終了状態情報削除
	 * 
	 * @param cmd
	 * @throws EJBException
	 * @throws RemoveException
	 */
	protected void deleteEndStatus(CRunCmdMstLocal cmd) throws EJBException, RemoveException  {
		//コマンドに紐づく全終了状態マスタ取得
	    Collection collection = cmd.getEndMst();
	    if(collection != null && collection.size() > 0){
            Object[] objectArray = collection.toArray();
            for(int i = 0; i < objectArray.length; i++){
			    //終了状態マスタを取得
				CRunEndMstLocal end = (CRunEndMstLocal)objectArray[i];
				//終了状態削除
				end.remove();
			}
	    }
	}
	
	/**
	 * コマンドパラメータ情報削除
	 * 
	 * @param cmd
	 * @throws EJBException
	 * @throws RemoveException
	 */
	protected void deleteCommandParameter(CRunCmdMstLocal cmd) throws EJBException, RemoveException  {
		//コマンドに紐づく全コマンドマスタ取得
	    Collection collection = cmd.getCmdParamMst();
	    if(collection != null && collection.size() > 0){
            Object[] objectArray = collection.toArray();
            for(int i = 0; i < objectArray.length; i++){
			    //コマンドパラメータマスタを取得
				CRunCmdParamMstLocal param = (CRunCmdParamMstLocal)objectArray[i];
				//コマンドパラメータ削除
				param.remove();
			}
	    }
	}
	
	/**
	 * パラメータ選択肢情報削除
	 * 
	 * @param param
	 * @throws EJBException
	 * @throws RemoveException
	 */
	protected void deleteParameterSelect(CRunParamMstLocal param) throws EJBException, RemoveException  {
		//パラメータに紐づく全パラメータ選択肢マスタ取得
	    Collection collection = param.getParamSelectMst();
	    if(collection != null && collection.size() > 0){
            Object[] objectArray = collection.toArray();
            for(int i = 0; i < objectArray.length; i++){
			    //パラメータ選択肢マスタを取得
				CRunParamSelectMstLocal select = (CRunParamSelectMstLocal)objectArray[i];
				//パラメータ選択肢削除
				select.remove();
			}
	    }
	}
}
