/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.jobmanagement.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.sql.SQLException;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.ViewListInfo;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import com.clustercontrol.jobmanagement.util.EjbConnectionManager;
import com.clustercontrol.util.PropertyUtil;

/**
 * ジョブ[履歴]ビューの一覧情報を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、履歴一覧情報を取得します。
 * 
 * @version 2.1.1
 * @since 1.0.0
 */
public class GetHistory {
	
	/**
	 * マネージャにSessionBean経由でアクセスし、履歴一覧情報を取得します。
	 * 
	 * @param histories 表示履歴数
	 * @return ジョブ履歴一覧情報
	 * @throws AccessException 
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.session.JobController
	 * @see com.clustercontrol.jobmanagement.util.EjbConnectionManager
	 * @see com.clustercontrol.jobmanagement.ejb.session.JobControllerBean#getHistoryList(int)
	 */
	public ViewListInfo getHistory(int histories) throws AccessException {
		JobController job = 
			EjbConnectionManager.getConnectionManager().getJobController();
		
		ViewListInfo list = null;
		try {
			list = job.getHistoryList(histories);
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合
				throw (AccessException) e;
			}
		} catch (FinderException e) {
		} catch (NamingException e) {
		} catch (SQLException e) {
		}
		
		return list;
	}
	
	/**
	 * マネージャにSessionBean経由でアクセスし、<BR>
	 * フィルタ条件に一致する履歴一覧情報を取得する
	 * 
	 * @param property フィルタ条件
	 * @param histories 表示履歴数
	 * @return ジョブ履歴一覧情報
	 * @throws AccessException
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.session.JobController
	 * @see com.clustercontrol.jobmanagement.util.EjbConnectionManager
	 * @see com.clustercontrol.jobmanagement.ejb.session.JobControllerBean#getHistoryList(com.clustercontrol.bean.Property, int)
	 */
	public ViewListInfo getHistory(Property property, int histories) throws AccessException {
		PropertyUtil.deletePropertyDefine(property);
		
		JobController job = 
			EjbConnectionManager.getConnectionManager().getJobController();
		
		ViewListInfo list = null;
		try {
			list = job.getHistoryList(property, histories);
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合
				throw (AccessException) e;
			}
		} catch (FinderException e) {
		} catch (NamingException e) {
		} catch (SQLException e) {
		}
		
		return list;
	}
}
