/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite.action;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.jobmanagement.composite.RunScheduleComposite;
import com.clustercontrol.jobmanagement.composite.RunScheduleDetailComposite;
import com.clustercontrol.jobmanagement.composite.RunScheduleDetailListComposite;
import com.clustercontrol.jobmanagement.composite.RunScheduleListComposite;
import com.clustercontrol.jobmanagement.view.RunScheduleDetailListView;
import com.clustercontrol.jobmanagement.view.RunScheduleListView;

/**
 * 垂直バー用のSelectionListenerです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class VerticalBarSelectionListener implements SelectionListener {
    /** ジョブ[実行予定]またはジョブ[実行予定詳細]ビュー用のコンポジット */
	protected Composite m_composite;

    /**
     * コンストラクタ
     * 
     * @param composite ジョブ[実行予定]またはジョブ[実行予定詳細]ビュー用のコンポジット
     */
    public VerticalBarSelectionListener(Composite composite) {
        m_composite = composite;
    }

    /**
     * 選択変更時に呼び出されます。<BR>
     * ジョブ[実行予定]またはジョブ[実行予定詳細]ビューのテーブルビューアの垂直バーを操作した際に、<BR>
     * もう一つのテーブルビューアの垂直バーを操作します。
     * <P>
     * <ol>
	 * <li>ジョブ[実行予定]ビューの左側の垂直バーを操作した場合、ジョブ[実行予定]ビューの右側の表示位置を合わせます。</li>
	 * <li>ジョブ[実行予定]ビューの右側の垂直バーを操作した場合、ジョブ[実行予定]ビューの左側の表示位置を合わせます。</li>
	 * <li>ジョブ[実行予定詳細]ビューの左側の垂直バーを操作した場合、ジョブ[実行予定詳細]ビューの右側の表示位置を合わせます。</li>
	 * <li>ジョブ[実行予定詳細]ビューの右側の垂直バーを操作した場合、ジョブ[実行予定詳細]ビューの左側の表示位置を合わせます。</li>
	 * </ol>
	 * 
     * @param e 選択イベント
     * 
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) {
        //アクティブページを取得
        IWorkbenchPage page = 
        	PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();

		if(m_composite instanceof RunScheduleListComposite){
	        //ビューを取得
	        IViewPart viewPart = page.findView(RunScheduleListView.ID);
	        if (viewPart != null) {
	        	RunScheduleListView view = 
	        		(RunScheduleListView)viewPart.getAdapter(
	        				RunScheduleListView.class);
	        	
	        	view.getScheduleComposite().getTable().setTopIndex(
	        			view.getListComposite().getTable().getTopIndex());
	        }
		}
		else if(m_composite instanceof RunScheduleComposite){
	        //ビューを取得
	        IViewPart viewPart = page.findView(RunScheduleListView.ID);
	        if (viewPart != null) {
	        	RunScheduleListView view = 
	        		(RunScheduleListView)viewPart.getAdapter(
	        				RunScheduleListView.class);
	        	
	        	view.getListComposite().getTable().setTopIndex(
	        			view.getScheduleComposite().getTable().getTopIndex());
	        }
		}
		else if(m_composite instanceof RunScheduleDetailListComposite){
	        //ビューを取得
	        IViewPart viewPart = page.findView(RunScheduleDetailListView.ID);
	        if (viewPart != null) {
	        	RunScheduleDetailListView view = 
	        		(RunScheduleDetailListView)viewPart.getAdapter(
	        				RunScheduleDetailListView.class);
	        	
	        	view.getScheduleComposite().getTable().setTopIndex(
	        			view.getListComposite().getTable().getTopIndex());
	        }
		}
		else if(m_composite instanceof RunScheduleDetailComposite){
	        //ビューを取得
	        IViewPart viewPart = page.findView(RunScheduleDetailListView.ID);
	        if (viewPart != null) {
	        	RunScheduleDetailListView view = 
	        		(RunScheduleDetailListView)viewPart.getAdapter(
	        				RunScheduleDetailListView.class);
	        	
	        	view.getListComposite().getTable().setTopIndex(
	        			view.getScheduleComposite().getTable().getTopIndex());
	        }
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) {

	}
}

