/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.jobmanagement.bean;

import java.io.Serializable;

/**
 * ジョブの変数に関する情報を保持するクラス
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class JobParameterInfo implements Serializable, Cloneable{
	/** シリアライズ可能クラスに定義するUID */
	private static final long serialVersionUID = 981926727088488957L;

	/** パラメータID */
	protected String paramId;
	
	/** パラメータ種別 */
	protected int type;
	
	/** 説明 */
	protected String description;
	
	/** 値 */
	protected String value;
	
	/**
	 * 説明を返す。<BR>
	 * @return 説明
	 */
	public String getDescription() {
		return description;
	}
	
	/**
	 * 説明を設定する。<BR>
	 * @param description 説明
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * パラメータIDを返す。<BR>
	 * @return パラメータID
	 */
	public String getParamId() {
		return paramId;
	}
	
	/**
	 * パラメータIDを設定する。<BR>
	 * @param paramId パラメータID
	 */
	public void setParamId(String paramId) {
		this.paramId = paramId;
	}
	
	/**
	 * パラメータ種別を返す。<BR>
	 * @return パラメータ種別
	 * @see com.clustercontrol.bean.JobParamTypeConstant
	 */
	public int getType() {
		return type;
	}
	
	/**
	 * パラメータ種別を設定する。<BR>
	 * @param type パラメータ種別
	 * @see com.clustercontrol.bean.JobParamTypeConstant
	 */
	public void setType(int type) {
		this.type = type;
	}
	
	/**
	 * パラメータとして設定した値を返す。<BR>
	 * @return パラメータ値
	 */
	public String getValue() {
		return value;
	}
	
	/**
	 * パラメータとして値を設定する。<BR>
	 * @param value パラメータ値
	 */
	public void setValue(String value) {
		this.value = value;
	}
	
	/**
	 * ジョブ終了状態情報のクローンを作成する。<BR>
	 * @return ジョブ終了状態情報のクローン
	 * @see java.lang.Object#clone()
	 */
	protected Object clone() {
		try {
			JobParameterInfo clone = (JobParameterInfo)super.clone();
			
			clone.setParamId(this.getParamId());
			clone.setType(this.getType());
			clone.setDescription(this.getDescription());
			clone.setValue(this.getValue());
			
			return clone;
		} catch (CloneNotSupportedException e) {
			return null;
		}
	}
}