/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.factory;

import java.util.Collection;
import java.util.Iterator;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.jobmanagement.bean.AgentCheckConstant;
import com.clustercontrol.jobmanagement.bean.CommandTypeConstant;
import com.clustercontrol.jobmanagement.bean.DelayNotifyConstant;
import com.clustercontrol.jobmanagement.bean.TopicConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodePK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoLocal;
import com.clustercontrol.jobmanagement.message.RunInstructionInfo;
import com.clustercontrol.jobmanagement.util.ParameterUtil;
import com.clustercontrol.jobmanagement.util.SendTopic;

/**
 * ジョブ操作の停止[コマンド]を行うクラスです。
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class OperateStopOfJob extends OperationJob {
	protected static Log m_log = LogFactory.getLog( OperateStopOfJob.class );

	public OperateStopOfJob(){
		super();
	}
	
	/**
	 * ジョブを停止[コマンド]します。
	 * 
	 * @param sessionId セッションID
	 * @param jobId ジョブID
	 * @param facilityId ファシリティID
	 * @throws FinderException
	 * @throws NamingException
	 * 
	 * @see com.clustercontrol.jobmanagement.factory.OperationJob#checkAllNodeStop(JobSessionJobLocal)
	 * @see com.clustercontrol.jobmanagement.factory.OperateStopOfJob#stopNode(String, String, String)
	 * @see com.clustercontrol.jobmanagement.factory.OperateStopOfJob#stopJob(String, String)
	 */
	public void stopJob(String sessionId, String jobId, String facilityId) throws FinderException, NamingException {
		m_log.debug("stopJob() : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId);
		
		//セッションIDとジョブIDから、セッションジョブを取得
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		if(sessionJob != null){
			//実行状態が実行中の場合、実行状態を停止処理中にする
			if(sessionJob.getStatus().intValue() == StatusConstant.TYPE_RUNNING){
				if(facilityId != null && facilityId.length() > 0){
					//ノード停止処理
					stopNode(sessionId, jobId, facilityId);
				}
				else{
					sessionJob.setStatus(Integer.valueOf(StatusConstant.TYPE_STOPPING));
					
					//ジョブ以外の場合
					JobInfoLocal job = sessionJob.getJobInfo();
					if(job.getJob_type().intValue() == JobConstant.TYPE_JOB){
						//ノード停止処理
						stopNode(sessionId, jobId, null);
						
						//全ノード停止チェック
						if(checkAllNodeStop(sessionJob)){
							//全ノード停止の場合
							
							//実行状態にコマンド停止を設定
							sessionJob.setStatus(Integer.valueOf(StatusConstant.TYPE_STOP));
							
							//ジョブ停止関連処理
							stopJob(sessionId, jobId);
							
							JobStartInfoLocal start = job.getJobStartInfo();
							//遅延通知状態を取得
							int flg = sessionJob.getDelay_notify_flg().intValue();
							//遅延通知状態から操作済みフラグを取得
							int operationFlg = DelayNotifyConstant.getOperation(flg);
							if(operationFlg == DelayNotifyConstant.STOP_SET_END_VALUE){
								//操作済みフラグが停止[終了値の指定]の場合、停止[終了値の変更]を行う
								new OperateMaintenanceOfJob().maintenanceJob(
										sessionId, 
										jobId, 
										null, 
										start.getEnd_delay_operation_end_value());
							}
							
							start = null;
							sessionJob = null;
						}
					}
					else{
						//セッションIDとジョブIDから、直下のジョブを取得（実行状態が実行中）
						Collection collection = JobRelationInfoUtil.getLocalHome().findByStatus(sessionId, jobId, Integer.valueOf(StatusConstant.TYPE_RUNNING));
						if(collection != null && collection.size() > 0){
							Iterator itr = collection.iterator();
							while(itr.hasNext()){
								JobRelationInfoLocal relation = (JobRelationInfoLocal)itr.next();
								
								//ジョブ停止処理を行う
								stopJob(relation.getSession_id(), relation.getJob_id(), null);
							}
						}
						
						//直下のジョブが全て停止したかチェック
						boolean endAll = true;
						collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId);
						if(collection != null && collection.size() > 0){
							Iterator itr = collection.iterator();
							while(itr.hasNext()){
								JobRelationInfoLocal relation1 = (JobRelationInfoLocal)itr.next();
								JobSessionJobLocal sessionJob1 = relation1.getJobSessionJob();
								relation1 = null;
								
								int status = sessionJob1.getStatus().intValue();
								sessionJob1 = null;
								
								//実行状態が停止処理中かチェック
								if(status == StatusConstant.TYPE_STOPPING ||
										status == StatusConstant.TYPE_RUNNING){
									endAll = false;
									break;
								}
							}
						}
						
						//直下のジョブが全て停止の場合
						if(endAll){
							//実行状態をコマンド停止にする
							sessionJob.setStatus(Integer.valueOf(StatusConstant.TYPE_STOP));
														
							if(job.getJob_type().intValue() == JobConstant.TYPE_JOBNET){
								JobStartInfoLocal start = job.getJobStartInfo();
								
								//遅延通知状態を取得
								int flg = sessionJob.getDelay_notify_flg().intValue();
								//遅延通知状態から操作済みフラグを取得
								int operationFlg = DelayNotifyConstant.getOperation(flg);
								if(operationFlg == DelayNotifyConstant.STOP_SET_END_VALUE){
									//操作済みフラグが停止[終了値の指定]の場合、停止[終了値の変更]を行う
									new OperateMaintenanceOfJob().maintenanceJob(
											sessionId, 
											jobId, 
											null, 
											start.getEnd_delay_operation_end_value());
								}
								start = null;
							}
							sessionJob = null;
						}
					}
				}
			}
		}
	}
	
	/**
	 * ジョブ停止時関連処理を行います。
	 * 
	 * @param sessionId セッションID
	 * @param jobId ジョブID
	 * @throws FinderException
	 * @throws NamingException
	 * 
	 * @see com.clustercontrol.jobmanagement.factory.OperateStopOfJob#stopJob(String, String)
	 */
	protected void stopJob(String sessionId, String jobId) throws FinderException, NamingException {
		m_log.debug("stopJob() : sessionId=" + sessionId + ", jobId=" + jobId);
		
		//セッションIDとジョブIDから、セッションジョブを取得
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		//リレーションを取得し、親ジョブのジョブIDを取得
		JobRelationInfoLocal relation = sessionJob.getJobRelationInfo();
		String parentJobId = relation.getParent_job_id();
		relation = null;
		
		//同一階層のジョブが全て停止したかチェック
		boolean endAll = true;
		Collection sameHierarchy = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, parentJobId);
		Iterator itr = sameHierarchy.iterator();
		while(itr.hasNext()){
			JobRelationInfoLocal relation1 = (JobRelationInfoLocal)itr.next();
			JobSessionJobLocal sessionJob1 = relation1.getJobSessionJob();
			relation1 = null;
			
			int status = sessionJob1.getStatus().intValue();
			sessionJob1 = null;
			
			//実行状態が停止処理中かチェック
			if(status == StatusConstant.TYPE_STOPPING ||
					status == StatusConstant.TYPE_RUNNING){
				endAll = false;
				break;
			}
		}
		sessionJob = null;
		
		//同一階層のジョブが全て完了の場合
		if(endAll){
			if(parentJobId.compareTo("TOP") != 0){
				//セッションIDとジョブIDから、セッションジョブを取得
				JobSessionJobLocal parentSessionJob = 
					JobSessionJobUtil.getLocalHome().findByPrimaryKey(
							new JobSessionJobPK(sessionId, parentJobId));
				
				if(parentSessionJob.getStatus().intValue() == StatusConstant.TYPE_STOPPING){
					//実行状態にコマンド停止を設定
					parentSessionJob.setStatus(Integer.valueOf(StatusConstant.TYPE_STOP));
					
					//ジョブ停止時関連処理（再帰呼び出し）
					stopJob(sessionId, parentJobId);
					
					JobInfoLocal job = parentSessionJob.getJobInfo();
					if(job.getJob_type().intValue() == JobConstant.TYPE_JOBNET){
						JobStartInfoLocal start = job.getJobStartInfo();
						
						//遅延通知状態を取得
						int flg = parentSessionJob.getDelay_notify_flg().intValue();
						//遅延通知状態から操作済みフラグを取得
						int operationFlg = DelayNotifyConstant.getOperation(flg);
						if(operationFlg == DelayNotifyConstant.STOP_SET_END_VALUE){
							//操作済みフラグが停止[終了値の指定]の場合、停止[終了値の変更]を行う
							new OperateMaintenanceOfJob().maintenanceJob(
									sessionId, 
									parentJobId, 
									null, 
									start.getEnd_delay_operation_end_value());
						}
						start = null;
					}
					job = null;
					parentSessionJob = null;
				}
			}
		}
	}
	
	/**
	 * ノード停止処理を行います。
	 * 
	 * @param sessionId セッションID
	 * @param jobId ジョブID
	 * @param facilityId ファシリティID
	 * @throws FinderException
	 * @throws NamingException
	 * 
	 * @see com.clustercontrol.jobmanagement.util.SendTopic
	 * @see com.clustercontrol.jobmanagement.util.ParameterUtil
	 */
	protected void stopNode(String sessionId, String jobId, String facilityId) throws FinderException, NamingException {
		m_log.debug("stopNode() : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId);
		
		//エージェントタイムアウトチェック
		checkTimeout(sessionId, jobId);
		
		//セッションIDとジョブIDから、セッションジョブを取得
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		JobInfoLocal job = sessionJob.getJobInfo();
		JobCommandInfoLocal command = job.getJobCommandInfo();
		
		if(facilityId != null && facilityId.length() > 0){
			//セッションID、ジョブID、ファシリティIDから、セッションノードを取得
			JobSessionNodeLocal sessionNode = 
				JobSessionNodeUtil.getLocalHome().findByPrimaryKey(
						new JobSessionNodePK(sessionId, jobId, facilityId));
			
			//実行状態が実行中の場合
			if(sessionNode.getStatus().intValue() == StatusConstant.TYPE_RUNNING){
				if(sessionNode.getAgent_check().intValue() == AgentCheckConstant.OK && 
						command.getStop_command() != null && 
						command.getStop_command().length() > 0){
					
					//実行状態を停止処理中にする
					sessionNode.setStatus(Integer.valueOf(StatusConstant.TYPE_STOPPING));
					//開始・再実行日時をクリア
					sessionNode.setStart_date(null);
					
					//実行指示情報を作成
					RunInstructionInfo instructionInfo = new RunInstructionInfo();
					instructionInfo.setSessionId(sessionNode.getSession_id());
					instructionInfo.setJobId(sessionNode.getJob_id());
					instructionInfo.setFacilityId(sessionNode.getFacility_id());
					//コマンド内のパラメータを置き換える
					String stopCommand = ParameterUtil.replaceSessionParameterValue(
							sessionId, 
							command.getStop_command());
					instructionInfo.setCommand(stopCommand);
					instructionInfo.setUser(command.getEffective_user());
					instructionInfo.setCommandType(CommandTypeConstant.STOP);
					
					try {
						//Topicに送信
						SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
						send.put(instructionInfo);
					} catch (Exception e) {
						m_log.debug("stopNode() : 実行停止送信エラー : " + e.getMessage());
					}
				}
				else{
					//実行状態をコマンド停止にする
					sessionNode.setStatus(Integer.valueOf(StatusConstant.TYPE_STOP));
				}
			}
		}
		else{
			//セッションジョブのセッションノードを取得
			Collection collection = sessionJob.getJobSessionNode();
			if(collection != null && collection.size() > 0){
				//待ち条件ジョブ判定
				Iterator itr = collection.iterator();
				while(itr.hasNext()){
					JobSessionNodeLocal sessionNode = (JobSessionNodeLocal)itr.next();
					
					//実行状態が実行中の場合
					if(sessionNode.getStatus().intValue() == StatusConstant.TYPE_RUNNING){
						if(sessionNode.getAgent_check().intValue() == AgentCheckConstant.OK && 
								command.getStop_command() != null && 
								command.getStop_command().length() > 0){
							
							//実行状態を停止処理中にする
							sessionNode.setStatus(Integer.valueOf(StatusConstant.TYPE_STOPPING));
							//開始・再実行日時をクリア
							sessionNode.setStart_date(null);
							
							//実行指示情報を作成
							RunInstructionInfo instructionInfo = new RunInstructionInfo();
							instructionInfo.setSessionId(sessionNode.getSession_id());
							instructionInfo.setJobId(sessionNode.getJob_id());
							instructionInfo.setFacilityId(sessionNode.getFacility_id());
							//コマンド内のパラメータを置き換える
							String stopCommand = ParameterUtil.replaceSessionParameterValue(
									sessionId, 
									command.getStop_command());
							instructionInfo.setCommand(stopCommand);
							instructionInfo.setUser(command.getEffective_user());
							instructionInfo.setCommandType(CommandTypeConstant.STOP);
							
							try {
								//Topicに送信
								SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
								send.put(instructionInfo);
							} catch (Exception e) {
								m_log.debug("stopNode() : 実行停止送信エラー : " + e.getMessage());
							}
						}
						else{
							//実行状態をコマンド停止にする
							sessionNode.setStatus(Integer.valueOf(StatusConstant.TYPE_STOP));
						}
					}
				}
			}
		}
	}
}
