/*
 
Copyright (C) 2007 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.bean;

/**
 * メンテナンス一覧のテーブル定義を定数として格納するクラスです。
 * 
 * @version 2.2.0
 * @since 2.2.0
 */
public class MaintenanceTableDefine {

    /** メンテナンスID。 */
    public static final int MAINTENANCE_ID = 0;

    /** 説明。 */
    public static final int DESCRIPTION = 1;
    
    /** 
     * 種別。
     * 
     * @see com.clustercontrol.monitor.run.bean.MonitorTypeConstant
     */
    public static final int TYPE_ID = 2;
    
    /** 削除対象外期間 * 
     */
    public static final int KEEP_ID = 3;
    
    /** カレンダID。 */
    public static final int CALENDAR_ID = 4;
    
    /** スケジュール。*/
    public static final int SCHEDULE = 5;    
    /**
     * 有効／無効。
     * 
     * @see com.clustercontrol.bean.ValidConstant
     */
    public static final int VALID_FLG = 6;
    
    /** 新規作成ユーザ。 */
    public static final int CREATE_USER = 7;
    
    /** 作成日時。 */
	public static final int CREATE_TIME = 8;
	
	/** 最終変更ユーザ。 */
	public static final int UPDATE_USER = 9;
	
	/** 最終変更日時。 */
	public static final int UPDATE_TIME = 10;

    /** 初期表示時ソートカラム。 */
    public static final int SORT_COLUMN_INDEX = MAINTENANCE_ID;

    /** 初期表示時ソートオーダー。 */
    public static final int SORT_ORDER = 1;

}