/*
 
Copyright (C) 2007 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.maintenance.ejb.entity.MaintenanceKeepMstLocal;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceKeepMstUtil;

/**
 * 
 * 削除対象外の期間に関する情報を検索するためのクラスです。
 * 
 * @since	2.2.0
 * @version	2.2.0
 *
 */
public class SelectMaintenanceKeepMst {
	
	
	/**
	 * 
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 * @throws CreateException
	 */
	public MaintenanceKeepMstLocal getMaintenanceKeepMst(String keep_id) throws FinderException, NamingException, CreateException {
		
		MaintenanceKeepMstLocal mst = MaintenanceKeepMstUtil.getLocalHome().findByPrimaryKey(keep_id);
		
		return mst;
	}
	
	/**
	 * 
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getMaintenanceKeepNameIdList() throws FinderException, NamingException {
		
		Collection ct = MaintenanceKeepMstUtil.getLocalHome().findAll();
		ArrayList<String> list = null;
		
		Iterator itr = ct.iterator();
		while(itr.hasNext())
		{
			if(list == null){
				list = new ArrayList<String>();
			}
			
			MaintenanceKeepMstLocal mst = (MaintenanceKeepMstLocal)itr.next();
			list.add(mst.getName_id());
		}

		return list;
	}
	
	/**
	 * メンテナンス情報をObjectの2次元配列に格納
	 * 
	 * @param ct
	 * @return Objectの2次元配列
	 */
	@SuppressWarnings("unchecked")
	private ArrayList collectionToArray(Collection ct) throws CreateException, FinderException, NamingException{
		
		ArrayList list = new ArrayList();
		Iterator itr = ct.iterator();
		while(itr.hasNext())
		{
			MaintenanceKeepMstLocal mst = (MaintenanceKeepMstLocal)itr.next();
			
			ArrayList info = new ArrayList();
			info.add(mst.getKeep_id());
			info.add(mst.getName_id());
			info.add(mst.getOrder_no());
			list.add(info);
		}
		return list;
	}
	
}
