/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.util;

import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ExclusionConstant;
import com.clustercontrol.bean.NotifyTypeConstant;
import com.clustercontrol.bean.OutputNotifyGroupInfo;
import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoData;
import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoPK;
import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoUtil;
import com.clustercontrol.notify.ejb.entity.NotifyInfoLocal;
import com.clustercontrol.notify.ejb.mdb.NotifyControlBean;
import com.clustercontrol.notify.ejb.mdb.NotifyControlBeanUtil;
import com.clustercontrol.notify.ejb.session.NotifyControllerLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerUtil;
import com.clustercontrol.notify.factory.AddNotifyInhibition;

/**
 * 各種通知を抑制するクラス<BR>
 *
 * @version 3.0.0
 * @since 3.0.0
 */
public class InhibitAction {
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( InhibitAction.class );
	
	/** 通知内容 */
	protected NotifyInfoLocal m_notifyInfo = null;	
	
	/** 抑制内容 */
	protected NotifyActionInhibitionInfoLocal m_inhibitInfo = null;
	
    protected boolean isInhibit(OutputNotifyGroupInfo outputInfo, NotifyInfoLocal notifyInfo) throws RemoteException, NamingException, NumberFormatException, CreateException{
    	
    	// 戻り値は抑制するか否か
    	boolean isInhibit = false;
    	
    	m_notifyInfo = notifyInfo;
    	String notifyGroupId = outputInfo.getNotifyGroupId();
    	String notifyId = notifyInfo.getNotifyId();
    	String facilityId = outputInfo.getFacilityId();
    	int priority = outputInfo.getPriority();
    	Date generationDate = outputInfo.getGenerationDate();
    	
    	// 抑制情報が取得できるかチェックし、できない場合は新規作成
    	NotifyActionInhibitionInfoPK inhibitionPk = new NotifyActionInhibitionInfoPK(notifyGroupId, notifyId, facilityId);
    	
    	try{
    		m_inhibitInfo = NotifyActionInhibitionInfoUtil.getLocalHome().findByPrimaryKey(inhibitionPk);
    	}
    	// 存在しない場合は、新規作成
    	catch(FinderException e){ 
    		NotifyActionInhibitionInfoUtil.getLocalHome().create(
    				notifyGroupId, 
    				notifyId, 
    				facilityId, 
    				(Integer)priority,
    				new Timestamp(generationDate.getTime()), 
    				new Timestamp(generationDate.getTime()), 
    				new Long(0), 
    				new Long(1));

/*	    		// TODO : NotifyControllerBeanからAddNtorifyInhibitionを呼ぶべき？
	    		// 以下そのコード
	    		NotifyActionInhibitionInfoData inhibit = new NotifyActionInhibitionInfoData(
	    				notifyGroupId,
	    				notifyId,
	    				facilityId,
	    				(Integer)priority,
	    				new Long(0), 
	    				new Timestamp(generationDate.getTime()), 
	    				new Timestamp(generationDate.getTime()), 
	    				new Long(1)
	    		);

	    		NotifyControllerLocal notify = NotifyControllerUtil.getLocalHome().create();
	    		notify.addNotifyInhibition(inhibit);
*/
	    		// 初期登録時に抑制することはないので、無条件でfalseを返す。
    		return false;
    	}
    	
    	// 抑制方法によって分岐する
    	// 期間で抑制
    	if(notifyInfo.getInhibitionFlg() == ExclusionConstant.TYPE_PERIOD){
    		isInhibit = isInhibitPeriod(generationDate);
    	}
    	// 回数で抑制
    	else if(notifyInfo.getInhibitionFlg() == ExclusionConstant.TYPE_FREQUENCY){
    		isInhibit = isInhibitFrequency();
    	}
    	// 重要度で抑制
    	else if(notifyInfo.getInhibitionFlg() == ExclusionConstant.TYPE_PRIORITY){
    		isInhibit = isInhibitPriority(priority);
    	}
    	else{
			m_log.debug("inhibit() : どの抑制タイプにも当てはまりません。");
			return false;
		}
		
		// 抑制するかどうかにあわせて、抑制テーブルを更新する（イベント通知以外）
		inhibitUpdate(isInhibit, priority, generationDate);
		
		return isInhibit;

    }
    
    /**
     * 期間で抑制する
     * 
     * @return 抑制結果（true:抑制）
     */
    protected boolean isInhibitPeriod(Date generationDate) {
    	
    	Calendar cal = Calendar.getInstance();
    	cal.setTime(m_inhibitInfo.getLastNotifyDate());	// 最後に通知した時刻
    	cal.add(Calendar.MINUTE, m_notifyInfo.getInhibitionPeriod());	// 最後に通知した時刻に、抑制時間を足す
    	
    	// 抑制時刻と出力時刻を比較し、抑制時刻の方が通知時刻より後ならば、抑制する
    	if(cal.getTime().after(generationDate)) {
    		return true;
    	}
    	
    	return false;
    }
    
    /**
     * 回数で抑制する
     * 
     * @return ret 抑制結果（true:抑制）
     */
    protected boolean isInhibitFrequency() {
    	
    	// 現在まで抑制された回数と設定された抑制回数を比較し、設定された抑制回数のほうが多ければ、抑制する
    	if(m_inhibitInfo.getDupuricationCount().intValue() < m_notifyInfo.getInhibitionFrequency()) {
    		return true;
    	}
    	
    	return false;
    }
    
    /**
     * 重要度で抑制する
     * 
     * @return ret 抑制結果（true:抑制）
     */
    protected boolean isInhibitPriority(int priority) {
    	
    	// 最後に出力された重要度と今回出力された重要度を比較し、同じ重要度である場合は、抑制する
    	if(m_inhibitInfo.getPriority().intValue() == priority) {
    		return true;
    	}
    	
    	return false;
    }
    
    /**
     * 抑制関連テーブルのアップデート
     * 
     * @param isInhibit 抑制されたかどうか 
     */
    protected void inhibitUpdate(boolean isInhibit, int priority, Date generationDate) {

    	m_inhibitInfo.setPriority(priority);
    	m_inhibitInfo.setTotalCount(m_inhibitInfo.getTotalCount() + 1);
    	m_inhibitInfo.setLastUpdateDate(new Timestamp(generationDate.getTime()));
    	
    	// 抑制する場合
    	if(isInhibit) {
    		// 抑制回数に1を足す
    		m_inhibitInfo.setDupuricationCount(m_inhibitInfo.getDupuricationCount() + 1);
    	} 
    	// 通知する場合
    	else {
    		// 最終通知時刻を出力時刻にし、抑制回数を0にする
	    	m_inhibitInfo.setLastNotifyDate(new Timestamp(generationDate.getTime()));
	    	m_inhibitInfo.setDupuricationCount(new Long(0));
    	}
    }
}

