/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.monitor.ejb.entity;

import javax.ejb.EntityBean;

/**
 * 収集カテゴリ情報を管理するEntity Bean <BR>
 * @ejb.bean name="CollectorCategoryMst"
 *           jndi-name="CollectorCategoryMst"
 *           type="CMP"
 *           schema="CollectorCategoryMst" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="categoryCode"
 *           
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *  
 *  @jboss.read-only read-only="true"
 *  
 *  @ejb.permission
 *     unchecked="true"
 *     
 *  @ejb.persistence 
 *   table-name="cc_collector_category_mst"  
 *           
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CollectorCategoryMst as a"  
 *    signature="java.util.Collection findAll()"  
 *
 *  @ejb.pk class="java.lang.String"
 */
public abstract class CollectorCategoryMstBean implements EntityBean {
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public java.lang.String ejbCreate(
			String categoryCode,
			String categoryName
			) throws javax.ejb.CreateException {
		
		this.setCategoryCode(categoryCode);
		this.setCategoryName(categoryName);

		return null;
	}
	
	/**
	 * コンストラクター
	 * @param categoryCode カテゴリコード
	 * @param categoryName カテゴリ名
	 * @throws javax.ejb.CreateException
	 */
	public void ejbPostCreate(
			String categoryCode,
			String categoryName
			) throws javax.ejb.CreateException {
	}
	
	/**
	 * カテゴリコードを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="category_code"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the categoryCode.
	 */
	public abstract String getCategoryCode();

	/**
	 * カテゴリコードを設定します。
	 * 
	 * @param categoryCode The categoryCode to set.
	 */
	public abstract void setCategoryCode(String categoryCode);

	/**
	 * カテゴリ名を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="category_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the categoryName.
	 */
	public abstract String getCategoryName();

	/**
	 * カテゴリ名を設定します。
	 * 
	 * @param categoryName The categoryName to set.
	 */
	public abstract void setCategoryName(String categoryName);

}
