/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.process.composite;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.process.action.GetProcess;
import com.clustercontrol.process.action.GetProcessListTableDefine;
import com.clustercontrol.process.bean.ProcessTabelDefine;
;

/**
 * 通知一覧のコンポジットクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class ProcessListComposite extends Composite {

    // ----- instance フィールド ----- //

    /** テーブルビューア */
    private CommonTableViewer tableViewer = null;

    // ----- コンストラクタ ----- //

    /**
     * インスタンスを返します。
     * 
     * @param parent
     *            親のコンポジット
     * @param style
     *            スタイル
     */
    public ProcessListComposite(Composite parent, int style) {
        super(parent, style);

        this.initialize();
    }

    // ----- instance メソッド ----- //

    /**
     * コンポジットを生成・構築します。
     */
    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        Table table = new Table(this, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData(gridData);

        // テーブルビューアの作成
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetProcessListTableDefine.get(),
        		ProcessTabelDefine.SORT_COLUMN_INDEX,
        		ProcessTabelDefine.SORT_ORDER);

        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;

        this.update();
    }

    /**
     * tableViewerを返します。
     * 
     * @return tableViewer
     */
    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    /**
     * コンポジットを更新します。
     * <p>
     * 
     */
    public void update() {
        // データ取得
    	ArrayList list = new GetProcess().getProcessList();
    	 
        // テーブル更新
        this.tableViewer.setInput(list);
    }
    
    /**
     * 選択された行の監視項目IDを取得する
     * 
     * @return 
     */
    public ArrayList<String> getSelectionData() {
    	
    	ArrayList<String> data = new ArrayList<String>();
    	
    	//選択されたアイテムを取得
    	StructuredSelection selection = 
    		(StructuredSelection)tableViewer.getSelection();
    	List list = (List)selection.toList();
    	
    	if (list != null) {
    		for(int index = 0; index < list.size(); index++){
    			
    			ArrayList info = (ArrayList)list.get(index);
    			if (info != null && info.size() > 0) {
    				String monitorId = (String)info.get(ProcessTabelDefine.MONITOR_ID);
    				data.add(monitorId);
    			}
    		}
    	}
    	
    	return data;
    }
}