/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.process.ejb.session;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.process.factory.RunMonitorProcess;

/**
 *  * Quartzから呼びだされてプロセス監視を実行するSession Bean<BR>
 *  
 * @ejb.bean name="MonitorProcessRunManagement"
 *           jndi-name="MonitorProcessRunManagement"
 *           type="Stateless"
 *           transaction-type="Container"
 *           
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=QuartzManager"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=NotifyController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorInfo"
 * 
 * @ejb.permission
 *     unchecked="true"
 *        
 */
public abstract class MonitorProcessRunManagementBean implements SessionBean {
	
	protected static Log m_log = LogFactory.getLog( MonitorProcessRunManagementBean.class );

    /**
     * Quartzからのコールバックメソッド
     * 
     * @ejb.interface-method
     * 
     * @param monitorTypeId 監視監視対象ID
     * @param monitorId 監視項目ID
     * @param monitorType 監視判定タイプ
     * @throws CreateException
     * @throws FinderException
     * @throws RemoveException
     * @throws JMSException
     * @throws NamingException
     * @throws NotSupportedException
     * @throws HeuristicMixedException
     * @throws HeuristicRollbackException
     * @throws RollbackException
     * @throws InvalidTransactionException
     * @throws SystemException
     * @version 2.1.0
     * @since 2.0.0
     */
    public void run(String monitorTypeId, String monitorId, Integer monitorType) throws CreateException, FinderException, RemoveException, JMSException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, SystemException {
    	
        m_log.debug("run()");
        
        RunMonitorProcess monitor = new RunMonitorProcess();
       	monitor.run(monitorTypeId, monitorId);
    }
}
