/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.factory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.DeviceTypeConstant;
import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.repository.bean.FacilityAttributeConstant;
import com.clustercontrol.repository.ejb.entity.DeviceInfoData;
import com.clustercontrol.repository.ejb.entity.DeviceInfoLocal;
import com.clustercontrol.repository.ejb.entity.DeviceInfoUtil;
import com.clustercontrol.repository.ejb.entity.FacilityData;
import com.clustercontrol.repository.ejb.entity.FacilityLocal;
import com.clustercontrol.repository.ejb.entity.FacilityTreeLocal;
import com.clustercontrol.repository.ejb.entity.FacilityTreeUtil;
import com.clustercontrol.repository.ejb.entity.FacilityUtil;
import com.clustercontrol.repository.ejb.entity.FileSystemInfo;
import com.clustercontrol.repository.ejb.entity.FileSystemInfoData;
import com.clustercontrol.repository.ejb.entity.FileSystemInfoLocal;
import com.clustercontrol.repository.ejb.entity.FileSystemInfoUtil;
import com.clustercontrol.repository.ejb.session.RepositoryControllerBean;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.repository.factory.NodeFilterProperty;
import com.clustercontrol.repository.util.ListSorter;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * ファシリティを検索するクラス<BR>
 *
 * @version 3.1.0
 * @since 1.0.0
 */
public class SelectFacility {
	
	protected static Log m_log = LogFactory.getLog(SelectFacility.class);

	public static final String SEPARATOR = ">";
	
	
	/**
	 * nodePropertyをFacilityDataオブジェクトに詰めなおして返却する。
	 * @param nodeProperty
	 * @return
	 */
	public Property getNodeProperty(FacilityData facilityData, Locale locale) throws CreateException,NamingException,FinderException{

		Property node = null;
		ArrayList propertyList = null;

		//node = RepositoryControllerUtil.getLocalHome().create().getNodeProperty(PropertyConstant.MODE_SHOW, locale);
		NodeProperty nodeProperty = new NodeProperty();
		node = nodeProperty.getProperty(PropertyConstant.MODE_SHOW, locale);
		
		//Dataオブジェクトへの詰め替え
		
		//data.setType(facility.getType());
		
		propertyList = PropertyUtil.getProperty(node, NodeProperty.FACILITY_NAME);
		((Property)propertyList.get(0)).setValue(facilityData.getCn());
		
		//data.setAgentControl(facility.getAgentControl());
		//data.setAgentWatch(facility.getAgentWatch());
		//data.setAgentWatchStatus(facility.getAgentWatchStatus());
		
		propertyList = PropertyUtil.getProperty(node, NodeProperty.CHARACTER_SET);
		((Property)propertyList.get(0)).setValue(facilityData.getCharSet());
		
		//data.setCn(facility.getCn());
		
		propertyList = PropertyUtil.getProperty(node, NodeProperty.CREATE_TIME);
		((Property)propertyList.get(0)).setValue(facilityData.getCreateTimestamp());

		propertyList = PropertyUtil.getProperty(node, NodeProperty.CREATOR_NAME);
		((Property)propertyList.get(0)).setValue(facilityData.getCreatorsName());
		
		propertyList = PropertyUtil.getProperty(node, NodeProperty.DESCRIPTION);
		((Property)propertyList.get(0)).setValue(facilityData.getDescription());

		propertyList = PropertyUtil.getProperty(node, NodeProperty.DHCP_CLIENT);
		((Property)propertyList.get(0)).setValue(facilityData.getDhcpClient());

	
		propertyList = PropertyUtil.getProperty(node, NodeProperty.FACILITY_ID);
		((Property)propertyList.get(0)).setValue(facilityData.getFacilityId());

		PropertyUtil.setPropertyValue(node, NodeProperty.HOST_NAME, facilityData.getHost());
		propertyList = PropertyUtil.getProperty(node, NodeProperty.HOST_NAME);
		Property parentHost = (Property)((Property)propertyList.get(0)).getParent();
		if(facilityData.getHost() != null){
			int index = PropertyUtil.getPropertyIndex(parentHost, (Property)propertyList.get(0));
			for(int i = 0; i < facilityData.getHost().size(); i++){
				if(i == 0){
					((Property)propertyList.get(0)).setValue(facilityData.getHost().get(i));
				}
				else{
					Property copy = PropertyUtil.copy((Property)propertyList.get(0));
					
					((Property)propertyList.get(0)).setValue(facilityData.getHost().get(i));
					
					parentHost.addChildren(copy, index + i);
				}
			}
		}
		
		propertyList = PropertyUtil.getProperty(node, NodeProperty.IP_ADDRESS_VERSION);
		((Property)propertyList.get(0)).setValue(facilityData.getIpProtocolNumber());

		propertyList = PropertyUtil.getProperty(node, NodeProperty.IP_ADDRESS_V4);
		((Property)propertyList.get(0)).setValue(facilityData.getIpNetworkNumber());

		propertyList = PropertyUtil.getProperty(node, NodeProperty.IP_ADDRESS_V6);
		((Property)propertyList.get(0)).setValue(facilityData.getIpNetworkNumberV6());

		propertyList = PropertyUtil.getProperty(node, NodeProperty.IP_ADDRESS_TYPE);
		((Property)propertyList.get(0)).setValue(facilityData.getIpType());
		
		//data.setLogWatch(facility.getLogWatch());
		propertyList = PropertyUtil.getProperty(node, NodeProperty.HARDWARE_TYPE);
		((Property)propertyList.get(0)).setValue(facilityData.getMachine());		

		propertyList = PropertyUtil.getProperty(node, NodeProperty.CONTACT);
		((Property)propertyList.get(0)).setValue(facilityData.getManagerContact());
		propertyList = PropertyUtil.getProperty(node, NodeProperty.ADMINISTRATOR);
		((Property)propertyList.get(0)).setValue(facilityData.getManagerName());
		
		propertyList = PropertyUtil.getProperty(node, NodeProperty.MODIFIER_NAME);
		((Property)propertyList.get(0)).setValue(facilityData.getModifiersName());
		
		propertyList = PropertyUtil.getProperty(node, NodeProperty.MODIFY_TIME);
		((Property)propertyList.get(0)).setValue(facilityData.getModifyTimestamp());
		
		propertyList = PropertyUtil.getProperty(node, NodeProperty.NODE_NAME);
		((Property)propertyList.get(0)).setValue(facilityData.getNodeName());
		
		propertyList = PropertyUtil.getProperty(node, NodeProperty.OS_NAME);
		((Property)propertyList.get(0)).setValue(facilityData.getOsName());

		propertyList = PropertyUtil.getProperty(node, NodeProperty.OS_RELEASE);
		((Property)propertyList.get(0)).setValue(facilityData.getOsRelease());

		propertyList = PropertyUtil.getProperty(node, NodeProperty.OS_VERSION);
		((Property)propertyList.get(0)).setValue(facilityData.getOsVersion());
		
		//data.setPingWatch(facility.getPingWatch());
		//data.setPingWatchStatus(facility.getPingWatchStatus());

		propertyList = PropertyUtil.getProperty(node, NodeProperty.PLATFORM_FAMILY_NAME);
		((Property)propertyList.get(0)).setValue(facilityData.getPlatform());

		//data.setStatusWatch(facility.getStatusWatch());
		
		
		propertyList = PropertyUtil.getProperty(node, NodeProperty.SNMP_PORT);
		((Property)propertyList.get(0)).setValue(facilityData.getSnmpPort());

		propertyList = PropertyUtil.getProperty(node, NodeProperty.SNMP_COMMUNITY);
		((Property)propertyList.get(0)).setValue(facilityData.getSnmpCommunity());

		propertyList = PropertyUtil.getProperty(node, NodeProperty.SNMP_VERSION);
		((Property)propertyList.get(0)).setValue(facilityData.getSnmpVersion());

		//data.setSortValue(facility.getSortValue());
		
		propertyList = PropertyUtil.getProperty(node, NodeProperty.VALID);
		((Property)propertyList.get(0)).setValue(facilityData.getValid());


		propertyList = PropertyUtil.getProperty(node, NodeProperty.SNMPTIMEOUT);
		((Property)propertyList.get(0)).setValue(facilityData.getSnmpTimeout());

		propertyList = PropertyUtil.getProperty(node, NodeProperty.SNMPRETRIES);
		((Property)propertyList.get(0)).setValue(facilityData.getSnmpRetries());

		propertyList = PropertyUtil.getProperty(node, NodeProperty.SNMPPROXY);
		((Property)propertyList.get(0)).setValue(facilityData.getSnmpProxy());
		
		
		//WBEM
		propertyList = PropertyUtil.getProperty(node, NodeProperty.WBEM_USER);
		((Property)propertyList.get(0)).setValue(facilityData.getWbemUser());
		
		propertyList = PropertyUtil.getProperty(node, NodeProperty.WBEM_USER_PASSWORD);
		((Property)propertyList.get(0)).setValue(facilityData.getWbemUserPassword());
		
		propertyList = PropertyUtil.getProperty(node, NodeProperty.WBEM_PORT);
		((Property)propertyList.get(0)).setValue(facilityData.getWbemPort());
		
		propertyList = PropertyUtil.getProperty(node, NodeProperty.WBEM_PROTOCOL);
		((Property)propertyList.get(0)).setValue(facilityData.getWbemProtocol());
		
		propertyList = PropertyUtil.getProperty(node, NodeProperty.WBEM_TIMEOUT);
		((Property)propertyList.get(0)).setValue(facilityData.getWbemTimeout());
		
		propertyList = PropertyUtil.getProperty(node, NodeProperty.WBEM_RETRIES);
		((Property)propertyList.get(0)).setValue(facilityData.getWbemRetries());
		
		
		
		propertyList = PropertyUtil.getProperty(node, NodeProperty.ICONIMAGE);
		((Property)propertyList.get(0)).setValue(facilityData.getIconImage());

		//propertyList = PropertyUtil.getProperty(node, NodeProperty.NOTE);
		//((Property)propertyList.get(0)).setValue(facilityData.getNote());//ArrayList
		PropertyUtil.setPropertyValue(node, NodeProperty.NOTE, facilityData.getNote());
		propertyList = PropertyUtil.getProperty(node, NodeProperty.NOTE);
		Property parentNote = (Property)((Property)propertyList.get(0)).getParent();
		if(facilityData.getNote() != null){
			int index = PropertyUtil.getPropertyIndex(parentNote, (Property)propertyList.get(0));
			for(int i = 0; i < facilityData.getNote().size(); i++){
				if(i == 0){
					((Property)propertyList.get(0)).setValue(facilityData.getNote().get(i));
				}
				else{
					Property copy = PropertyUtil.copy((Property)propertyList.get(0));
					
					((Property)propertyList.get(0)).setValue(facilityData.getNote().get(i));
					
					parentNote.addChildren(copy, index + i);
				}
			}
		}

		propertyList = PropertyUtil.getProperty(node, NodeProperty.VIRTNODETYPE);
		((Property)propertyList.get(0)).setValue(facilityData.getVirtNodeType());
		
		propertyList = PropertyUtil.getProperty(node, NodeProperty.VMMANAGEMENTNODE);
		((Property)propertyList.get(0)).setValue(facilityData.getVMManagementNode());

		propertyList = PropertyUtil.getProperty(node, NodeProperty.VMINDEX);
		((Property)propertyList.get(0)).setValue(facilityData.getVmIndex());

		propertyList = PropertyUtil.getProperty(node, NodeProperty.VMNAME);
		((Property)propertyList.get(0)).setValue(facilityData.getVmName());

		propertyList = PropertyUtil.getProperty(node, NodeProperty.VIRTSOLUTION);
		((Property)propertyList.get(0)).setValue(facilityData.getVirtSolution());

		propertyList = PropertyUtil.getProperty(node, NodeProperty.VMID);
		((Property)propertyList.get(0)).setValue(facilityData.getVmId());

		propertyList = PropertyUtil.getProperty(node, NodeProperty.VMUSER);
		((Property)propertyList.get(0)).setValue(facilityData.getVmUser());

		propertyList = PropertyUtil.getProperty(node, NodeProperty.VMUSERPASSWORD);
		((Property)propertyList.get(0)).setValue(facilityData.getVmUserpassword());

		propertyList = PropertyUtil.getProperty(node, NodeProperty.VMPROTOCOL);
		((Property)propertyList.get(0)).setValue(facilityData.getVmProtocol());

		
		//デバイス
		propertyList = PropertyUtil.getProperty(node, NodeProperty.DEVICE);
		Property deviceProperty = (Property)propertyList.get(0);
		int index = PropertyUtil.getPropertyIndex(node, deviceProperty);
		
		//デバイスを取得
		Collection deviceList = null;
		deviceList = facilityData.getDeviceInfo();
		if(deviceList != null){
			Iterator itr = deviceList.iterator();
			int i = 0;
			while(itr.hasNext()){
				DeviceInfoData d = (DeviceInfoData)itr.next();
				if(i == 0){
					//デバイス表示名を表示
					deviceProperty.setValue(d.getDisplayName());
					
					//デバイス表示名
					propertyList = PropertyUtil.getProperty(deviceProperty, NodeProperty.DEVICE_DISPLAY_NAME);
					if(d.getDisplayName() != null && d.getDisplayName().compareTo("") != 0){
						((Property)propertyList.get(0)).setValue(d.getDisplayName());
					}
					//デバイス名
					propertyList = PropertyUtil.getProperty(deviceProperty, NodeProperty.DEVICE_NAME);
					if(d.getDeviceName() != null && d.getDeviceName().compareTo("") != 0){
						((Property)propertyList.get(0)).setValue(d.getDeviceName());
					}
					//デバイスOID
					propertyList = PropertyUtil.getProperty(deviceProperty, NodeProperty.DEVICE_OID);
					if(d.getSnmpOID() != null && d.getSnmpOID().compareTo("") != 0){
						((Property)propertyList.get(0)).setValue(d.getSnmpOID());
					}
					//デバイスINDEX
					propertyList = PropertyUtil.getProperty(deviceProperty, NodeProperty.DEVICE_INDEX);
					if(d.getDeviceIndex() != null){
						((Property)propertyList.get(0)).setValue(d.getDeviceIndex());
					}
					//デバイス種別
					propertyList = PropertyUtil.getProperty(deviceProperty, NodeProperty.DEVICE_TYPE);
					if(d.getDeviceType() != null && d.getDeviceType().compareTo("") != 0){
						((Property)propertyList.get(0)).setValue(d.getDeviceType());
					}
					//説明
					propertyList = PropertyUtil.getProperty(deviceProperty, NodeProperty.DEVICE_DESCRIPTION);
					if(d.getDescription() != null && d.getDescription().compareTo("") != 0){
						((Property)propertyList.get(0)).setValue(d.getDescription());
					}
					m_log.debug("i==0");
					m_log.debug("d.getDisplayName() = " + d.getDisplayName());
					m_log.debug("d.getDeviceName() = " + d.getDeviceName());
					m_log.debug("d.getSnmpOID() = " + d.getSnmpOID());
					m_log.debug("d.getDeviceIndex() = " + d.getDeviceIndex());
					m_log.debug("d.getDeviceType() = " + d.getDeviceType());
					m_log.debug("d.getDescription() = " + d.getDescription());
					m_log.debug("d.getFacilityId() = " + d.getFacilityId());
					m_log.debug("d.getCn() = " + d.getCn());
					m_log.debug("d.getDn() = " + d.getDn());

				}
				else{
					Property copy = PropertyUtil.copy(deviceProperty);
					
					//デバイス表示名を表示
					copy.setValue(d.getDisplayName());
					
					//デバイス表示名
					propertyList = PropertyUtil.getProperty(copy, NodeProperty.DEVICE_DISPLAY_NAME);
					if(d.getDisplayName() != null && d.getDisplayName().compareTo("") != 0){
						((Property)propertyList.get(0)).setValue(d.getDisplayName());
					}
					//デバイス名
					propertyList = PropertyUtil.getProperty(copy, NodeProperty.DEVICE_NAME);
					if(d.getDeviceName() != null && d.getDeviceName().compareTo("") != 0){
						((Property)propertyList.get(0)).setValue(d.getDeviceName());
					}
					//デバイスOID
					propertyList = PropertyUtil.getProperty(copy, NodeProperty.DEVICE_OID);
					if(d.getSnmpOID() != null && d.getSnmpOID().compareTo("") != 0){
						((Property)propertyList.get(0)).setValue(d.getSnmpOID());
					}
					//デバイスINDEX
					propertyList = PropertyUtil.getProperty(copy, NodeProperty.DEVICE_INDEX);
					if(d.getDeviceIndex() != null){
						((Property)propertyList.get(0)).setValue(d.getDeviceIndex());
					}
					//デバイス種別
					propertyList = PropertyUtil.getProperty(copy, NodeProperty.DEVICE_TYPE);
					if(d.getDeviceType() != null && d.getDeviceType().compareTo("") != 0){
						((Property)propertyList.get(0)).setValue(d.getDeviceType());
					}
					//説明
					propertyList = PropertyUtil.getProperty(copy, NodeProperty.DEVICE_DESCRIPTION);
					if(d.getDescription() != null && d.getDescription().compareTo("") != 0){
						((Property)propertyList.get(0)).setValue(d.getDescription());
					}
					node.addChildren(copy, index + i);
					m_log.debug("i!=0");
					m_log.debug("d.getDisplayName() = " + d.getDisplayName());
					m_log.debug("d.getDeviceName() = " + d.getDeviceName());
					m_log.debug("d.getSnmpOID() = " + d.getSnmpOID());
					m_log.debug("d.getDeviceIndex() = " + d.getDeviceIndex());
					m_log.debug("d.getDeviceType() = " + d.getDeviceType());
					m_log.debug("d.getDescription() = " + d.getDescription());
					m_log.debug("d.getFacilityId() = " + d.getFacilityId());
					m_log.debug("d.getCn() = " + d.getCn());
					m_log.debug("d.getDn() = " + d.getDn());
				}
				i++;
			}
		}
		
		//ファイルシステム
		propertyList = PropertyUtil.getProperty(node, NodeProperty.FILE_SYSTEM);
		Property fileSystemProperty = (Property)propertyList.get(0);
		index = PropertyUtil.getPropertyIndex(node, fileSystemProperty);
		
		//ファイルシステムを取得
		Collection fileSystemList = null;
		fileSystemList = facilityData.getFileSystemInfo();
		if(fileSystemList != null){
			Iterator itr = fileSystemList.iterator();
			int i = 0;
			while(itr.hasNext()){
				FileSystemInfoData fs = (FileSystemInfoData)itr.next();
				if(i == 0){
					//ファイルシステム表示名を表示
					fileSystemProperty.setValue(fs.getDisplayName());
					
				    //ファイルシステム表示名
					propertyList = PropertyUtil.getProperty(fileSystemProperty, NodeProperty.FILE_SYSTEM_DISPLAY_NAME);
					if(fs.getDisplayName() != null && fs.getDisplayName().compareTo("") != 0){
						((Property)propertyList.get(0)).setValue(fs.getDisplayName());
					}
					//ファイルシステムINDEX
					propertyList = PropertyUtil.getProperty(fileSystemProperty, NodeProperty.FILE_SYSTEM_INDEX);
					if(fs.getCn() != null){
						((Property)propertyList.get(0)).setValue(fs.getCn());
					}
				    //マウント位置
					propertyList = PropertyUtil.getProperty(fileSystemProperty, NodeProperty.FILE_SYSTEM_MOUNT_POINT);
					if(fs.getFileSystemMountPoint() != null && fs.getFileSystemMountPoint().compareTo("") != 0){
						((Property)propertyList.get(0)).setValue(fs.getFileSystemMountPoint());
					}
					//ファイルシステムOID
					propertyList = PropertyUtil.getProperty(fileSystemProperty, NodeProperty.FILE_SYSTEM_OID);
					if(fs.getSnmpOID() != null && fs.getSnmpOID().compareTo("") != 0){
						((Property)propertyList.get(0)).setValue(fs.getSnmpOID());
					}
					//ファイルシステム種別
					propertyList = PropertyUtil.getProperty(fileSystemProperty, NodeProperty.FILE_SYSTEM_TYPE);
					if(fs.getFileSystemType() != null && fs.getFileSystemType().compareTo("") != 0){
						((Property)propertyList.get(0)).setValue(fs.getFileSystemType());
					}
					//説明
					propertyList = PropertyUtil.getProperty(fileSystemProperty, NodeProperty.FILE_SYSTEM_DESCRIPTION);
					if(fs.getDescription() != null && fs.getDescription().compareTo("") != 0){
						((Property)propertyList.get(0)).setValue(fs.getDescription());
					}
					m_log.info("i==0");
					m_log.info("fs.getDisplayName() = " + fs.getDisplayName());
					m_log.info("fs.getCn() = " + fs.getCn());
					m_log.info("fs.getFileSystemMountPoint() = " + fs.getFileSystemMountPoint());
					m_log.info("fs.getSnmpOID() = " + fs.getSnmpOID());
					m_log.info("fs.getFileSystemType() = " + fs.getFileSystemType());
					m_log.info("fs.getDescription() = " + fs.getDescription());
					m_log.info("fs.getDn() = " + fs.getDn());
					m_log.info("fs.getFacilityId() = " + fs.getFacilityId());
				}
				else{
					Property copy = PropertyUtil.copy(fileSystemProperty);
					
					//ファイルシステム表示名を表示
					copy.setValue(fs.getDisplayName());
					
				    //ファイルシステム表示名
					propertyList = PropertyUtil.getProperty(copy, NodeProperty.FILE_SYSTEM_DISPLAY_NAME);
					if(fs.getDisplayName() != null && fs.getDisplayName().compareTo("") != 0){
						((Property)propertyList.get(0)).setValue(fs.getDisplayName());
					}
					//ファイルシステムINDEX
					propertyList = PropertyUtil.getProperty(copy, NodeProperty.FILE_SYSTEM_INDEX);
					if(fs.getCn() != null){
						((Property)propertyList.get(0)).setValue(fs.getCn());
					}
					//マウント位置
					propertyList = PropertyUtil.getProperty(copy, NodeProperty.FILE_SYSTEM_MOUNT_POINT);
					if(fs.getFileSystemMountPoint() != null && fs.getFileSystemMountPoint().compareTo("") != 0){
						((Property)propertyList.get(0)).setValue(fs.getFileSystemMountPoint());
					}
					//ファイルシステムOID
					propertyList = PropertyUtil.getProperty(copy, NodeProperty.FILE_SYSTEM_OID);
					if(fs.getSnmpOID() != null && fs.getSnmpOID().compareTo("") != 0){
						((Property)propertyList.get(0)).setValue(fs.getSnmpOID());
					}
					//ファイルシステム種別
					propertyList = PropertyUtil.getProperty(copy, NodeProperty.FILE_SYSTEM_TYPE);
					if(fs.getFileSystemType() != null && fs.getFileSystemType().compareTo("") != 0){
						((Property)propertyList.get(0)).setValue(fs.getFileSystemType());
					}
					//説明
					propertyList = PropertyUtil.getProperty(copy, NodeProperty.FILE_SYSTEM_DESCRIPTION);
					if(fs.getDescription() != null && fs.getDescription().compareTo("") != 0){
						((Property)propertyList.get(0)).setValue(fs.getDescription());
					}
					node.addChildren(copy, index + i);
					m_log.info("i!=0");
					m_log.info("fs.getDisplayName() = " + fs.getDisplayName());
					m_log.info("fs.getCn() = " + fs.getCn());
					m_log.info("fs.getFileSystemMountPoint() = " + fs.getFileSystemMountPoint());
					m_log.info("fs.getSnmpOID() = " + fs.getSnmpOID());
					m_log.info("fs.getFileSystemType() = " + fs.getFileSystemType());
					m_log.info("fs.getDescription() = " + fs.getDescription());
					m_log.info("fs.getDn() = " + fs.getDn());
					m_log.info("fs.getFacilityId() = " + fs.getFacilityId());
				}
				i++;
			}
		}
		
		return node;
	}
	
	/**
	 * facilityIdよりプロパティオブジェクトをDataオブジェクトとして返却
	 * @param facilityId
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public FacilityData getNodeFacilityData(String facilityId) throws FinderException, NamingException {

		FacilityData data = null;
		try {
			FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
	
			data = new FacilityData();
			
			//Dataオブジェクトへの詰め替え
			data.setType(facility.getType());
			data.setDn(facility.getDn());
			
			data.setAgentControl(facility.getAgentControl());
			data.setAgentWatch(facility.getAgentWatch());
			data.setAgentWatchStatus(facility.getAgentWatchStatus());
			
			data.setCharSet(facility.getCharSet());
			data.setCn(facility.getCn());
			data.setCreateTimestamp(facility.getCreateTimestamp());
			data.setCreatorsName(facility.getCreatorsName());
			
			data.setDescription(facility.getDescription());
			data.setDhcpClient(facility.getDhcpClient());
			
			data.setFacilityId(facility.getFacilityId());
			data.setHost(facility.getHost());
			
			data.setIpNetworkNumber(facility.getIpNetworkNumber());
			data.setIpNetworkNumberV6(facility.getIpNetworkNumberV6());
			data.setIpProtocolNumber(facility.getIpProtocolNumber());
			data.setIpType(facility.getIpType());
			
			data.setLogWatch(facility.getLogWatch());
			
			data.setMachine(facility.getMachine());
			data.setManagerContact(facility.getManagerContact());
			data.setManagerName(facility.getManagerName());
			data.setModifiersName(facility.getModifiersName());
			data.setModifyTimestamp(facility.getModifyTimestamp());
			
			data.setNodeName(facility.getNodeName());
			
			data.setOsName(facility.getOsName());
			data.setOsRelease(facility.getOsRelease());
			data.setOsVersion(facility.getOsVersion());
			
			data.setPingWatch(facility.getPingWatch());
			data.setPingWatchStatus(facility.getPingWatchStatus());
			data.setPlatform(facility.getPlatform());

			data.setStatusWatch(facility.getStatusWatch());
			data.setSnmpPort(facility.getSnmpPort());
			data.setSnmpCommunity(facility.getSnmpCommunity());
			data.setSnmpVersion(facility.getSnmpVersion());
			data.setSortValue(facility.getSortValue());
			
			data.setValid(facility.getValid());
			
			data.setSnmpTimeout(facility.getSnmpTimeout());
			data.setSnmpRetries(facility.getSnmpRetries());
			data.setSnmpProxy(facility.getSnmpProxy());
			
			data.setIconImage(facility.getIconImage());
			data.setNote(facility.getNote());
			
			data.setVirtNodeType(facility.getVirtNodeType());
			data.setVMManagementNode(facility.getVMManagementNode());
			data.setVmIndex(facility.getVmIndex());
			data.setVmName(facility.getVmName());
			data.setVirtSolution(facility.getVirtSolution());
			data.setVmId(facility.getVmId());
			data.setVmUser(facility.getVmUser());
			data.setVmUserpassword(facility.getVmUserpassword());
			data.setVmProtocol(facility.getVmProtocol());
			
			data.setWbemPort(facility.getWbemPort());
			data.setWbemProtocol(facility.getWbemProtocol());
			data.setWbemRetries(facility.getWbemRetries());
			data.setWbemTimeout(facility.getWbemTimeout());
			data.setWbemUser(facility.getWbemUser());
			data.setWbemUserPassword(facility.getWbemUserPassword());


			// Collection系
			data.setDeviceInfo(getDeviceList(facilityId));
			data.setFileSystemInfo(getFileSystemList(facilityId));
			
		} catch (FinderException e) {
			// TODO: handle exception
			throw e;
		} catch (NamingException e) {
			// TODO: handle exception
			throw e;
		}
		
		return data;
	}
	
	/**
	 * ファイルシステム一覧を取得
	 * 
	 * DeviceInfoDataの配列を返す
	 * 
	 * @param facilityId
	 * @return FileSystemInfoDataの配列
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList<FileSystemInfoData> getFileSystemList(String facilityId) throws FinderException, NamingException {
		ArrayList<FileSystemInfoData> list = null;
		try {
			//デバイスのデータをリポジトリから取得
			//FacilityTreeの最上位エントリを取得
			Collection ct = FileSystemInfoUtil.getLocalHome().findByFacilityId(facilityId);
			
			list = new ArrayList<FileSystemInfoData>();
			
			//ファイルシステムのデータをリポジトリから取得
			//FacilityTreeの最上位エントリを取得
			
			Iterator itr = ct.iterator();
			while(itr.hasNext()){
				FileSystemInfoLocal f = (FileSystemInfoLocal)itr.next();
				
				FileSystemInfoData data = new FileSystemInfoData(
						f.getDn(), 
						f.getCn(),
						f.getFacilityId(), 
						f.getDescription(), 
						f.getFileSystemMountPoint(),
						f.getFileSystemType(),
						f.getSnmpOID(),
						f.getDisplayName());
				
				list.add(data);
			}
			
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return list;
	}
	
	/**
	 * ノード詳細を取得
	 * 
	 * 属性名と値のHashMapとして返す
	 * 
	 * @param facilityId
	 * @param attributes
	 * @return 属性名と値のHashMap
	 * @throws FinderException
	 * @throws NamingException
	 */
	public HashMap getNodeDetail(String facilityId, ArrayList attributes) throws FinderException, NamingException {
		HashMap map = new HashMap();
		try {
			FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
			
			for(int i = 0; i < attributes.size(); i++){
				//属性取得
				String attribute = (String)attributes.get(i);
				
				if(attribute.compareTo(FacilityAttributeConstant.FACILITYID) == 0){
					//ccFacilityId取得
					map.put(attribute, facility.getFacilityId());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.CN) == 0){
					//cn取得
					map.put(attribute, facility.getCn());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.DESCRIPTION) == 0){
					//description取得
					map.put(attribute, facility.getDescription());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.AGENTCONTROL) == 0){
					//ccAgentControl取得
					map.put(attribute, facility.getAgentControl());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.AGENTWATCH) == 0){
					//ccAgentWatch取得
					map.put(attribute, facility.getAgentWatch());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.AGENTWATCHSTATUS) == 0){
					//ccAgentWatchStatus取得
					map.put(attribute, facility.getAgentWatchStatus());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.CHARSET) == 0){
					//ccCharSet取得
					map.put(attribute, facility.getCharSet());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.CREATETIMESTAMP) == 0){
					//ccCreateTimestamp取得
					map.put(attribute, facility.getCreateTimestamp());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.CREATORSNAME) == 0){
					//ccCreatorsName取得
					map.put(attribute, facility.getCreatorsName());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.DHCPCLIENT) == 0){
					//ccDhcpClient取得
					map.put(attribute, facility.getDhcpClient());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.HOST) == 0){
					//host取得
					map.put(attribute, facility.getHost());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.IPNETWORKNUMBER) == 0){
					//ipNetworkNumber取得
					map.put(attribute, facility.getIpNetworkNumber());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.IPNETWORKNUMBERV6) == 0){
					//ccIpNetworkNumberV6取得
					map.put(attribute, facility.getIpNetworkNumberV6());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.IPPROTOCOLNUMBER) == 0){
					//ipProtocolNumber取得
					map.put(attribute, facility.getIpProtocolNumber());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.IPTYPE) == 0){
					//ccIpType取得
					map.put(attribute, facility.getIpType());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.LOGWATCH) == 0){
					//ccLogWatch取得
					map.put(attribute, facility.getLogWatch());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.MACHINE) == 0){
					//ccMachine取得
					map.put(attribute, facility.getMachine());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.MANAGERCONTACT) == 0){
					//ccManagerContact取得
					map.put(attribute, facility.getManagerContact());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.MANAGERNAME) == 0){
					//ccManagerName取得
					map.put(attribute, facility.getManagerName());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.MODIFIERSNAME) == 0){
					//ccModifiersName取得
					map.put(attribute, facility.getModifiersName());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.MODIFYTIMESTAMP) == 0){
					//ccModifyTimestamp取得
					map.put(attribute, facility.getModifyTimestamp());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.NODENAME) == 0){
					//ccNodeName取得
					map.put(attribute, facility.getNodeName());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.OSNAME) == 0){
					//ccOsName取得
					map.put(attribute, facility.getOsName());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.OSRELEASE) == 0){
					//ccOsRelease取得
					map.put(attribute, facility.getOsRelease());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.OSVERSION) == 0){
					//ccOsVersion取得
					map.put(attribute, facility.getOsVersion());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.PINGWATCH) == 0){
					//ccPingWatch取得
					map.put(attribute, facility.getPingWatch());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.PINGWATCHSTATUS) == 0){
					//ccPingWatchStatus取得
					map.put(attribute, facility.getPingWatchStatus());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.PLATFORM) == 0){
					//ccPlatform取得
					map.put(attribute, facility.getPlatform());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.STATUSWATCH) == 0){
					//ccPlatform取得
					map.put(attribute, facility.getStatusWatch());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.SORT_VALUE) == 0){
					//ccSortValue取得
					map.put(attribute, facility.getSortValue());
				}
				// SNMP設定の取得方法を追加
				else if(attribute.compareTo(FacilityAttributeConstant.SNMPCOMMUNITY) == 0){
					//ccSnmpCommunity取得
					map.put(attribute, facility.getSnmpCommunity());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.SNMPPORT) == 0){
					//ccSnmpPort取得
					map.put(attribute, facility.getSnmpPort());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.SNMPVERSION) == 0){
					//ccSnmpVersion取得
					map.put(attribute, facility.getSnmpVersion());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.VALID) == 0){
					//ccValid取得
					map.put(attribute, facility.getValid());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.SNMPTIMEOUT) == 0){
					//ccSnmpTImeout取得
					map.put(attribute, facility.getSnmpTimeout());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.SNMPRETRIES) == 0){
					//ccSnmpRetries取得
					map.put(attribute, facility.getSnmpRetries());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.SNMPPROXY) == 0){
					//ccSnmpProxy取得
					map.put(attribute, facility.getSnmpProxy());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.NOTE) == 0){
					//ccNote取得
					map.put(attribute, facility.getNote());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.ICONIMAGE) == 0){
					//ccIconImage取得
					map.put(attribute, facility.getIconImage());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.VIRTNODETYPE) == 0){
					//ccVirtualizationNodeType取得
					map.put(attribute, facility.getVirtNodeType());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.VMMANAGEMENTNODE) == 0){
					//ccVmManagementNode取得
					map.put(attribute, facility.getVMManagementNode());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.VMINDEX) == 0){
					//ccVMID取得
					map.put(attribute, facility.getVmIndex());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.VMNAME) == 0){
					//ccVMName取得
					map.put(attribute, facility.getVmName());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.VIRTSOLUTION) == 0){
					//ccVirtualizationSolution取得
					map.put(attribute, facility.getVirtSolution());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.VMID) == 0){
					//ccVMId取得
					map.put(attribute, facility.getVmId());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.VMUSER) == 0){
					//ccVMUser取得
					map.put(attribute, facility.getVmUser());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.VMUSERPASSWORD) == 0){
					//ccVMUserPassword取得
					map.put(attribute, facility.getVmUserpassword());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.VMPROTOCOL) == 0){
					//ccVMProtocol取得
					map.put(attribute, facility.getVmProtocol());
				}
				
				// WBEM設定の取得方法を追加
				else if(attribute.compareTo(FacilityAttributeConstant.WBEMUSER) == 0){
					//WBEMUser取得
					map.put(attribute, facility.getWbemUser());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.WBEMUSERPASSWORD) == 0){
					//ccVMUserPassword取得
					map.put(attribute, facility.getWbemUserPassword());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.WBEMPORT) == 0){
					//WBEMPort取得
					map.put(attribute, facility.getWbemPort());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.WBEMPROTOCOL) == 0){
					//WBEMProtocol取得
					map.put(attribute, facility.getWbemProtocol());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.WBEMTIMEOUT) == 0){
					//WBEMTimeout取得
					map.put(attribute, facility.getWbemTimeout());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.WBEMRETRIES) == 0){
					//WBEMRetries取得
					map.put(attribute, facility.getWbemRetries());
				}
				
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return map;
	}
	
	/**
	 * ノード詳細を取得
	 * 
	 * ファシリティIDと属性値(属性名と値のHashMap)のHashMapとして返す
	 * 
	 * @param facilityIdList
	 * @param attributes
	 * @return ファシリティIDと属性値(属性名と値のHashMap)のHashMap
	 * @throws NamingException
	 * @throws FinderException
	 */
	public HashMap getNodeDetail(ArrayList facilityIdList, ArrayList attributes) throws FinderException, NamingException {
		HashMap map = new HashMap();
		
		for(int i = 0; i < facilityIdList.size(); i++){
			String facilityId = (String)facilityIdList.get(i);
			HashMap detailMap = getNodeDetail(facilityId, attributes);
			map.put(facilityId, detailMap);
		}
		
		return map;
	}
	
	/**
	 * デバイス一覧を取得
	 * 
	 * DeviceInfoDataの配列を返す
	 * 
	 * @param facilityId
	 * @return DeviceInfoDataの配列
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList<DeviceInfoData> getDeviceList(String facilityId) throws FinderException, NamingException {
		ArrayList<DeviceInfoData> list = null;
		try {
			//デバイスのデータをリポジトリから取得
			//FacilityTreeの最上位エントリを取得
			Collection ct = DeviceInfoUtil.getLocalHome().findByFacilityId(facilityId);
			
			list = new ArrayList<DeviceInfoData>();
			Iterator itr = ct.iterator();
			while(itr.hasNext()){
				DeviceInfoLocal d = (DeviceInfoLocal)itr.next();
				DeviceInfoData data = new DeviceInfoData(
						d.getDn(), 
						d.getCn(), 
						d.getFacilityId(), 
						d.getDescription(), 
						d.getDeviceIndex(), 
						d.getDeviceName(), 
						d.getDeviceType(), 
						d.getSnmpOID(),
						d.getDisplayName());
				
				list.add(data);
			}
			
			//ファイルシステムのデータをリポジトリから取得
			//FacilityTreeの最上位エントリを取得
			ct = FileSystemInfoUtil.getLocalHome().findByFacilityId(facilityId);
			
			itr = ct.iterator();
			while(itr.hasNext()){
				FileSystemInfoLocal f = (FileSystemInfoLocal)itr.next();
				DeviceInfoData data = new DeviceInfoData(
						f.getDn(), 
						f.getCn().toString(), 	// cnをStringで渡す
						f.getFacilityId(), 
						f.getDescription(), 
						f.getCn(),				// FileSystemIndex
						f.getFileSystemMountPoint(),
						DeviceTypeConstant.DEVICE_FILESYSTEM,
						f.getSnmpOID(),
						f.getDisplayName());
				
				list.add(data);
			}
			
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return list;
	}
	
	
	/**
	 * ノード一覧を取得
	 * 
	 * オブジェクトの2次元配列として返す
	 * 
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNodeList() throws FinderException, NamingException {
		ArrayList list = null;
		try {
			//Facilityの最上位エントリを取得
			Collection ct = FacilityUtil.getLocalHome().findAllNode();
			
			list = new ArrayList();
			Iterator itr = ct.iterator();
			while(itr.hasNext()){
				FacilityLocal ft = (FacilityLocal)itr.next();
				
				ArrayList info = new ArrayList();
				info.add(ft.getFacilityId());
				info.add(ft.getCn());
				info.add(ft.getDescription());
				list.add(info);
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return list;
	}
	
	/**
	 * ノード一覧を取得
	 * 
	 * オブジェクトの2次元配列として返す
	 * 
	 * @param parentFacilityId
	 * @param level
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNodeList(String parentFacilityId, int level) throws FinderException, NamingException {
		ArrayList list = null;
		try {
			Collection ct = null;
			if(level == RepositoryControllerBean.ALL){
				//FacilityTreeの最上位エントリを取得
				ct = FacilityTreeUtil.getLocalHome().findAllNode(parentFacilityId);
			}
			else{
				//FacilityTreeの最上位エントリを取得
				ct = FacilityTreeUtil.getLocalHome().findOneLevelNode(parentFacilityId);
			}
			
			HashMap map = new HashMap();
			list = new ArrayList();
			Iterator itr = ct.iterator();
			while(itr.hasNext()){
				FacilityTreeLocal ft = (FacilityTreeLocal)itr.next();
				
				if(map.get(ft.getFacilityId()) == null){
					map.put(ft.getFacilityId(), "1");
					
					FacilityLocal facility = ft.getFacility();
					ArrayList info = new ArrayList();
					info.add(facility.getFacilityId());
					info.add(facility.getCn());
					info.add(facility.getDescription());
					list.add(info);
				}
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return list;
	}
	
	/**
	 * ノード一覧を取得
	 * 
	 * オブジェクトの2次元配列として返す
	 * 
	 * @param property
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNodeList(Property property) throws FinderException, NamingException {
		ArrayList list = null;
		try {
			ArrayList values = null;
			//ファシリティID取得
			values = PropertyUtil.getPropertyValue(property, NodeFilterProperty.FACILITY_ID);
			String facilityId = (String)values.get(0);
			//ファシリティ名取得
			values = PropertyUtil.getPropertyValue(property, NodeFilterProperty.FACILITY_NAME);
			String facilityName = (String)values.get(0);
			//説明取得
			values = PropertyUtil.getPropertyValue(property, NodeFilterProperty.DESCRIPTION);
			String description = (String)values.get(0);
			//IPアドレス v4 取得
			values = PropertyUtil.getPropertyValue(property, NodeFilterProperty.IP_ADDRESS_V4);
			String ipAddressV4 = (String)values.get(0);
			//IPアドレス v6 取得
			values = PropertyUtil.getPropertyValue(property, NodeFilterProperty.IP_ADDRESS_V6);
			String ipAddressV6 = (String)values.get(0);
			//OS名取得
			values = PropertyUtil.getPropertyValue(property, NodeFilterProperty.OS_NAME);
			String osName = (String)values.get(0);
			//OSリリース取得
			values = PropertyUtil.getPropertyValue(property, NodeFilterProperty.OS_RELEASE);
			String osRelease = (String)values.get(0);
			//管理者取得
			values = PropertyUtil.getPropertyValue(property, NodeFilterProperty.ADMINISTRATOR);
			String managerName = (String)values.get(0);
			//連絡先取得
			values = PropertyUtil.getPropertyValue(property, NodeFilterProperty.CONTACT);
			String managerContact = (String)values.get(0);
			
			//Facilityの最上位から検索する
			Collection ct = 
				FacilityUtil.getLocalHome().findNode(
						facilityId, 
						facilityName, 
						description, 
						ipAddressV4, 
						ipAddressV6, 
						osName, 
						osRelease, 
						managerName, 
						managerContact);
			
			list = new ArrayList();
			Iterator itr = ct.iterator();
			while(itr.hasNext()){
				FacilityLocal ft = (FacilityLocal)itr.next();
				
				ArrayList info = new ArrayList();
				info.add(ft.getFacilityId());
				info.add(ft.getCn());
				info.add(ft.getDescription());
				list.add(info);
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return list;
	}
	
	/**
	 * ファシリティIDリスト取得
	 * 
	 * ファシリティIDの配列として返す
	 * 
	 * @param parentFacilityId
	 * @param level
	 * @param sort
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getFacilityIdList(String parentFacilityId, int level, boolean sort) throws FinderException, NamingException {
		ArrayList list = null;
		try {
			Collection ct = null;
			if(level == RepositoryControllerBean.ALL){
				//FacilityTreeの最上位エントリを取得
				ct = FacilityTreeUtil.getLocalHome().findAll(parentFacilityId);
			}
			else{
				//FacilityTreeの最上位エントリを取得
				ct = FacilityTreeUtil.getLocalHome().findOneLevel(parentFacilityId);
			}
			
			HashMap map = new HashMap();
			list = new ArrayList();
			Iterator itr = ct.iterator();
			int i = 0;
			while(itr.hasNext()){
				if(i == 0){
					//findOneLevel()の結果には親ファシリティは含まれないので追加する
					if(i == 0 && parentFacilityId != null && parentFacilityId.compareTo("") != 0){
						if(map.get(parentFacilityId) == null){
							map.put(parentFacilityId, "1");
							
							list.add(parentFacilityId);
						}
					}
					i++;
				}
				
				FacilityTreeLocal ft = (FacilityTreeLocal)itr.next();
				
				if(map.get(ft.getFacilityId()) == null){
					map.put(ft.getFacilityId(), "1");
					
					list.add(ft.getFacilityId());
				}
			}
			
			//ソートする
			if(sort){
				ListSorter sorter = new ListSorter();
				sorter.sort(list);
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return list;
	}
	
	/**
	 * ファシリティIDリスト取得
	 * 
	 * ファシリティIDの配列として返す
	 * 
	 * @param parentFacilityId
	 * @param level
	 * @param valid 有効/無効フラグ 有効:true, 無効:false, 指定なし:null
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNodeFacilityIdList(String parentFacilityId, int level, boolean sort, Boolean valid) throws FinderException, NamingException {
		ArrayList list = null;
		try {
			Collection ct = null;
			
			// 配下すべてのエントリ
			if(level == RepositoryControllerBean.ALL){
				
				if (valid == null) {
					//FacilityTreeの最上位エントリを取得
					ct = FacilityTreeUtil.getLocalHome().findAllNode(parentFacilityId);
					
				} else {
					//有効/無効フラグを指定する場合
					ct = FacilityTreeUtil.getLocalHome().findAllNodeByValid(parentFacilityId, valid);
				}
			
			// 直下のみ
			} else {
				if (valid == null) {
					//FacilityTreeの最上位エントリを取得
					ct = FacilityTreeUtil.getLocalHome().findOneLevelNode(parentFacilityId);

				} else {
					//有効/無効フラグを指定する場合
					ct = FacilityTreeUtil.getLocalHome().findOneLevelNodeByValid(parentFacilityId, valid);
			
				}
				
			}
			
			//FacilityIdの重複を排除する
			HashMap map = new HashMap();
			list = new ArrayList();
			Iterator itr = ct.iterator();
			while(itr.hasNext()){
				FacilityTreeLocal ft = (FacilityTreeLocal)itr.next();
				
				if(map.get(ft.getFacilityId()) == null){
					map.put(ft.getFacilityId(), "1");
					
					list.add(ft.getFacilityId());
				}
			}
			
			//ソートする
			if(sort){
				ListSorter sorter = new ListSorter();
				sorter.sort(list);
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return list;
	}
	
	/**
	 * ファシリティIDリスト取得
	 * sort値を指定し、全ノードのファシリティIDを配列として返す
	 * 
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNodeFacilityIdList(boolean sort) throws FinderException, NamingException {
		ArrayList list = null;
		try {
			//Facilityの最上位エントリを取得
			Collection ct = FacilityUtil.getLocalHome().findAllNode();
			
			list = new ArrayList();
			Iterator itr = ct.iterator();
			while(itr.hasNext()){
				FacilityLocal ft = (FacilityLocal)itr.next();
				list.add(ft.getFacilityId());
			}
			
			//ソートする
			if(sort){
				ListSorter sorter = new ListSorter();
				sorter.sort(list);
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return list;
	}
	
	/**
	 * スコープ一覧を取得
	 * 
	 * オブジェクトの2次元配列として返す
	 * 
	 * @param parentFacilityId
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getScopeList(String parentFacilityId) throws FinderException, NamingException {
		ArrayList list = null;
		try {
			//FacilityTreeの最上位エントリを取得
			Collection ct = FacilityTreeUtil.getLocalHome().findOneLevel(parentFacilityId);
			
			list = new ArrayList();
			Iterator itr = ct.iterator();
			while(itr.hasNext()){
				FacilityTreeLocal ft = (FacilityTreeLocal)itr.next();
				FacilityLocal facility = ft.getFacility();
				ArrayList info = new ArrayList();
				info.add(facility.getFacilityId());
				info.add(facility.getCn());
				info.add(facility.getDescription());
				//テーブル定義には３つしかないがソート情報として４番目の項目を
				//利用する。
				info.add(ft.getSortValue());
				list.add(info);
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return list;
	}
	
	/**
	 * Facilityを取得
	 * 
	 * @param facilityId
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public FacilityLocal getFacility(String facilityId) throws FinderException, NamingException {
		FacilityLocal facility = null;
		try {
			//Facilityを取得
			facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return facility;
	}
	
	/**
	 * ノードを割当てたスコープ一覧を取得
	 * 
	 * @param facilityId
	 * @param level
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNodeScopeList(String facilityId) throws FinderException, NamingException {
		ArrayList list = null;
		try {
			//FacilityTreeの最上位エントリを取得
			Collection ct = FacilityTreeUtil.getLocalHome().findByFacilityId(facilityId);
			FacilityTreeItem item = this.getFacilityTree(Locale.getDefault(), null);
			
			list = new ArrayList();
			Iterator itr = ct.iterator();
			while(itr.hasNext()){
				FacilityTreeLocal ft = (FacilityTreeLocal)itr.next();
				String dn[] = ft.getDn().split(",");
				StringBuffer path = new StringBuffer();
				for(int i = 1; i < dn.length - 1; i++){
					String id = dn[i].replaceFirst("[\\s\\w]*=", "");
					FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(id);
					if(facility.getType() == FacilityConstant.TYPE_SCOPE){
						path.insert(0, SEPARATOR);
					}
					path.insert(0, facility.getCn());
				}
				ArrayList info = new ArrayList();
				info.add(path.toString());
				list.add(info);
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return list;
	}
	
	/**
	 * ファシリティツリー情報取得（ノード含む）
	 * 
	 * @param locale
	 * @param valid 有効/無効フラグ 有効:true, 無効:false, 指定なし:null
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public FacilityTreeItem getFacilityTree(Locale locale, Boolean valid) throws FinderException, NamingException {
		
		//FacilityTreeの最上位インスタンスを作成
		FacilityInfo info = new FacilityInfo();
		info.setFacilityName(FacilityConstant.STRING_COMPOSITE);
		info.setType(FacilityConstant.TYPE_COMPOSITE);
		FacilityTreeItem tree = new FacilityTreeItem(null, info);
		
		// コンポジットアイテムを生成して返します。
		info = new FacilityInfo();
		info.setFacilityName(Messages.getString("scope", locale));
		info.setType(FacilityConstant.TYPE_COMPOSITE);
		FacilityTreeItem item = new FacilityTreeItem(tree, info);
		
		try {
			//FacilityTreeの最上位エントリを取得
			Collection ct = FacilityTreeUtil.getLocalHome().findOneLevel();
			
			Iterator itr = ct.iterator();
			while(itr.hasNext()){
				FacilityTreeLocal ft = (FacilityTreeLocal)itr.next();
				createFacilityTree(ft, item, valid);
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return tree;
	}
	
	/**
	 * ファシリティツリー情報取得（スコープのみ）
	 * 
	 * @param locale
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public FacilityTreeItem getScopeFacilityTree(Locale locale) throws FinderException, NamingException {
		
		//FacilityTreeの最上位インスタンスを作成
		FacilityInfo info = new FacilityInfo();
		info.setFacilityName(FacilityConstant.STRING_COMPOSITE);
		info.setType(FacilityConstant.TYPE_COMPOSITE);
		FacilityTreeItem tree = new FacilityTreeItem(null, info);
		
		// コンポジットアイテムを生成して返します。
		info = new FacilityInfo();
		info.setFacilityName(Messages.getString("scope", locale));
		info.setType(FacilityConstant.TYPE_COMPOSITE);
		FacilityTreeItem item = new FacilityTreeItem(tree, info);
		
		try {
			//FacilityTreeの最上位エントリを取得
			Collection ct = FacilityTreeUtil.getLocalHome().findOneLevelScope(null);
			
			Iterator itr = ct.iterator();
			while(itr.hasNext()){
				FacilityTreeLocal ft = (FacilityTreeLocal)itr.next();
				createScopeFacilityTree(ft, item);
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return tree;
	}
	
	/**
	 * FacilityTreeItem作成（ノード含む）
	 * 
	 * @param facilityTree
	 * @param parent
	 * @param valid 有効/無効フラグ 有効:true, 無効:false, 指定なし:null
	 */
	protected void createFacilityTree(FacilityTreeLocal facilityTree, FacilityTreeItem parent, Boolean valid) {
		FacilityLocal facility = null;
		try {
			facility = facilityTree.getFacility();
		} catch (FinderException e) {
			return;
		}
		
		FacilityInfo info = null;
		FacilityTreeItem item = null;
		if(facility != null){
			info = new FacilityInfo();
			info.setFacilityId(facility.getFacilityId());
			info.setFacilityName(facility.getCn());
			if(facility.getType() == FacilityConstant.TYPE_NODE){
				
				m_log.debug("createFacilityTree() : facilityId = " + facility.getFacilityId() + ", facilityValid = " + facility.getValid() + ", valid = " + valid);
				
				// 「validがnull」もしくは「facilityのvalidとvalidと等しい」ではない場合
				if( !(valid == null || !(facility.getValid() ^ valid)) ) {
					return;
				}
				info.setType(FacilityConstant.TYPE_NODE);
			}
			else{
				info.setType(FacilityConstant.TYPE_SCOPE);
			}
			
			//ソート順序
			info.setSortOrder(facilityTree.getSortValue());
			//組み込みスコープフラグ
			info.setBuiltInFlg(facilityTree.isBuiltIn());
			//ノード単位の有効／無効
			info.setValid(facilityTree.getValid());
			
			item = new FacilityTreeItem(parent, info);
		}
		
		Collection collection = null;
		try {
			collection = facilityTree.getChildren();
		} catch (FinderException e) {
			//TODO FinderException未実装
		}
		
		if(collection != null && collection.size() > 0){
			Iterator itr = collection.iterator();
			while(itr.hasNext()){
				FacilityTreeLocal children = (FacilityTreeLocal)itr.next();
				createFacilityTree(children, item, valid);
			}
		}
	}
	
	/**
	 * FacilityTreeItem作成（スコープのみ）
	 * 
	 * @param facilityTree
	 * @param parent
	 */
	protected void createScopeFacilityTree(FacilityTreeLocal facilityTree, FacilityTreeItem parent) {
		FacilityLocal facility = null;
		try {
			facility = facilityTree.getFacility();
		} catch (FinderException e) {
			return;
		}
		
		FacilityInfo info = null;
		FacilityTreeItem item = null;
		if(facility != null){
			info = new FacilityInfo();
			info.setFacilityId(facility.getFacilityId());
			info.setFacilityName(facility.getCn());
			info.setSortOrder(facilityTree.getSortValue());
			if(facility.getType() == FacilityConstant.TYPE_SCOPE){
				info.setType(FacilityConstant.TYPE_SCOPE);
				item = new FacilityTreeItem(parent, info);
			}
			else{
				return;
			}
		}
		
		Collection collection = null;
		try {
			collection = facilityTree.getChildren();
		} catch (FinderException e) {
			//TODO FinderException未実装
		}
		
		if(collection != null && collection.size() > 0){
			Iterator itr = collection.iterator();
			while(itr.hasNext()){
				FacilityTreeLocal children = (FacilityTreeLocal)itr.next();
				createScopeFacilityTree(children, item);
			}
		}
	}
	
	/**
	 * ファシリティパス取得
	 * 
	 * ファシリティのパスを返す
	 * 
	 * @param facilityId ファシリティID
	 * @return スコープパス
	 * @throws FinderException
	 * @throws NamingException
	 */
	public String getFacilityPath(String facilityId, String parentFacilityId) throws FinderException, NamingException {
		try {
			Collection ct = FacilityTreeUtil.getLocalHome().findByFacilityId(facilityId);
			
			if(ct != null){
				FacilityTreeLocal tree = null;
				Iterator itr = ct.iterator();
				if(itr.hasNext()){
					tree = (FacilityTreeLocal)itr.next();
				}
				
				if(tree != null){
					StringBuffer buffer = new StringBuffer();
					if (tree.getTreeType().intValue() == FacilityConstant.TYPE_SCOPE) {
						//スコープのパスを取得
						if(parentFacilityId != null && parentFacilityId.length() > 0){
							//相対パスを取得
							FacilityTreeLocal parentTree = tree;
							while (parentTree != null) {
								FacilityLocal parent = parentTree.getFacility();
								if(parentFacilityId.compareTo(parent.getFacilityId()) == 0){
									if(buffer.length() == 0){
										buffer.insert(0, SEPARATOR);
									}
									break;
								}
								buffer.insert(0, SEPARATOR);
								buffer.insert(0, parent.getCn());
								parentTree = parentTree.getParent();
							}
						}
						else{
							//絶対パスを取得
							FacilityTreeLocal parentTree = tree;
							while (parentTree != null) {
								FacilityLocal parent = parentTree.getFacility();
								buffer.insert(0, SEPARATOR);
								buffer.insert(0, parent.getCn());
								parentTree = parentTree.getParent();
							}
						}
					}
					else{
						//ノードの場合、ノード名を取得
						FacilityLocal facility = tree.getFacility();
						buffer.append(facility.getCn());
					}
					
					return buffer.toString();
				}
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return "";
	}
	
	/**
	 * ファシリティIDリスト取得
	 * 
	 * ファシリティIDの配列として返す
	 * 
	 * @param hostName
	 * @param ipAddress
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getFacilityIdList(String hostName, String ipAddress) throws FinderException, NamingException {
		ArrayList list = null;
		try {
			HashMap map = new HashMap();
			list = new ArrayList();
			
			//IPアドレスが一致するFacilityを取得
			if(ipAddress != null && ipAddress.length() > 0){
				Collection ct = FacilityUtil.getLocalHome().findByIpAddress(ipAddress);
				Iterator itr = ct.iterator();
				while(itr.hasNext()){
					FacilityLocal facility = (FacilityLocal)itr.next();
					
					if(map.get(facility.getFacilityId()) == null){
						map.put(facility.getFacilityId(), "1");
						
						list.add(facility.getFacilityId());
					}
				}
			}
			
			//ノード名が一致するFacilityを取得
			if(hostName != null && hostName.length() > 0){
				Collection ct = FacilityUtil.getLocalHome().findByNodeName(hostName);
				Iterator itr = ct.iterator();
				while(itr.hasNext()){
					FacilityLocal facility = (FacilityLocal)itr.next();
					
					if(map.get(facility.getFacilityId()) == null){
						map.put(facility.getFacilityId(), "1");
						
						list.add(facility.getFacilityId());
					}
				}
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return list;
	}
	
	/**
	 * ノードチェック
	 * 
	 * ファシリティIDがノードかチェックし、結果をbooleanで返す
	 * 
	 * @param facilityId
	 * @return true:ノード/false:スコープ
	 * @throws FinderException
	 * @throws NamingException
	 */
	public boolean isNode(String facilityId) throws FinderException, NamingException {
		boolean node = false;
		try {
			//FacilityTreeの最上位エントリを取得
			FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
			
			if(facility.getType() == FacilityConstant.TYPE_NODE){
				node = true;
			}
			
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		return node;
	}
	

	/**
	 * ノード一覧取得
	 * 
	 * 指定した条件(Attribute,value)に該当するノード一覧を返却する
	 * 
	 * @param condition
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList findByCondition(HashMap condition) throws FinderException, NamingException {
		
		m_log.debug("findByCondition() : start");
		
		ArrayList list = null;
		try {
			//Facilityの最上位エントリを取得
			Collection ct = FacilityUtil.getLocalHome().findByCondition(condition);
			
			list = new ArrayList();
			Iterator itr = ct.iterator();
			while(itr.hasNext()){
				FacilityLocal ft = (FacilityLocal)itr.next();
				
				m_log.debug("findByCondition() : hit facility id = " + ft.getFacilityId());				
				list.add(ft.getFacilityId());
			}
		} catch (FinderException e) {
			m_log.error("findByCondition() : FinderException",e);
			throw e;
		} catch (NamingException e) {
			m_log.error("findByCondition() : NamingException",e);
			throw e;
		}

		m_log.debug("findByCondition() : end");

		return list;
	}
}
