/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmptrap.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapController;
import com.clustercontrol.snmptrap.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * SNMPTRAP監視情報を削除するクライアント側アクションクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class DeleteSnmpTrap {

    /**
     * SNMPTRAP監視情報を削除します。<BR>
     * 
     * @param monitorId 監視項目ID
     * @return 削除に成功した場合、true
     */
    public boolean delete(String monitorId) {
    	
    	MonitorSnmpTrapController snmpTrap = 
    		EjbConnectionManager.getConnectionManager().getSnmpTrapController();

        boolean result = false;
        try {
        	result = snmpTrap.deleteMonitor(monitorId);
        	return result;
        
        } catch (FinderException e) {
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (NotSupportedException e) {
		} catch (RollbackException e) {
		} catch (HeuristicMixedException e) {
		} catch (HeuristicRollbackException e) {
		} catch (SystemException e) {
		} catch (NamingException e) {
		} catch (RemoveException e) {
		}
        return false;
    }
}