/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.syslogng.bean;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.ProcessConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.notify.bean.NotifyRelationInfo;

/**
 * フィルタ情報を保持するBean(DTO)クラス<BR>
 *
 * @version 3.0.0
 * @since 1.0.0
 */
public class LogFilterInfo extends MonitorInfo { //implements Serializable {

	private static final long serialVersionUID = -544655198328111919L;

	/** フィルタID。 */
    private String m_logId = null;

    /** 順番。 */
    private int m_orderNo = Integer.MAX_VALUE;

//  MonitorInfoを継承するクラスに変更したため、被るものは全てコメントアウトする　uchiyama
//    /** 説明。 */
//    private String m_description = null;
//
//    /** スコープ。 */
//    private String m_scope = null;
//
//    /** ファシリティID。 */
//    private String m_facilityId = null;

    /** パターンマッチ表現。 */
    private String m_pattern = null;

    /**
     * 処理タイプ。
     * @see com.clustercontrol.bean.ProcessConstant
     */
    private int m_processType = ProcessConstant.TYPE_YES;

    /**
     * 重要度。
     * @see com.clustercontrol.bean.PriorityConstant
     */
    private int m_priority = PriorityConstant.TYPE_CRITICAL;

    /** 監視項目ID。 */
    private String m_monitorId = null;

    /** アプリケーション。 */
    private String m_application = null;

    /** メッセージID。 */
    private String m_messageId = null;

    /** メッセージ。 */
    private String m_message = null;
    
//    /** カレンダID。 */
//    private String m_calendarId = null;
//    
//    /** 通知ID。 */
//    private String m_notifyGroupId = null;
//
//    /** 有効フラグ。 */
//    private boolean m_validFlg = true;
//    
//    /** 作成日時。 */
//    private Date m_regDate = null;
//    
//    /** 最終変更日時。 */
//    private Date m_updateDate = null;
//    
//    
//    /** 新規作成ユーザ。 */
//	protected String m_regUser;
//	
//	/** 最終変更ユーザ。 */
//	protected String m_updateUser;
//	
//	/**通知設定コレクション*/
//	Collection<NotifyRelationInfo> m_notifyId = null;

    /**
     * コンストラクタ。 
     */
    public LogFilterInfo() {
        super();
    }

//    /**
//     * コンストラクタ。
//     * 
//     * @param orderNo 順序
//     * @param description 説明
//     * @param facilityId ファシリティID
//     * @param pattern パターンマッチ表現
//     * @param processType 処理タイプ
//     * @param priority 重要度
//     * @param monitorId 監視項目ID
//     * @param application アプリケーション
//     * @param messageId メッセージID
//     * @param message メッセージ
//     * @param notifyGroupId 通知ID
//     * @param jobRun ジョブ実行
//     * @param jobId ジョブ実行のジョブID
//     * @param jobInhibitionFlg ジョブ実行の通知抑制と連動
//     * @param jobFailurePriority ジョブ実行の呼出失敗時の重要度
//     * @param validFlg 有効フラグ（有効の場合、<code> true </code>）
//     * @param notify 通知コレクション
//     * @param regDate 作成日時
//     * @param updateDate 最終変更日時
//     * @param regUser 新規作成ユーザ
//     * @param updateUser 最終変更ユーザ
//     * 
//     * @see com.clustercontrol.bean.ProcessConstant
//     * @see com.clustercontrol.bean.PriorityConstant
//     * @see com.clustercontrol.bean.YesNoConstant
//     * 
//     */
//    public LogFilterInfo(
//    		int orderNo, 
//    		String description, 
//    		String facilityId,
//            String pattern, 
//            int processType, 
//            int priority, 
//            String monitorId,
//            String application, 
//            String messageId, 
//            String message,
//            String notifyGroupId, 
//            boolean validFlg, 
//            Collection notifyId,
//            Date regDate, 
//            Date updateDate,
//            String regUser,
//            String updateUser) {
//    	
//        super();
//        m_orderNo = orderNo;
//        m_description = description;
//        m_facilityId = facilityId;
//        m_pattern = pattern;
//        m_processType = processType;
//        m_priority = priority;
//        m_monitorId = monitorId;
//        m_application = application;
//        m_messageId = messageId;
//        m_message = message;
//        m_notifyGroupId = notifyGroupId;
//        m_validFlg = validFlg;
//        m_notifyId = notifyId;
//        m_regDate = regDate;
//        m_updateDate = updateDate;
//        m_regUser = regUser;
//        m_updateUser = updateUser;
//    }
//
//    /**
//	 * アプリケーションを取得します。<BR>
//	 * 
//	 * @return アプリケーション
//	 */
//    public String getApplication() {
//        return m_application;
//    }
//
//    /**
//	 * アプリケーションを設定します。<BR>
//	 * 
//	 * @param application アプリケーション
//	 */
//    public void setApplication(String application) {
//        m_application = application;
//    }
//
//    /**
//	 * 説明を取得します。<BR>
//	 * 
//	 * @return 説明
//	 */
//    public String getDescription() {
//        return m_description;
//    }
//
//    /**
//	 * 説明を設定します。<BR>
//	 * 
//	 * @param description 説明
//	 */
//    public void setDescription(String description) {
//        m_description = description;
//    }
//
//    /**
//	 * ファシリティIDを取得します。<BR>
//	 * 
//	 * @return ファシリティID
//	 */
//    public String getFacilityId() {
//        return m_facilityId;
//    }
//
//    /**
//	 * ファシリティIDを設定します。<BR>
//	 * 
//	 * @param facilityId ファシリティID
//	 */
//    public void setFacilityId(String facilityId) {
//        m_facilityId = facilityId;
//    }

    /**
	 * メッセージを取得します。<BR>
	 * 
	 * @return メッセージ
	 */
    public String getMessage() {
        return m_message;
    }

    /**
	 * メッセージを設定します。<BR>
	 * 
	 * @param message メッセージ
	 */
    public void setMessage(String message) {
        m_message = message;
    }

    /**
	 * メッセージIDを取得します。<BR>
	 * 
	 * @return メッセージID
	 */
    public String getMessageId() {
        return m_messageId;
    }

    /**
	 * メッセージIDを設定します。<BR>
	 * 
	 * @param messageId メッセージID
	 */
    public void setMessageId(String messageId) {
        m_messageId = messageId;
    }

    /**
	 * 監視項目IDを取得します。<BR>
	 * 
	 * @return 監視項目ID
	 */
    public String getMonitorId() {
        return m_monitorId;
    }

    /**
	 * 監視項目IDを設定します。<BR>
	 * 
	 * @param monitorId 監視項目ID
	 */
    public void setMonitorId(String monitorId) {
        m_monitorId = monitorId;
    }

    /**
	 * 順序を取得します。<BR>
	 * 
	 * @return 順序
	 */
    public int getOrderNo() {
        return m_orderNo;
    }

    /**
	 * 順序を設定します。<BR>
	 * 
	 * @param orderNo 順序
	 */
    public void setOrderNo(int orderNo) {
        m_orderNo = orderNo;
    }

    /**
	 * パターンマッチ表現を取得します。<BR>
	 * 
	 * @return パターンマッチ表現
	 */
    public String getPattern() {
        return m_pattern;
    }

    /**
	 * パターンマッチ表現を設定します。<BR>
	 * 
	 * @param pattern パターンマッチ表現
	 */
    public void setPattern(String pattern) {
        m_pattern = pattern;
    }

    /**
	 * 重要度を取得します。<BR>
	 * 
	 * @return 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
    public int getPriority() {
        return m_priority;
    }

    /**
	 * 重要度を設定します。<BR>
	 * 
	 * @param priority 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
    public void setPriority(int priority) {
        m_priority = priority;
    }

    /**
	 * 処理タイプを取得します。<BR>
	 * 
	 * @return 処理タイプ
	 * 
	 * @see com.clustercontrol.bean.ProcessConstant
	 */
    public int getProcessType() {
        return m_processType;
    }

    /**
	 * 処理タイプを設定します。<BR>
	 * 
	 * @param processType 処理タイプ
	 * 
	 * @see com.clustercontrol.bean.ProcessConstant
	 */
    public void setProcessType(int processType) {
        m_processType = processType;
    }

//    /**
//	 * 有効フラグを取得します。<BR>
//	 * 
//	 * @return 有効フラグ（有効の場合、<code> true </code>）
//	 */
//    public boolean isValidFlg() {
//        return m_validFlg;
//    }
//
//    /**
//	 * 有効フラグを設定します。<BR>
//	 * 
//	 * @param validFlg 有効フラグ（有効の場合、<code> true </code>）
//	 */
//    public void setValidFlg(boolean validFlg) {
//        m_validFlg = validFlg;
//    }

    /**
	 * フィルタIDを取得します。<BR>
	 * 
	 * @return フィルタID
	 */
    public String getLogId() {
        return this.m_logId;
    }

    /**
	 * フィルタIDを設定します。<BR>
	 * 
	 * @param logId フィルタID
	 */
    public void setLogId(String logId) {
        this.m_logId = logId;
    }

//    /**
//	 * スコープを取得します。<BR>
//	 * 
//	 * @return スコープ
//	 */
//    public String getScope() {
//        return m_scope;
//    }
//
//    /**
//	 * スコープを設定します。<BR>
//	 * 
//	 * @param scope スコープ
//	 */
//    public void setScope(String scope) {
//        this.m_scope = scope;
//    }
//
//    /**
//	 * 通知IDを取得します。<BR>
//	 * 
//	 * @return 通知ID
//	 * @since 2.0.0
//	 */
//	public String getNotifyGroupId() {
//		return m_notifyGroupId;
//	}
//
//	/**
//	 * 通知IDを設定します。<BR>
//	 * 
//	 * @param id 通知ID
//	 * @since 2.0.0
//	 */
//	public void setNotifyGroupId(String id) {
//		m_notifyGroupId = id;
//	}
//
//	/**
//	 * 作成日時を取得します。<BR>
//	 * 
//	 * @return regDate 作成日時
//	 * @since 2.0.0
//	 */
//	public Date getRegDate() {
//		return m_regDate;
//	}
//
//	/**
//	 * 作成日時を設定します。<BR>
//	 * 
//	 * @param date 作成日時
//	 * @since 2.0.0
//	 */
//	public void setRegDate(Date date) {
//		m_regDate = date;
//	}
//
//	/**
//	 * 最終変更日時を取得します。<BR>
//	 * 
//	 * @return 最終変更日時
//	 * @since 2.0.0
//	 */
//	public Date getUpdateDate() {
//		return m_updateDate;
//	}
//
//	/**
//	 * 最終変更日時を設定します。<BR>
//	 * 
//	 * @param date 最終変更日時
//	 * @since 2.0.0
//	 */
//	public void setUpdateDate(Date date) {
//		m_updateDate = date;
//	}
//
//	/**
//	 * カレンダIDを取得します。<BR>
//	 * 
//	 * @return カレンダID
//	 * @since 2.1.0
//	 */
//	public String getCalendarId() {
//		return m_calendarId;
//	}
//
//	/**
//	 * カレンダIDを設定します。<BR>
//	 * 
//	 * @param calendarId カレンダID
//	 * @since 2.1.0
//	 */
//	public void setCalendarId(String calendarId) {
//		this.m_calendarId = calendarId;
//	}
//	
//	
//	/**
//	 * 新規作成ユーザを取得します。<BR>
//	 * 
//	 * @return 新規作成ユーザ
//	 * @since 2.1.0
//	 */
//	public String getRegUser() {
//		return m_regUser;
//	}
//	
//	/**
//	 * 新規作成ユーザを設定します。<BR>
//	 * 
//	 * @param user 新規作成ユーザ
//	 * @since 2.1.0
//	 */
//	public void setRegUser(String user) {
//		m_regUser = user;
//	}
//	
//	/**
//	 * 最終変更ユーザを取得します。<BR>
//	 * 
//	 * @return 最終変更ユーザ
//	 * @since 2.1.0
//	 */
//	public String getUpdateUser() {
//		return m_updateUser;
//	}
//	
//	/**
//	 * 最終変更ユーザを設定します。<BR>
//	 * 
//	 * @param user 最終変更ユーザ
//	 * @since 2.1.0 
//	 */
//	public void setUpdateUser(String user) {
//		m_updateUser = user;
//	}
//
//	public Collection<NotifyRelationInfo> getNotifyId() {
//		return m_notifyId;
//	}
//
//	public void setNotifyId(Collection<NotifyRelationInfo> notifyId) {
//		this.m_notifyId = notifyId;
//	}
}