/*
 
Copyright (C) 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.vm;

import com.clustercontrol.repository.ejb.entity.FacilityData;


/**
 * 仮想化[スコープ]ビューのマネージャ側インタフェース
 * VmwareプロジェクトやXenプロジェクトなどに、
 * このインタフェースを利用したクラスが実装される。
 * 
 * @version 3.1.0
 * @since 3.1.0
 */
public interface NodeOperationActionInterface {
	

	/**
	 * インスタンス生成後に呼ぶ必要あり。
	 * @param target
	 * @param host
	 */
	public void init(FacilityData target, FacilityData host) throws VmException;
	
	/**
	 * targetのゲストノードを停止（パワーオフ）させる
	 * @return 戻り値
	 * @throws Exception
	 */
	public Short guestPowerOff() throws VmException;

	/**
	 * targetのゲストノードをhostのホストノード上で起動（パワーオン）させる
	 * @return 戻り値
	 * @throws Exception
	 */
	public Short guestPowerOn() throws VmException;

}
