/*
 
Copyright (C) 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.vm;

import java.util.ArrayList;

import com.clustercontrol.repository.ejb.entity.FacilityData;

/**
 * VMのリポジトリ操作のインタフェースクラス<BR>
 * 
 * @version 3.1.0
 * @since 3.1.0
 *
 */
public interface RepositoryActionInterface {

	/**
	 * 
	 * @param hostId FacilityDataのVMManagementNodeに設定する値
	 * @param vmManagementIp ホストノードのIPアドレス
	 * @param user 接続ユーザ
	 * @param password 接続ユーザパスワード
	 * @param protocol 接続プロトコル
	 * @return ノードプロパティ
	 * @throws VmException
	 */
	public ArrayList<FacilityData> getCurrentAllocationList(
			String hostId,
			String vmManagementIp,
			String user,
			String password,
			String protocol) throws VmException;
}
