/*
 
Copyright (C) 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.vm.bean;

import java.util.HashMap;

import com.clustercontrol.util.Messages;

/**
 * 仮想化環境のノード操作に対する定義
 * @version 3.1.0
 * @since 3.1.0
 */
public class NodeOperationCommandConstant {

	////////////////////////////////////
	// ゲストノード操作用定義
	////////////////////////////////////
	
	//電源ON
	public static String G_POWERON = "G_POWERON";
	
	//電源OFF
	public static String G_POWEROFF = "G_POWEROFF";
	
	////////////////////////////////////
	// ホストノード操作用定義
	////////////////////////////////////


	////////////////////////////////////
	// 操作の分類定義マップ
	////////////////////////////////////
    public static final HashMap<String, Short> COMMANDIDS = new HashMap<String, Short>();
    
    static {
    	
    	//Guestノード用操作
    	COMMANDIDS.put(G_POWEROFF, NodeOperationTypeId.HOST);
    	COMMANDIDS.put(G_POWERON, NodeOperationTypeId.HOST);

    	//Hostノード用操作
    }

    /**
     * commandIDを名前に変える。
     * 仮想化[操作ログ]で利用される。
     * @param commandId
     * @return
     */
    public static String getName(String commandId) {
    	if (commandId == null) {
    		return "";
    	}
    	if (commandId.equals(G_POWERON)) {
    		return Messages.getString("message.vm.operation.1");
    	} else if (commandId.equals(G_POWEROFF)) {
    		return Messages.getString("message.vm.operation.2");
    	} else {
    		return commandId.toString();
    	}
    	
    }
}
