/*
 
Copyright (C) 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.vm.ejb.session;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.ViewListInfo;
import com.clustercontrol.commons.ejb.UsedFacilityException;
import com.clustercontrol.repository.bean.VmNodeInfo;
import com.clustercontrol.repository.ejb.entity.FacilityData;
import com.clustercontrol.vm.VmException;
import com.clustercontrol.vm.factory.SearchVmNode;
import com.clustercontrol.vm.ejb.entity.VmOperationDetailData;
import com.clustercontrol.vm.ejb.entity.VmOperationDetailLocal;
import com.clustercontrol.vm.ejb.entity.VmOperationDetailUtil;
import com.clustercontrol.vm.ejb.entity.VmMethodMstLocal;
import com.clustercontrol.vm.ejb.entity.VmMethodMstUtil;
import com.clustercontrol.vm.ejb.entity.VmProtocolMstLocal;
import com.clustercontrol.vm.ejb.entity.VmProtocolMstUtil;
import com.clustercontrol.vm.ejb.entity.VmSolutionMstLocal;
import com.clustercontrol.vm.ejb.entity.VmSolutionMstUtil;
import com.clustercontrol.vm.factory.OperationRun;
import com.clustercontrol.vm.factory.SelectVm;
import com.clustercontrol.vm.factory.UpdateVmNodeAllocation;
import com.clustercontrol.vm.factory.VmNodeController;
/**
 * 仮想化環境管理を制御するSession Beanクラス<BR>
 * 
 * @ejb.bean name="VmController"
 *           jndi-name="VmController"
 *           type="Stateless"
 *           transaction-type="Container"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=NotifyController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorInfo"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 *     
 */
public abstract class VmControllerBean implements SessionBean {

	//残作業//
	//アクセス管理
	
	protected static Log m_log = LogFactory.getLog(VmControllerBean.class);
	
	@SuppressWarnings("unused")
	private SessionContext m_context;
	
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}

	
    /**
     * 仮想化環境[履歴]ビューに表示する履歴のリストを取得します。
     * 
     * @ejb.interface-method
     * 
	 * @ejb.permission
     *     role-name="VmManagementRead"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
     * 
     * @param locale ロケール情報
     * @param histories 表示履歴数
     * 
     * @return ArrayList
     * 
     * @see com.clustercontrol.bean.ViewListInfo
     * @see com.clustercontrol.collectiverun.factory.SelectSession#getHistoryList(Locale, int)
     * 
     * @throws FinderException
     * @throws NamingException
     */
    public ViewListInfo getHistoryList(int histories) throws FinderException, NamingException {

    	//残作業//
    	m_log.debug("getHistoryList() : start history = " + histories);
    	
    	ViewListInfo list = null;
    	
    	SelectVm select = new SelectVm();
    	list = select.getHistoryList(histories);
    	
    	m_log.debug("getHistoryList() : end list.getTotal() = " + list.getTotal());
    	
    	return list; 
    }
    
    /**
     * VM操作の実行を行います。<BR>
     * 開始状態を、実行履歴詳細情報に設定します。
     * @throws CreateException 
     * @throws FinderException 
     * @throws NamingException 
     * @throws JMSException 
     * 
     * @ejb.interface-method
     * 
	 * @ejb.permission
     *     role-name="VmManagementExecute"
     *     method-intf="Remote"
     * 
     * 
     * @throws Exception
     */
    public void run(String commandId, String facilityId, Locale locale) 
    		throws CreateException, FinderException, NamingException, JMSException  {

    	//課題//
    	//同クラスのメソッドをLocalインタフェースで呼び出すかthisで呼び出すか？

    	m_log.debug("run() : start commandId = " + commandId + ", facilityId = " + facilityId + ", locale = " + locale.getDisplayName());
    	
	    //操作履歴データ(セッション)の作成
	    String sessionId;
	    try {
			sessionId = this.createSession(commandId, facilityId, locale);
		} catch (CreateException e) {
	    	m_log.warn("run() CreateException : " + e.getMessage() , e);
	    	throw e;
		} catch (FinderException e) {
	    	m_log.warn("run() FinderException : " + e.getMessage() , e);
	    	throw e;
		} catch (NamingException e) {
	    	m_log.warn("run() NamingException : " + e.getMessage() , e);
	    	throw e;
		}
	    m_log.debug("run : sessionId =" + sessionId);
        
        //セッションの実行
       	try {
			this.run(sessionId);
		} catch (JMSException e) {
	    	m_log.warn("run() JMSException : " + e.getMessage() , e);
	    	throw e;
		}

	    
    	m_log.debug("run() : end commandId = " + commandId + ", facilityId = " + facilityId + ", locale = " + locale.getDisplayName());
    }

    /**
     * 操作履歴データ(セッション)の作成の実処理を行います。
     * @param commandId
     * @param property
     * @param locale
     * @return
     * @throws CreateException
     * @throws FinderException
     * @throws NamingException
     */
    private String createSession(String commandId, String  facilityId, Locale locale) throws CreateException, FinderException, NamingException {
    	
    	//残作業//
    	//なし

    	//仮想化操作実行履歴データ作成
        OperationRun operation = new OperationRun();
        return operation.createSession(commandId, facilityId, locale);
    }

    /**
     * 操作のセッション実行の実処理を行います。
     * @param sessionId
     * @throws CreateException
     * @throws FinderException
     * @throws NamingException
     * @throws IOException
     */
    private void run(String sessionId) throws FinderException, NamingException, JMSException {

    	//残作業//
    	//なし

    	//仮想化操作実行
        OperationRun operation = new OperationRun();
        operation.run(sessionId);
    }

    /**
     * VM操作の終了処理を行います。<BR>
     * 終了状態を、実行履歴・実行履歴詳細情報に設定します。
     * 
     * @ejb.interface-method
     * 
	 * @ejb.permission
     *     role-name="VmManagementExecute"
     *     method-intf="Remote"
     * 
     * @param info 実行結果情報
     * 
     * @see com.clustercontrol.vm.factory.OperationRun#endNode(RunResultInfo)
     * @see com.clustercontrol.vm.message.RunResultInfo
     * 
     * @throws FinderException
     * @throws NamingException
     */
    public void endNode(VmOperationDetailData data) throws FinderException, NamingException {
    	//セッションの実行の終了処理を行います。
        OperationRun operation = new OperationRun();
        operation.endNode(data);
    }
    
	/**
	 * 仮想ノードの割当情報を取得します。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="VmManagementRead"
     *     method-intf="Remote"
     *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 3.1.0
	 * @since 3.1.0
	 * 
	 */
	public ArrayList<VmNodeInfo> getVmNodeInfoList(Property property, Locale locale) 
		throws FinderException,NamingException,CreateException, VmException{

		m_log.debug("getVmNodeInfoList() : start");
		SearchVmNode node = new SearchVmNode();
		return node.searchNode(property, locale);
	}
	
	/**
	 * 仮想ノードの割当情報を更新します。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="VmManagementRead"
     *     method-intf="Remote"
     *     
     * @ejb.transaction
	 *     type="NotSupported"
	 *     
	 * @version 3.1.0
	 * @since 3.1.0
	 * 
	 * @throws FinderException
	 * @throws NamingException
	 * @throws CreateException
	 * @throws VmException 
	 */
	public void updateVmNodeAllocation(Locale locale) 
		throws FinderException,NamingException,CreateException, VmException{
		m_log.debug("updateVmNodeAllocation() : start");
		
		UpdateVmNodeAllocation allocation = new UpdateVmNodeAllocation();
		allocation.update(locale);
		
		m_log.debug("updateVmNodeAllocation() : end");
	}
	
	/**
     * 指定のホストノードに対してゲストノード一覧のゲストノードを割り当てる。<BR>
     * 入力はホストノードのファシリティIDとゲストノードのファシリティIDのリスト。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="VmManagementRead"
     *     method-intf="Remote"
	 * 
     * @ejb.transaction
	 *     type="NotSupported"
	 *     
	 * @version 3.1.0
	 * @since 3.1.0
	 * 
	 */
	public void assignVmNode(HashMap<String, ArrayList<String>> newMap, HashMap<String, ArrayList<String>> releaseMap, Locale locale) 
		throws VmException{
		m_log.debug("assignVmNode() : start");

		UpdateVmNodeAllocation allocation = new UpdateVmNodeAllocation();
		
		// ホストノード用スコープの作成
		allocation.updateScope(newMap, releaseMap, locale);

		m_log.debug("assignVmNode() : end");
	}
	
}
