/*
 
Copyright (C) 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.vm.factory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.repository.bean.FacilityAttributeConstant;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.vm.bean.NodeOperationCommandConstant;
import com.clustercontrol.vm.bean.NodeOperationStatusConstant;
import com.clustercontrol.vm.bean.NodeOperationTypeId;
import com.clustercontrol.vm.bean.QueueConstant;
import com.clustercontrol.vm.ejb.entity.VmOperationDetailData;
import com.clustercontrol.vm.ejb.entity.VmOperationDetailLocal;
import com.clustercontrol.vm.ejb.entity.VmOperationDetailPK;
import com.clustercontrol.vm.ejb.entity.VmOperationDetailUtil;
import com.clustercontrol.vm.util.CreateSessionId;

/**
 * 仮想化操作の実処理ロジック
 * @version 3.1.0
 * @since 3.1.0
 *
 */
public class OperationRun {
	protected static Log m_log = LogFactory.getLog(OperationRun.class);

	
	/**
	 * セッション（cc_vm_instruction_session_detail情報）を作成する
	 * @param commandId
	 * @param property
	 * @param locale
	 * @return
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public String createSession(String commandId, String facilityId, Locale locale)
			throws CreateException, FinderException, NamingException {
		
    	//残作業//
    	//infoログをdebugに変更
    	
    	//課題//
    	//ホスト、ゲストの対象facilityId一覧を取得する際のメソッドを修正する

		m_log.debug("createSession() : start commandId = " + commandId + ", facilityId = " + facilityId);	

        //リポジトリセッションBean取得
        RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();

		//セッションIDを作成
		String sessionId = null;
        sessionId = CreateSessionId.getNewSessionId();

 		m_log.debug("createSession() : sessionId = " + sessionId);
 		
 		//処理対象のノードリストを取得
 		ArrayList<String> nodeIdList = null;
 		Short typeId = NodeOperationCommandConstant.COMMANDIDS.get(commandId);//コマンドタイプ(ホスト用、ゲスト用)
 		if(typeId == null) {
 			m_log.error("typeId is null. commandId=" + commandId);
 		}
 		if(typeId.equals(NodeOperationTypeId.GUEST)){
 			//対象がゲストノード用コマンドの場合、facilityId配下のゲストノード一覧を取得
 			nodeIdList = repository.getExecTargetFacilityIdList(facilityId);	
 	 		m_log.debug("createSession() : This command is guest command");
 		}
 		else{
 			//対象がホストノード用コマンドの場合、facilityId配下のゲストノード一覧を取得
 			nodeIdList = repository.getExecTargetFacilityIdList(facilityId);	
 	 		m_log.debug("createSession() : This command is host command");
 		}
 		
 		//セッションを作成
        if(nodeIdList instanceof ArrayList){
            for(int i = 0; i < nodeIdList.size(); i++){

            	//必要なプロパティ情報を取得する
                ArrayList<String> Attribute = new ArrayList<String>();
                Attribute.add(FacilityAttributeConstant.CN);//facilityName
                Attribute.add(FacilityAttributeConstant.VIRTNODETYPE);//nodeType(HostかGuestか)
                HashMap<String, String> map = repository.getNodeDetail((String)nodeIdList.get(i), Attribute);
                
            	//セッションディテール(実行履歴詳細)を作成
                VmOperationDetailUtil.getLocalHome().create(
                        sessionId, //sessionId
                        (String)nodeIdList.get(i),//facilityId 
                        (String)map.get(FacilityAttributeConstant.CN), //facilityName
                        (String)map.get(FacilityAttributeConstant.VIRTNODETYPE),//nodeType(HostかGuestか)
                        commandId,//commandId
                        NodeOperationStatusConstant.READY, //status(未開始)
                        null, //startDate(未開始の状態なのでnull)
                        null, //endStatus(未終了の状態なのでnull)
                        null, //endDate(未終了の状態なのでnull)
                        null, //endValue(未終了の状態なのでnull)
                        null //message(未終了の状態なのでnull)
                        );
            }
        }
 		
		m_log.debug("createSession() : end commandId = " + commandId + ", facilityId = " + facilityId);	

		return sessionId;
	}


	/**
	 * 処理実行
	 * @param sessionId
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 * @throws IOException
	 */
	public void run(String sessionId) throws FinderException,	NamingException, JMSException  {

    	//残作業//
    	//infoログをdebugに変更

		m_log.debug("run() : start sessionId=" + sessionId);
		
		//個々のノードで実行
		startNode(sessionId);
		
		m_log.debug("run() : end sessionId=" + sessionId);	

	}

	/**
	 * 処理を各ノードで実行する
	 * @param sessionId
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected void startNode(String sessionId) throws FinderException, NamingException, JMSException {
		
    	//残作業//
    	//infoログをdebugに変更

		m_log.debug("startNode() : start sessionId =" + sessionId);
		
		//履歴情報を取得
		Collection<VmOperationDetailLocal> collection = VmOperationDetailUtil.getLocalHome().findBySessionId(sessionId);
		
		//実行指示キュー送信メイン
        if(collection != null && collection.size() > 0){
            
            //Queue送信クラス生成
            SendQueue send = null;
            try {
                send = new SendQueue(QueueConstant.QUEUE_NAME_EXECUTE);//実行指示キュー
            } catch (NamingException e) {
                m_log.debug("startNode() : 実行指示キュー生成 : " + e.getMessage(),e);
                throw e;
            } catch (JMSException e) {
                m_log.debug("startNode() : 実行指示キュー生成 : " + e.getMessage(),e);
                throw e;
            }
            
            
            //個々のセッション(sessionId,faclityId)に対するキュー送信
            Iterator<VmOperationDetailLocal> itr = collection.iterator();
            while(itr.hasNext()){

            	VmOperationDetailLocal local = itr.next();
            	
                //キュー送信データ作成
                VmOperationDetailData data = 
                	new VmOperationDetailData(
                			local.getSessionId(),
                			local.getFacilityId(),
                			local.getScopeText(),
                			local.getNodeType(),
                			local.getCommandId(),
                			local.getStatus(),
                			local.getStartDate(),
                			local.getEndStatus(),
                			local.getEndDate(),
                			local.getEndValue(),
                			local.getMessage()
                	);
                
                //Queueに送信
                try {
                    send.put(data);
                } catch (JMSException e) {
                    m_log.debug("startNode() : 実行指示送信エラー : " + e.getMessage(),e);
                }
            }
            
            
            //キュー送信後処理
            try {
                send.terminate();
            } catch (JMSException e) {
                m_log.debug("startNode() : 実行指示キュー後処理エラー : " + e.getMessage(),e);
            }
        }		
        
		m_log.debug("startNode() : end sessionId =" + sessionId);
	}
	
	
	/**
	 * ノードの終了処理(履歴情報を最終更新)
	 * @param data
	 * @throws FinderException
	 * @throws NamingException
	 */
    public void endNode(VmOperationDetailData data) throws FinderException, NamingException {

		m_log.debug("endNode() : start sessionId = " + data.getSessionId() + ",status=" + data.getStatus());
		
		//セッションIDとファシリティからセッション(実行履歴)を取得
		VmOperationDetailLocal local 
			= VmOperationDetailUtil.getLocalHome().findByPrimaryKey(
					new VmOperationDetailPK(data.getSessionId(),data.getFacilityId()));
		
		//実行状態の種別により動作を変更
		if(local.getStatus() != null){
			if(data.getStatus().equals(NodeOperationStatusConstant.RUNNING) && 
					local.getStatus().equals(NodeOperationStatusConstant.READY)){
				// 実行状態の更新
				local.setStatus(data.getStatus());
				// 開始状態の更新
				local.setStartDate(data.getStartDate());
			} else if(local.getStatus().equals(NodeOperationStatusConstant.RUNNING)){
				// 実行状態の更新
				local.setStatus(data.getStatus());
				// 終了状態の更新
				local.setEndStatus(data.getEndStatus());
				local.setEndDate(data.getEndDate());
				local.setEndValue(data.getEndValue());
				local.setMessage(data.getMessage());
			} else {
				//ここのロジックには入らないはず
				m_log.warn("endNode() : sessionId = " + data.getSessionId() + ", local status to " + local.getStatus());
				testPrintVmOperationDetail(local);
			}
			m_log.debug("endNode() : sessionId = " + data.getSessionId() +
					", status to " + data.getStatus() +
					", endStatus to " + data.getEndStatus());
		} else {
			m_log.info("endNode() : sessionId = " + data.getSessionId() + ", status is null");
		}
		
		
		m_log.debug("endNode() : end sessionId = " + data.getSessionId() + ",status=" + data.getStatus());
    }
    
    /**
     * 
     * @param local
     */
    private void testPrintVmOperationDetail(VmOperationDetailLocal local){
		m_log.info(".getSessionId :" + local.getSessionId());
		m_log.info(".getFacilityId :" + local.getFacilityId());
		m_log.info(".getScopeText :" + local.getScopeText());
		m_log.info(".getTypeId :" + local.getNodeType());
		m_log.info(".getCommandId :" + local.getCommandId());
		m_log.info(".getStatus :" + local.getStatus());
		m_log.info(".getStartDate :" + local.getStartDate());
		m_log.info(".getStartDate :" + local.getEndStatus());
		m_log.info(".getEndDate :" + local.getEndDate());
		m_log.info(".getEndValue :" + local.getEndValue());
		m_log.info(".getMessage :" + local.getMessage());
    }
}
