/*
 
Copyright (C) 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/
package com.clustercontrol.vm.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.repository.bean.FacilityAttributeConstant;
import com.clustercontrol.repository.bean.FacilityTreeAttributeConstant;
import com.clustercontrol.repository.bean.VmNodeInfo;
import com.clustercontrol.repository.ejb.entity.FacilityData;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.repository.factory.NodeProperty;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.vm.VmException;

/**
 * 仮想化のリポジトリ操作(割当ノード走査)用の処理クラス
 * 
 * @version 3.1.0
 * @since 3.1.0
 *
 */
public class SearchVmNode {

	protected static Log m_log = LogFactory.getLog(SearchVmNode.class);
	

	/**
	 * 
	 * 指定したホストノードに対して、属するノードの一覧を返却する。<BR>
	 * <BR>
	 * 返却する対象のゲストノードの分類は以下の4つは、<BR>
	 * 1.リポジトリに登録済みノードで管理ノードは設定値も最新の配置も当該ホストノードにあるもの。<BR>
	 * 2.リポジトリに登録済みノードで管理ノードは設定値は当該ホストノードだが、最新の配置が別ノードにあるもの。<BR>
	 * 3.リポジトリに登録済みノードで管理ノードは設定値は別ノードが、最新の配置が当該ホストノードにあるもの。<BR>
	 * 4.リポジトリに未登録のノード。<BR>
	 * 同一ノード、異なるノードとの判定はノード種別がguestであり、(仮想マシン名、仮想マシンID)の一致で行う。<BR>

	 * @param host
	 * @param locale
	 * @return
	 * @throws NamingException
	 * @throws FinderException
	 * @throws CreateException
	 */
	public ArrayList<VmNodeInfo> searchNode(Property host, Locale locale) 
		throws NamingException,FinderException,CreateException,VmException{

		m_log.debug("searchNode() : start");
		
		// 返却オブジェクト
		ArrayList<VmNodeInfo> ret = new ArrayList<VmNodeInfo>();

		/////////////////////////////////////////////////////////////////////////
		// 初期化
		/////////////////////////////////////////////////////////////////////////
		m_log.debug("searchNode() : init");

		//共通変数
		Iterator<String> strItr = null;
		Iterator<FacilityData> fdItr = null;
		ArrayList<String> attribute = new ArrayList<String>();
		ArrayList propertyList = null;
        HashMap<String, String> condition = new HashMap<String, String>();
        VmNodeInfo info = null;
        String targetFalicityId = null;

        String vmManagementIp = null;
		String user = null;
		String password = null;
		String protocol = null;
		String virtSolution = null;
        
		//共通変数（facilityIdリスト）
		ArrayList<String> hostNodeList = null;	//管理ノード=host
		ArrayList<String> settingNodeList = null; //管理ノード=ターゲットノード
		ArrayList<String> settingUnknownNodeList = null; //settingNodeListのうち現在不明

		//共通変数（FacilityDataリスト）
		ArrayList<FacilityData> currentList = null; //現在のターゲットノード上のノード
		ArrayList<FacilityData> unregistNodeList = null; //currentListのうち未登録
		
		//共通変数（外部API操作用）
		//SelectFacility select = new SelectFacility();
        VmNodeController vmNodeController = new VmNodeController();
        RepositoryControllerLocal repository = null;
		try {
	        repository = RepositoryControllerUtil.getLocalHome().create();
		} catch (CreateException e) {
			m_log.error("searchNode() : ",e);
			throw e;
		} catch (NamingException e) {
			m_log.error("searchNode() : ",e);
			throw e;
		}
		
		/////////////////////////////////////////////////////////////////////////
		// 初期取得情報
		/////////////////////////////////////////////////////////////////////////
		m_log.debug("searchNode() : init info");

		// ターゲットノードのホスト名取得
		propertyList = PropertyUtil.getProperty(host, NodeProperty.FACILITY_ID);
		targetFalicityId = ((Property)propertyList.get(0)).getValue().toString();
		m_log.debug("searchNode() : targetFalicityId = " + targetFalicityId);
		
		// テーゲットノードのファシリティデータを取得
		FacilityData hostData = repository.getNodeFacilityData(targetFalicityId);
		virtSolution = hostData.getVirtSolution();
		user = hostData.getVmUser();
		password = hostData.getVmUserpassword();
		protocol = hostData.getVmProtocol();
		if(hostData.getIpProtocolNumber() == null){
			vmManagementIp = hostData.getIpNetworkNumber();
		}else{
			if(hostData.getIpProtocolNumber().intValue() == 4){
				vmManagementIp = hostData.getIpNetworkNumber();				
			}else{
				vmManagementIp = hostData.getIpNetworkNumberV6();
			}
		}
		m_log.debug("searchNode() : virtSolution = " + virtSolution);
		m_log.debug("searchNode() : user = " + user);
		m_log.debug("searchNode() : password = " + password);
		m_log.debug("searchNode() : protocol = " + protocol);
		m_log.debug("searchNode() : vmManagementIp = " + vmManagementIp);
		
		// リポジトリアクセス
		try{
			
			// 「管理ノード」=ターゲットノードのゲストノード一覧(settingNodeList)を取得
			condition.clear();
			condition.put(FacilityAttributeConstant.VIRTNODETYPE, "guest"); //Guestノードであること
			condition.put(FacilityAttributeConstant.VMMANAGEMENTNODE, targetFalicityId); //管理ノードがターゲットノード
			settingNodeList = repository.findByCondition(condition);

			//for debug
			strItr = settingNodeList.iterator();
			while (strItr.hasNext()) {
				String string = (String) strItr.next();
				m_log.debug("searchNode() : settingNodeList -> " + string);
			}
			
			// ホストノード一覧(hostNodeList)を取得（プラットフォームは意識しない）
			condition.clear();
			condition.put(FacilityAttributeConstant.VIRTNODETYPE, "host");
			condition.put(FacilityAttributeConstant.VALID, "TRUE");
			hostNodeList = repository.findByCondition(condition);
			
			//for debug
			strItr = hostNodeList.iterator();
			while (strItr.hasNext()) {
				String string = (String) strItr.next();
				m_log.debug("searchNode() : hostNodeList -> " + string);
			}
			
		}catch (NamingException e) {
			m_log.error("searchNode() : NamingException ",e);
			throw e;
		}catch (FinderException e) {
			m_log.error("searchNode() : FinderException ",e);
			throw e;
		}
		
		// ターゲットノードに現在割り当てられているノード情報を取得
		currentList = vmNodeController.getCurrentAllocationList(
				targetFalicityId,
				vmManagementIp,
				user,
				password,
				protocol,
				virtSolution,
				locale);
		
		/////////////////////////////////////////////////////////////////////////
		//1.リポジトリに登録済みノードで管理ノードは設定値も最新の配置も当該ホストノードにあるもの。
		/////////////////////////////////////////////////////////////////////////
		m_log.debug("searchNode() : stage 1 ");

		// 初期化
        attribute.clear();
        attribute.add(FacilityAttributeConstant.VMNAME);
        attribute.add(FacilityAttributeConstant.VMID);
        
		settingUnknownNodeList = new ArrayList<String>();

		//「管理ノード=ターゲットノード」に対して
		strItr = settingNodeList.iterator();
		while (strItr.hasNext()) {
			try {
				String facilityId = (String) strItr.next();
				m_log.debug("searchNode() : start facilityId = " + facilityId);

	            HashMap map = repository.getNodeDetail(facilityId, attribute);
			
	            // 現在の割当情報を参照して存在するかを確認する
	            boolean exists = false;

	            fdItr = currentList.iterator();
	            while (fdItr.hasNext()) {
					FacilityData facilityData = (FacilityData) fdItr.next();
					
					// 仮想マシン名と仮想マシンID(UUID)が一致した場合に、同じものと判断する
					if(map.get(FacilityAttributeConstant.VMNAME) != null &&
							map.get(FacilityAttributeConstant.VMNAME).equals(facilityData.getVmName()) &&
							map.get(FacilityAttributeConstant.VMID) != null &&
							map.get(FacilityAttributeConstant.VMID).equals(facilityData.getVmId()))
					{
						
						m_log.debug("searchNode() : facilityId = " + facilityId + " is in currentList. " +
								"vmName = " + facilityData.getVmName() + ", vmId = " + facilityData.getVmId());

						//分類1の結果(facilityId)をretにセットする
						info = new VmNodeInfo();
						info.setNewManageNode(targetFalicityId);
						info.setRegistration(VmNodeInfo.REGISTERED);
						info.setSelection(true);
						info.setProperty(repository.getNodeProperty(facilityId, PropertyConstant.MODE_SHOW, locale));
						ret.add(info);
						
						exists = true;
						break;
					}
				}
	            
	            //一致するものが無かった場合は、次の処理用リストに追加
	            if(!exists){
					// Next Stage (2)!!
					m_log.debug("searchNode() : facilityId = " + facilityId + " is not in currentList.");
	            	settingUnknownNodeList.add(facilityId);
	            }
	            
			} catch (FinderException e) {
				m_log.error("searchNode() : ",e);
				throw e;
			} catch (NamingException e) {
				m_log.error("searchNode() : ",e);
				throw e;
			}
		}
		
		/////////////////////////////////////////////////////////////////////////
		//2.リポジトリに登録済みノードで管理ノードは設定値は当該ホストノードだが、最新の配置が別ノードにあるもの。
		/////////////////////////////////////////////////////////////////////////
		m_log.debug("searchNode() : stage 2 ");

		// settingNodeListのうち現在不明に対して
		strItr = settingUnknownNodeList.iterator();
		while (strItr.hasNext()) {
			try{
				String facilityId = (String) strItr.next();
				m_log.debug("searchNode() : start facilityId = " + facilityId);

				// 新しいホストノードID
				String newManageNode = null;
				// リポジトリ内のホスト上に存在するか？フラグ
				boolean exists = false;
				
				// 全てのホストノードから、何処にいるかを確認する
				Iterator<String> hostItr = hostNodeList.iterator();
				while (hostItr.hasNext()) {
					String hostId = (String) hostItr.next();
					m_log.debug("searchNode() : facilityId = " + facilityId + " search in " + hostId);

					// 現在配置されている
					if(vmNodeController.isAllocated(facilityId, hostId, locale)){
						m_log.debug("searchNode() : facilityId = " + facilityId + " is in  currentFacilityId = " + hostId);
						newManageNode = hostId;
						exists = true;
					// 現在配置されていない
					}else{
						m_log.debug("searchNode() : facilityId = " + facilityId + " is not in  currentFacilityId = " + hostId);
					}
				}
				
				// もし現在のリポジトリ内に存在しない場合はUNALLOCATEDに割り当てる
				if(!exists){
					newManageNode = FacilityTreeAttributeConstant.UNALLOCATED_SCOPE;
				}
				
				// 登録
				info = new VmNodeInfo();
				info.setNewManageNode(newManageNode);
				info.setRegistration(VmNodeInfo.REGISTERED);
				info.setSelection(true);
				info.setProperty(repository.getNodeProperty(facilityId, PropertyConstant.MODE_SHOW, locale));
				ret.add(info);
				
			} catch (FinderException e) {
				m_log.error("searchNode() : ",e);
				throw e;
			} catch (NamingException e) {
				m_log.error("searchNode() : ",e);
				throw e;
			} catch (CreateException e) {
				m_log.error("searchNode() : ",e);
				throw e;
			} catch (VmException e) {
				throw e;
			}

		}

		/////////////////////////////////////////////////////////////////////////
		//3.リポジトリに登録済みノードで管理ノードは設定値は別ノードが、最新の配置が当該ホストノードにあるもの。
		/////////////////////////////////////////////////////////////////////////
		m_log.debug("searchNode() : stage 3 ");

		// 初期化
        attribute.clear();
        attribute.add(FacilityAttributeConstant.VMNAME);
        attribute.add(FacilityAttributeConstant.VMID);
        
		unregistNodeList = new ArrayList<FacilityData>();
		
		// 現在のターゲットノード上のノードに対して
		fdItr = currentList.iterator();
		while (fdItr.hasNext()) {
			try {
				FacilityData facilityData = (FacilityData) fdItr.next();
				m_log.debug("searchNode() : start vmName = " + facilityData.getVmName() + "vmId = " + facilityData.getVmId());

				boolean exists = false;
				
				//settingNode(リポジトリ上の関係)にない場合のみを処理の対象とする
				strItr = settingNodeList.iterator();
				while (strItr.hasNext()) {
					String facilityId = (String) strItr.next();

			        //既に監視ノードがターゲットノードとして設定済みなものを探す
			        HashMap map = repository.getNodeDetail(facilityId, attribute);
			        if(map.get(FacilityAttributeConstant.VMNAME) != null &&
			        		map.get(FacilityAttributeConstant.VMNAME).equals(facilityData.getVmName()) &&
			        		map.get(FacilityAttributeConstant.VMID) != null &&
			        		map.get(FacilityAttributeConstant.VMID).equals(facilityData.getVmId()))
					{
						m_log.debug("searchNode() : vmName = " + facilityData.getVmName() + " is in settingNodeList. " +
								"facilityId = " + facilityId);

			        	exists = true;
			        	break;
					}
				}

				
				//監視ノードがターゲットノードとして設定済みでないものを対象とする
				if(!exists){
					m_log.debug("searchNode() : vmName = " + facilityData.getVmName() + " is not in settingNodeList. ");
					
					//仮想マシン名と仮想マシンID(UUID)が一致するものがリポジトリに存在するかを確認
					condition.clear();
					condition.put(FacilityAttributeConstant.VIRTNODETYPE, "guest"); //Guestノードであること
					condition.put(FacilityAttributeConstant.VMID, facilityData.getVmId());
					condition.put(FacilityAttributeConstant.VMNAME, facilityData.getVmName());
					ArrayList searchNodeList = repository.findByCondition(condition);
					
					//リポジトリを検索して登録ノードが存在したら、その情報を設定する。
					if(searchNodeList != null && searchNodeList.size() > 0){
						//1つ目のみをチェックする
						String facilityId = (String)searchNodeList.get(0);
							
						m_log.debug("searchNode() : vmName = " + facilityData.getVmName() + " is in repository. facilityId = " + facilityId);
						
						//分類3の結果(facilityData.getFacilityId())をretにセットする
						Property guest = repository.getNodeProperty(facilityId, PropertyConstant.MODE_SHOW, locale);
						
						info = new VmNodeInfo();
						info.setNewManageNode(targetFalicityId);
						info.setRegistration(VmNodeInfo.REGISTERED);
						info.setSelection(true);
						info.setProperty(guest);
						ret.add(info);
					}
					else{
						// Next Stage(4)!!
						m_log.debug("searchNode() : vmName = " + facilityData.getVmName() + " is not in repository");
						unregistNodeList.add(facilityData);
					}
				}
			} catch (FinderException e) {
				m_log.error("searchNode() : ",e);
				throw e;
			} catch (NamingException e) {
				m_log.error("searchNode() : ",e);
				throw e;
			}
		}
		
		/////////////////////////////////////////////////////////////////////////
		//4.リポジトリに未登録のノード。
		/////////////////////////////////////////////////////////////////////////
		m_log.debug("searchNode() : stage 4 ");

		// 現在のターゲットノード上のノードでリポジトリに無いものに対して
		fdItr = unregistNodeList.iterator();
		while (fdItr.hasNext()) {
			try{
				FacilityData facilityData = (FacilityData) fdItr.next();
				m_log.debug("searchNode() : start vmName = " + facilityData.getVmName() + "vmId = " + facilityData.getVmId());

				//分類4の結果(facilityData.getFacilityId())をretにセットする
				info = new VmNodeInfo();
				info.setNewManageNode(targetFalicityId);
				info.setRegistration(VmNodeInfo.UNREGISTERED);
				info.setSelection(false);
				info.setProperty(repository.getNodeProperty(facilityData, locale));
				ret.add(info);
				
			}catch (NamingException e) {
				m_log.error("searchNode() : ",e);
				throw e;
			}catch (CreateException e) {
				m_log.error("searchNode() : ",e);
				throw e;
			}catch (FinderException e) {
				m_log.error("searchNode() : ",e);
				throw e;
			}
		}
		
		
		/////////////////////////////////////////////////////////////////////////
		//終了
		/////////////////////////////////////////////////////////////////////////
		return ret;
	}
}
