/*
 
Copyright (C) 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.vm.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.bean.ViewListInfo;
import com.clustercontrol.vm.ejb.entity.VmOperationDetailData;
import com.clustercontrol.vm.ejb.entity.VmOperationDetailLocal;
import com.clustercontrol.vm.ejb.entity.VmOperationDetailUtil;

/**
 * 
 * @version 3.1.0
 * @since 3.1.0
 *
 */
public class SelectVm {

	/** 最大表示数 */
    private final static int MAX_DISPLAY_NUMBER = 500;

	public ViewListInfo getHistoryList(int histories) throws NamingException, FinderException{
		
		ViewListInfo list = new ViewListInfo();
		ArrayList<VmOperationDetailData> history = new ArrayList<VmOperationDetailData>();
		int total = 0;
		
		if(histories <= 0){
			histories = MAX_DISPLAY_NUMBER;
		}
		Integer limit = Integer.valueOf(histories + 1);
		
	    //セッション情報を最大MAX_DISPLAY_NUMBER件数の取得
	    Collection<VmOperationDetailLocal> sessionList =
	    	VmOperationDetailUtil.getLocalHome().findHistory(limit);
	    if(sessionList != null){
	    
			//履歴数をカウント
			total = sessionList.size();

			Iterator<VmOperationDetailLocal> itr = sessionList.iterator();
			while(itr.hasNext()){
				
				VmOperationDetailLocal local = (VmOperationDetailLocal)itr.next();
				
				VmOperationDetailData data = new VmOperationDetailData();
				data.setSessionId(local.getSessionId());
				data.setFacilityId(local.getFacilityId());
				data.setScopeText(local.getScopeText());
				data.setNodeType(local.getNodeType());
				data.setCommandId(local.getCommandId());
				data.setStatus(local.getStatus());
				data.setStartDate(local.getStartDate());
				data.setEndStatus(local.getEndStatus());
				data.setEndDate(local.getEndDate());
				data.setEndValue(local.getEndValue());
				data.setMessage(local.getMessage());
				
			    history.add(data);
			    
				//取得した履歴を最大表示件数まで格納したら終了
				if(history.size() >= histories)
					break;
			}
	    
	    }
	    
	    list.setTotal(total);
	    list.setList(history);
	    
	    return list;
	}
}
