package org.postgresforest.apibase;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.concurrent.Callable;

import org.postgresforest.exception.ForestTaskNotExecutedException;

public final class CallableStatementTask {
    
    public static final class GetBigDecimal implements Callable<BigDecimal> {
        private final CallableStatement cstmt;
        private final int arg0;
        private final int arg1;
        public GetBigDecimal(CallableStatement cstmt, int arg0, int arg1) {
            this.cstmt = cstmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        @SuppressWarnings("deprecation")
        public BigDecimal call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return cstmt.getBigDecimal(arg0, arg1);
        }
    }
    
    public static final class GetBoolean implements Callable<Boolean> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetBoolean(CallableStatement cstmt, int arg0) {
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public Boolean call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(cstmt.getBoolean(arg0));
        }
    }
    
    public static final class GetByte implements Callable<Byte> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetByte(CallableStatement cstmt, int arg0) {
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public Byte call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Byte.valueOf(cstmt.getByte(arg0));
        }
    }
    
    public static final class GetBytes implements Callable<byte[]> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetBytes(CallableStatement cstmt, int arg0) {
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public byte[] call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return cstmt.getBytes(arg0);
        }
    }
    
    public static final class GetDate implements Callable<Date> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetDate(CallableStatement cstmt, int arg0) {
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public Date call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return cstmt.getDate(arg0);
        }
    }
    
    public static final class GetDouble implements Callable<Double> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetDouble(CallableStatement cstmt, int arg0) {
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public Double call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Double.valueOf(cstmt.getDouble(arg0));
        }
    }
    
    public static final class GetFloat implements Callable<Float> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetFloat(CallableStatement cstmt, int arg0) {
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public Float call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Float.valueOf(cstmt.getFloat(arg0));
        }
    }
    
    public static final class GetInt implements Callable<Integer> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetInt(CallableStatement cstmt, int arg0) {
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public Integer call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(cstmt.getInt(arg0));
        }
    }
    
    public static final class GetLong implements Callable<Long> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetLong(CallableStatement cstmt, int arg0) {
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public Long call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Long.valueOf(cstmt.getLong(arg0));
        }
    }
    
    public static final class GetObject implements Callable<Object> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetObject(CallableStatement cstmt, int arg0) {
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public Object call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return cstmt.getObject(arg0);
        }
    }
    
    public static final class GetShort implements Callable<Short> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetShort(CallableStatement cstmt, int arg0) {
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public Short call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Short.valueOf(cstmt.getShort(arg0));
        }
    }
    
    public static final class GetString implements Callable<String> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetString(CallableStatement cstmt, int arg0) {
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public String call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return cstmt.getString(arg0);
        }
    }
    
    public static final class GetTime implements Callable<Time> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetTime(CallableStatement cstmt, int arg0) {
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public Time call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return cstmt.getTime(arg0);
        }
    }
    
    public static final class GetTimestamp implements Callable<Timestamp> {
        private final CallableStatement cstmt;
        private final int arg0;
        public GetTimestamp(CallableStatement cstmt, int arg0) {
            this.cstmt = cstmt;
            this.arg0 = arg0;
        }
        public Timestamp call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return cstmt.getTimestamp(arg0);
        }
    }
    
    public static final class WasNull implements Callable<Boolean> {
        private final CallableStatement cstmt;
        public WasNull(CallableStatement cstmt) {
            this.cstmt = cstmt;
        }
        public Boolean call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(cstmt.wasNull());
        }
    }
    
    public static final class RegisterOutParameter_IntInt implements Callable<Void> {
        private final CallableStatement cstmt;
        private final int arg0;
        private final int arg1;
        public RegisterOutParameter_IntInt(CallableStatement cstmt, int arg0, int arg1) {
            this.cstmt = cstmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            cstmt.registerOutParameter(arg0, arg1);
            return null;
        }
    }
    
    public static final class RegisterOutParameter_IntIntInt implements Callable<Void> {
        private final CallableStatement cstmt;
        private final int arg0;
        private final int arg1;
        private final int arg2;
        public RegisterOutParameter_IntIntInt(CallableStatement cstmt, int arg0, int arg1, int arg2) {
            this.cstmt = cstmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }
        public Void call() throws Exception {
            if (cstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            cstmt.registerOutParameter(arg0, arg1, arg2);
            return null;
        }
    }
    
}
