/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.stream;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;

public class StreamingClient {
    private static String transport = "socket";
    private static String host = "localhost";
    private static int port = 5400;
    private String locatorURI = transport + "://" + host + ":" + port;
    private String localFileName = "sample.txt";
    private String remoteFileName = "server_sample.txt";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendStream() throws Throwable {
        FileInputStream fileInput = null;
        Client remotingClient = null;
        try {
            InvokerLocator locator = new InvokerLocator(this.locatorURI);
            System.out.println("Calling on remoting server with locator uri of: " + this.locatorURI);
            remotingClient = new Client(locator);
            URL fileURL = this.getClass().getResource(this.localFileName);
            if (fileURL == null) {
                throw new Exception("Can not find file " + this.localFileName);
            }
            File testFile = new File(fileURL.getFile());
            fileInput = new FileInputStream(testFile);
            System.out.println("Sending input stream for file " + this.localFileName + " to server.");
            Object ret = remotingClient.invoke(fileInput, this.remoteFileName);
            long fileLength = testFile.length();
            System.out.println("Size of file sample.txt is " + fileLength);
            System.out.println("Server returned " + ret + " as the size of the file read.");
            Object var10_8 = null;
            if (remotingClient != null) {
                remotingClient.disconnect();
            }
            if (fileInput == null) return;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (remotingClient != null) {
                remotingClient.disconnect();
            }
            if (fileInput == null) throw throwable;
            try {
                fileInput.close();
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        try {
            fileInput.close();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setRemoteFileName(String remoteFileName) {
        this.remoteFileName = remoteFileName;
    }

    public static void main(String[] args) {
        String newFileName = null;
        if (args != null && args.length == 1) {
            newFileName = args[0];
        }
        if (args != null && args.length == 2) {
            transport = args[0];
            port = Integer.parseInt(args[1]);
        }
        if (args != null && args.length == 3) {
            transport = args[0];
            port = Integer.parseInt(args[1]);
            newFileName = args[2];
        }
        String locatorURI = transport + "://" + host + ":" + port;
        StreamingClient client = new StreamingClient();
        if (newFileName != null) {
            client.setRemoteFileName(newFileName);
        }
        try {
            client.sendStream();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

