/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.bean;

import java.util.ArrayList;
import java.util.List;

/**
 * HinemosのRole(権限)種類を定数として格納するクラス<BR>
 *
 * @version 2.1.0
 * @since 2.0.0
 */
public class RoleConstant {
	/** Roleリスト */
	protected static List<String> m_roles = new ArrayList<String>();
	/** Hinemosユーザ */
	public static final String HINEMOS_USER = "HinemosUser";
	/** リポジトリ - 参照権限 */
	public static final String REPOSITORY_READ = "RepositoryRead";
	/** リポジトリ - 設定権限 */
	public static final String REPOSITORY_WRITE = "RepositoryWrite";
	/** アクセス - 参照権限 */
	public static final String ACCESSCONTROL_READ = "AccessControlRead";
	/** アクセス - 設定権限 */
	public static final String ACCESSCONTROL_WRITE = "AccessControlWrite";
	/** ジョブ管理 - 参照権限 */
	public static final String JOBMANAGEMENT_READ = "JobManagementRead";
	/** ジョブ管理 - 設定権限 */
	public static final String JOBMANAGEMENT_WRITE = "JobManagementWrite";
	/** ジョブ管理 - 実行権限 */
	public static final String JOBMANAGEMENT_EXECUTE = "JobManagementExecute";
	/** 一括制御 - 参照権限 */
	public static final String COLLECTIVERUN_READ = "CollectiveRunRead";
	/** 一括制御 - 設定権限 */
	public static final String COLLECTIVERUN_WRITE = "CollectiveRunWrite";
	/** 一括制御 - 実行権限 */
	public static final String COLLECTIVERUN_EXECUTE = "CollectiveRunExecute";
	/** 性能管理 - 参照権限 */
	public static final String PERFORMANCE_READ = "PerformanceRead";
	/** 性能管理 - 設定権限 */
	public static final String PERFORMANCE_WRITE = "PerformanceWrite";
	/** 性能管理 - 実行権限 */
	public static final String PERFORMANCE_EXECUTE = "PerformanceExecute";
	/** 監視管理 - 参照権限 */
	public static final String MONITOR_READ = "MonitorRead";
	/** 監視管理 - 設定権限 */
	public static final String MONITOR_WRITE = "MonitorWrite";
	/** syslog-ng監視 - 参照権限 */
	public static final String SYSLOGNG_MONITOR_READ = "SyslogNgMonitorRead";
	/** syslog-ng監視 - 設定権限 */
	public static final String SYSLOGNG_MONITOR_WRITE = "SyslogNgMonitorWrite";
	/** Hinemosエージェント監視 - 参照権限 */
	public static final String AGENT_MONITOR_READ = "AgentMonitorRead";
	/** Hinemosエージェント監視 - 設定権限 */
	public static final String AGENT_MONITOR_WRITE = "AgentMonitorWrite";
	/** HTTP監視 - 参照権限 */
	public static final String HTTP_MONITOR_READ = "HttpMonitorRead";
	/** HTTP監視 - 設定権限 */
	public static final String HTTP_MONITOR_WRITE = "HttpMonitorWrite";
	/** プロセス監視 - 参照権限 */
	public static final String PROCESS_MONITOR_READ = "ProcessMonitorRead";
	/** プロセス監視 - 設定権限 */
	public static final String PROCESS_MONITOR_WRITE = "ProcessMonitorWrite";
	/** SQL監視 - 参照権限 */
	public static final String SQL_MONITOR_READ = "SqlMonitorRead";
	/** SQL監視 - 設定権限 */
	public static final String SQL_MONITOR_WRITE = "SqlMonitorWrite";
	/** SNMP監視 - 参照権限 */
	public static final String SNMP_MONITOR_READ = "SnmpMonitorRead";
	/** SNMP監視 - 設定権限 */
	public static final String SNMP_MONITOR_WRITE = "SnmpMonitorWrite";
	/** PING監視 - 参照権限 */
	public static final String PING_MONITOR_READ = "PingMonitorRead";
	/** PING監視 - 設定権限 */
	public static final String PING_MONITOR_WRITE = "PingMonitorWrite";
	/** サービス・ポート監視 - 参照権限 */
	public static final String PORT_MONITOR_READ = "PortMonitorRead";
	/** サービス・ポート監視 - 設定権限 */
	public static final String PORT_MONITOR_WRITE = "PortMonitorWrite";
	/** カレンダ - 参照権限 */
	public static final String CALENDAR_READ = "CalendarRead";
	/** カレンダ - 設定権限 */
	public static final String CALENDAR_WRITE = "CalendarWrite";
	/** 通知 - 参照権限 */
	public static final String NOTIFY_READ = "NotifyRead";
	/** 通知 - 設定権限 */
	public static final String NOTIFY_WRITE = "NotifyWrite";
	/** 重要度判定 - 参照権限 */
	public static final String PRIORITY_JUDGMENT_READ = "PriorityJudgmentRead";
	/** 重要度判定 - 設定権限 */
	public static final String PRIORITY_JUDGMENT_WRITE = "PriorityJudgmentWrite";
	/** ログ転送 - 参照権限 */
	public static final String LOG_TRANSFER_READ = "LogTransferRead";
	/** ログ転送 - 設定権限 */
	public static final String LOG_TRANSFER_WRITE = "LogTransferWrite";
	/** 障害検知 - 参照権限 */
	public static final String TROUBLE_DETECTION_READ = "TroubleDetectionRead";
	/** 障害検知 - 設定権限 */
	public static final String TROUBLE_DETECTION_WRITE = "TroubleDetectionWrite";
	/** SNMPTRAP監視 - 参照権限 */
	public static final String SNMPTRAP_MONITOR_READ = "SnmptrapMonitorRead";
	/** SNMPTRAP監視 - 設定権限 */
	public static final String SNMPTRAP_MONITOR_WRITE = "SnmptrapMonitorWrite";
	/** メンテナンス - 参照権限 */
	public static final String MAINTENANCE_READ = "MaintenanceRead";
	/** メンテナンス - 設定権限 */
	public static final String MAINTENANCE_WRITE = "MaintenanceWrite";
	
	static {
		m_roles.add(HINEMOS_USER);
		m_roles.add(REPOSITORY_READ);
		m_roles.add(REPOSITORY_WRITE);
		m_roles.add(ACCESSCONTROL_READ);
		m_roles.add(ACCESSCONTROL_WRITE);
		m_roles.add(JOBMANAGEMENT_READ);
		m_roles.add(JOBMANAGEMENT_WRITE);
		m_roles.add(JOBMANAGEMENT_EXECUTE);
		m_roles.add(COLLECTIVERUN_READ);
		m_roles.add(COLLECTIVERUN_WRITE);
		m_roles.add(COLLECTIVERUN_EXECUTE);
		m_roles.add(PERFORMANCE_READ);
		m_roles.add(PERFORMANCE_WRITE);
		m_roles.add(PERFORMANCE_EXECUTE);
		m_roles.add(MONITOR_READ);
		m_roles.add(MONITOR_WRITE);
		m_roles.add(SYSLOGNG_MONITOR_READ);
		m_roles.add(SYSLOGNG_MONITOR_WRITE);
		m_roles.add(AGENT_MONITOR_READ);
		m_roles.add(AGENT_MONITOR_WRITE);
		m_roles.add(HTTP_MONITOR_READ);
		m_roles.add(HTTP_MONITOR_WRITE);
		m_roles.add(PROCESS_MONITOR_READ);
		m_roles.add(PROCESS_MONITOR_WRITE);
		m_roles.add(SQL_MONITOR_READ);
		m_roles.add(SQL_MONITOR_WRITE);
		m_roles.add(SNMP_MONITOR_READ);
		m_roles.add(SNMP_MONITOR_WRITE);
		m_roles.add(PING_MONITOR_READ);
		m_roles.add(PING_MONITOR_WRITE);
		m_roles.add(PORT_MONITOR_READ);
		m_roles.add(PORT_MONITOR_WRITE);
		m_roles.add(CALENDAR_READ);
		m_roles.add(CALENDAR_WRITE);
		m_roles.add(NOTIFY_READ);
		m_roles.add(NOTIFY_WRITE);
		m_roles.add(PRIORITY_JUDGMENT_READ);
		m_roles.add(PRIORITY_JUDGMENT_WRITE);
		m_roles.add(LOG_TRANSFER_READ);
		m_roles.add(LOG_TRANSFER_WRITE);
		m_roles.add(SNMPTRAP_MONITOR_READ);
		m_roles.add(SNMPTRAP_MONITOR_WRITE);
		m_roles.add(MAINTENANCE_READ);
		m_roles.add(MAINTENANCE_WRITE);
		
		String serverName = System.getProperty("jboss.server.name");
		if(serverName.equals("all")){
			m_roles.add(TROUBLE_DETECTION_READ);
			m_roles.add(TROUBLE_DETECTION_WRITE);
		}
		
	}

	/**
	 * Roleリストを返します。
	 * 
	 * @return Roleリスト
	 */
	public static List<String> getRoles() {
		return m_roles;
	}
}
