/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.bean;


/**
 * 実行を示す定数を定義するクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class RunConstant {
    /** 実行する */
    public static final int TYPE_RUN = 1;

    /** 実行しない */
    public static final int TYPE_NOT_RUN = 0;

    /** 実行する */
    public static final boolean BOOLEAN_RUN = true;

    /** 実行しない */
    public static final boolean BOOLEAN_NOT_RUN = false;

    /**
     * 種別からbooleanに変換する
     * 
     * @param type
     * @return
     */
    public static boolean typeToBoolean(int type) {
        if (type == TYPE_RUN) {
            return BOOLEAN_RUN;
        } else if (type == TYPE_NOT_RUN) {
            return BOOLEAN_NOT_RUN;
        }
        return false;
    }

    /**
     * booleanから種別に変換する
     * 
     * @param bool
     * @return
     */
    public static int booleanToType(boolean bool) {
        if (bool == BOOLEAN_RUN) {
            return TYPE_RUN;
        } else if (bool == BOOLEAN_NOT_RUN) {
            return TYPE_NOT_RUN;
        }
        return -1;
    }
}