/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.monitor.run.bean;

/**
 * 数値監視の判定情報を保持するクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.0.0
 */
public class MonitorNumericValueInfo
	extends MonitorJudgementInfo
{
	private static final long serialVersionUID = -7307483294508379452L;
	
	/** 閾値下限。 */
	protected double m_thresholdLowerLimit;
	
	/** 閾値上限。 */
	protected double m_thresholdUpperLimit; 
	
	
	/**
	 * コンストラクタ。
	 */
	public MonitorNumericValueInfo() {
		super();
	}
	
	/**
	 * コンストラクタ。
	 * 
	 * @param message メッセージ
	 * @param messageId メッセージID
	 * @param monitorId 監視項目ID
	 * @param monitorTypeId 監視種別ID
	 * @param priority 重要度
	 * @param thresholdLowerLimit 閾値下限
	 * @param thresholdUpperLimit 閾値上限
	 * @param jobRun ジョブ実行
	 * @param jobId ジョブID
	 * @param jobInhibitionFlg ジョブの通知抑制と連動
	 * @param jobFailurePriority ジョブ呼出の失敗時の重要度
	 */
	public MonitorNumericValueInfo(
			String message,
			String messageId,
			String monitorId,
			String monitorTypeId,
			int priority,
			double thresholdLowerLimit,
			double thresholdUpperLimit,
			int jobRun,
			String jobId,
			int jobInhibitionFlg,
			int jobFailurePriority ) {
		
		setMessage(message);
		setMessageId(messageId);
		setMonitorId(monitorId);
		setMonitorTypeId(monitorTypeId);
		setPriority(priority);
		setThresholdLowerLimit(thresholdLowerLimit);
		setThresholdUpperLimit(thresholdUpperLimit);
		setJobRun(jobRun);
		setJobId(jobId);
		setJobInhibitionFlg(jobInhibitionFlg);
		setJobFailurePriority(jobFailurePriority);
	}
	
	/**
	 * コンストラクタ。
	 * 
	 * @param otherData コピー元の数値監視の判定情報
	 */
	public MonitorNumericValueInfo( MonitorNumericValueInfo otherData ) {
		
		setMessage(otherData.getMessage());
		setMessageId(otherData.getMessageId());
		setMonitorId(otherData.getMonitorId());
		setMonitorTypeId(otherData.getMonitorTypeId());
		setPriority(otherData.getPriority());
		setThresholdLowerLimit(otherData.getThresholdLowerLimit());
		setThresholdUpperLimit(otherData.getThresholdUpperLimit());
		setJobRun(otherData.getJobRun());
		setJobId(otherData.getJobId());
		setJobInhibitionFlg(otherData.getJobInhibitionFlg());
		setJobFailurePriority(otherData.getJobFailurePriority());
	}
	
	/**
	 * 閾値下限を返します。
	 * 
	 * @return 閾値下限
	 */
	public double getThresholdLowerLimit() {
		return this.m_thresholdLowerLimit;
	}
	
	/**
	 * 閾値下限を設定します。
	 * 
	 * @param thresholdLowerLimit 閾値下限
	 */
	public void setThresholdLowerLimit( double thresholdLowerLimit ) {
		this.m_thresholdLowerLimit = thresholdLowerLimit;
	}
	
	/**
	 * 閾値上限を返します。
	 * 
	 * @return 閾値上限
	 */
	public double getThresholdUpperLimit() {
		return this.m_thresholdUpperLimit;
	}
	
	/**
	 * 閾値上限を設定します。
	 * 
	 * @param thresholdUpperLimit 閾値上限
	 */
	public void setThresholdUpperLimit( double thresholdUpperLimit ) {
		this.m_thresholdUpperLimit = thresholdUpperLimit;
	}
}
