/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.monitor.run.bean;


/**
 * 真偽値監視の判定情報を保持するクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.0.0
 */
public class MonitorTruthValueInfo
extends MonitorJudgementInfo
{
	private static final long serialVersionUID = -8164764456414755011L;
	
	/**
	 * 真偽値。
	 * 
	 * @see com.clustercontrol.monitor.run.bean.TruthConstant
	 */
	protected int m_truthValue;
	
	
	/**
	 * コンストラクタ。
	 */
	public MonitorTruthValueInfo() {
		super();
	}
	
	/**
	 * コンストラクタ。
	 * 
	 * @param message メッセージ
	 * @param messageId メッセージID
	 * @param monitorId 監視項目ID
	 * @param monitorTypeId 監視対象ID
	 * @param priority 重要度
	 * @param truthValue 真偽値
	 * @param jobRun ジョブ実行
	 * @param jobId ジョブID
	 * @param jobInhibitionFlg ジョブの通知抑制と連動
	 * @param jobFailurePriority ジョブ呼出の失敗時の重要度
	 */
	public MonitorTruthValueInfo( 
			String message,
			String messageId,
			String monitorId,
			String monitorTypeId,
			int priority,
			int truthValue,
			int jobRun,
			String jobId,
			int jobInhibitionFlg,
			int jobFailurePriority ) {
		
		setMessage(message);
		setMessageId(messageId);
		setMonitorId(monitorId);
		setMonitorTypeId(monitorTypeId);
		setPriority(priority);
		setTruthValue(truthValue);
		setJobRun(jobRun);
		setJobId(jobId);
		setJobInhibitionFlg(jobInhibitionFlg);
		setJobFailurePriority(jobFailurePriority);
	}
	
	
	/**
	 * コンストラクタ。
	 * 
	 * @param otherData コピー元の真偽値監視の判定情報
	 */
	public MonitorTruthValueInfo( MonitorTruthValueInfo otherData )
	{
		setMessage(otherData.getMessage());
		setMessageId(otherData.getMessageId());
		setMonitorId(otherData.getMonitorId());
		setMonitorTypeId(otherData.getMonitorTypeId());
		setPriority(otherData.getPriority());
		setTruthValue(otherData.getTruthValue());
		setJobRun(otherData.getJobRun());
		setJobId(otherData.getJobId());
		setJobInhibitionFlg(otherData.getJobInhibitionFlg());
		setJobFailurePriority(otherData.getJobFailurePriority());
	}
	
	/**
	 * 真偽値を返します。
	 * 
	 * @return 真偽値
	 * 
	 * @see com.clustercontrol.monitor.run.bean.TruthConstant
	 */
	public int getTruthValue() {
		return m_truthValue;
	}
	
	/**
	 * 真偽値を設定します。
	 * 
	 * @param truthValue 真偽値
	 * 
	 * @see com.clustercontrol.monitor.run.bean.TruthConstant
	 */
	public void setTruthValue(int truthValue) {
		this.m_truthValue = truthValue;
	}
}
