/*
 
Copyright (C) 2008 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.mail.composite;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.notify.dialog.NotifyCreateDialog;
import com.clustercontrol.notify.mail.action.GetMailTemplate;
import com.clustercontrol.notify.mail.dialog.MailTemplateCreateDialog;
import com.clustercontrol.notify.mail.dialog.MailTemplateListDialog;
import com.clustercontrol.util.Messages;


/**
 * メールテンプレートID一覧コンポジットクラス<BR>
 * <p>
 * <dl>
 *  <dt>コンポジット</dt>
 *  <dd>「メールテンプレートID」 ラベル</dd>
 *  <dd>「メールテンプレートID一覧」 コンボボックス</dd>
 *  <dd>「[一覧]を開く」 ボタン</dd>
 * </dl>
 * 
 * @version 2.4.0
 * @since 2.4.0
 */
public class MailTemplateIdListComposite extends Composite {

	/** メールテンプレートID ラベル文字列。 */
	private String m_text = null;

    /** メールテンプレートID ラベル。 */
	private Label m_labelMailTemplateId = null;
	
    /** メールテンプレートID一覧 コンボボックス。 */
    private Combo m_comboMailTemplateId = null;
    
    /** 参照 ボタン。 */
    private Button m_buttonRefer = null;


    /**
     * インスタンスを返します。
	 * <p>
	 * 初期処理を呼び出し、コンポジットを配置します。
     * 
     * @param parent 親のコンポジット
     * @param style スタイル
     * @param labelFlg メールテンプレートIDラベル表示フラグ（表示する場合、<code> true </code>）。
     * 
     * @see org.eclipse.swt.SWT
	 * @see org.eclipse.swt.widgets.Composite#Composite(Composite parent, int style)
	 * @see #initialize(Composite, boolean)
	 */
    public MailTemplateIdListComposite(Composite parent, int style, boolean labelFlg) {
        super(parent, style);
        m_text = Messages.getString("mail.template.id");
        
        this.initialize(parent, labelFlg);
    }
    
    /**
     * インスタンスを返します。
     * <p>
	 * 初期処理を呼び出し、コンポジットを配置します。
	 * メールテンプレートIDラベルの文字列を指定します。
     * 
     * @param parent 親のコンポジット
     * @param style スタイル
     * @param text メールテンプレートID ラベル文字列
     * 
     * @see org.eclipse.swt.SWT
	 * @see org.eclipse.swt.widgets.Composite#Composite(Composite parent, int style)
	 * @see #initialize(Composite, boolean)
     */
    public MailTemplateIdListComposite(Composite parent, int style, String text) {
        super(parent, style);
        m_text = text;
        
        this.initialize(parent, true);
    }
    

    /**
	 * コンポジットを配置します。
	 * 
	 * @see #update()
	 */
    private void initialize(Composite parent, boolean labelFlg) {
    	
        // 変数として利用されるグリッドデータ
        GridData gridData = null;
        
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        if(labelFlg){
        	layout.numColumns = 15;	
        }
        else{
        	layout.numColumns = 10;
        }
        this.setLayout(layout);
        
        /*
         * メールテンプレートID
         */
        
        if(labelFlg){
            // ラベル
            this.m_labelMailTemplateId = new Label(this, SWT.NONE);
            gridData = new GridData();
            gridData.horizontalSpan = 8;
            gridData.horizontalAlignment = GridData.END;
            gridData.grabExcessHorizontalSpace = true;
            this.m_labelMailTemplateId.setLayoutData(gridData);
            this.m_labelMailTemplateId.setText(m_text + " : ");
        }
        
        // コンボボックス
        this.m_comboMailTemplateId = new Combo(this, SWT.DROP_DOWN | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboMailTemplateId.setLayoutData(gridData);
//        this.m_comboMailTemplateId.addSelectionListener(new SelectionAdapter() {
//        	public void widgetSelected(SelectionEvent e) {
//        		
//        	}
//        });
        
        // 参照 ボタン
        this.m_buttonRefer = new Button(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_buttonRefer.setLayoutData(gridData);
        this.m_buttonRefer.setText(Messages.getString("refer"));
        this.m_buttonRefer.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	
            	String mailTemplateId = m_comboMailTemplateId.getText();
            	if(mailTemplateId != null && !"".equals(mailTemplateId.trim())){
                    // シェルを取得
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    
                    // メールテンプレート登録/変更画面を開く
            		MailTemplateCreateDialog dialog = new MailTemplateCreateDialog(shell, mailTemplateId, true);
                    dialog.open();
            	}
            }
        });
        
        this.update();
    }

    /**
     * コンポジットを更新します。<BR>
     * メールテンプレートID一覧情報を取得し、メールテンプレートID一覧コンポジットにセットします。
	 * 
	 * @see com.clustercontrol.notify.mail.action.GetMailTemplate#getMailTemplateIdList()
     */
    public void update() {
    	
    	// 空欄
    	this.m_comboMailTemplateId.add("");
        
    	// データ取得
        ArrayList list = new GetMailTemplate().getMailTemplateIdList();
        if(list != null){
        	// メールテンプレートIDリスト
        	for(int index=0; index<list.size(); index++){
        		this.m_comboMailTemplateId.add((String)list.get(index));
        	}
        }
    }

	/* (非 Javadoc)
	 * @see org.eclipse.swt.widgets.Control#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		this.m_comboMailTemplateId.setEnabled(enabled);
		this.m_buttonRefer.setEnabled(enabled);
	}

	/**
	 * メールテンプレートIDを返します。
	 * 
	 * @return メールテンプレートID
	 * 
	 * @see org.eclipse.swt.widgets.Combo#getText()
	 */
	public String getText() {
		return this.m_comboMailTemplateId.getText();
	}

	/**
	 * メールテンプレートIDを設定します。
	 * 
	 * @param string メールテンプレートID
	 * 
	 * @see org.eclipse.swt.widgets.Combo#setText(java.lang.String)
	 */
	public void setText(String string) {
		this.m_comboMailTemplateId.setText(string);
	}
}