package com.clustercontrol.monitor.util;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import com.clustercontrol.monitor.bean.EventTableDefine;
import com.clustercontrol.monitor.bean.ScopeInfoData;
import com.clustercontrol.monitor.bean.ScopeTableDefine;
import com.clustercontrol.monitor.bean.StatusInfoData;
import com.clustercontrol.monitor.bean.StatusTableDefine;
import com.clustercontrol.monitor.ejb.entity.EventLogData;

public class ConvertListUtil {
	
	
	/**
	 * 
	 * SessionBean経由で取得されたEventLogDataのリストを、
	 * 表示用のリスト（ArrayListの二次元配列）に変換するためのメソッドです。
	 * 
	 * @param list
	 * @return
	 */
	public static ArrayList eventLogDataListToArrayList(ArrayList<EventLogData> list){
		
		ArrayList ret = new ArrayList();
    	Iterator<EventLogData> itr = list.iterator();
    	
    	while(itr.hasNext()) {
    		ArrayList event = new ArrayList();
    		EventLogData eventLogData = itr.next();

    		event.add(EventTableDefine.PRIORITY, eventLogData.getPriority());
   	        event.add(EventTableDefine.RECEIVE_TIME, new Date(eventLogData.getOutputDate().getTime()));
   	        event.add(EventTableDefine.OUTPUT_DATE, new Date(eventLogData.getGenerationDate().getTime()));
   	        event.add(EventTableDefine.PLUGIN_ID, eventLogData.getPluginId());
    	    event.add(EventTableDefine.MONITOR_ID, eventLogData.getMonitorId());
    	    event.add(EventTableDefine.FACILITY_ID, eventLogData.getFacilityId());
    	    event.add(EventTableDefine.SCOPE, eventLogData.getScopeText());
    	    event.add(EventTableDefine.APPLICATION, eventLogData.getApplication());
    	    event.add(EventTableDefine.MESSAGE_ID, eventLogData.getMessageId());
    	    event.add(EventTableDefine.MESSAGE, eventLogData.getMessage());
    	    event.add(EventTableDefine.CONFIRMED, eventLogData.getConfirmFlg());
    	    event.add(EventTableDefine.CONFIRM_USER, eventLogData.getConfirmUser());
    	        	
    		ret.add(event);
    	}

    	return ret;
	}
	
	
	/**
	 * 
	 * 監視[イベント]ビューに表示される内容を基にして、
	 * EventLogDataのリストに変換するためのメソッドです。
	 * 
	 * オリジナルメッセージのように、表示されていない項目については、
	 * セットされないので注意してください。
	 * 
	 * @param list
	 * @return
	 */
	public static ArrayList<EventLogData> listToEventLogDataList(List list) {
		
    	ArrayList<EventLogData> eventLogDataList = new ArrayList();
    	Iterator itr = list.iterator();
    	while(itr.hasNext()) {
    		
    		ArrayList event = (ArrayList) itr.next();
    		
    		Integer priority = (Integer) event.get(EventTableDefine.PRIORITY);
    		Timestamp outputDate = new Timestamp (((Date) event.get(EventTableDefine.RECEIVE_TIME)).getTime());
    		Timestamp generationDate = new Timestamp (((Date) event.get(EventTableDefine.OUTPUT_DATE)).getTime());
    		String pluginId = (String) event.get(EventTableDefine.PLUGIN_ID);
    		String monitorId = (String) event.get(EventTableDefine.MONITOR_ID);
    		String facilityId = (String) event.get(EventTableDefine.FACILITY_ID);
    		String scopeText = (String) event.get(EventTableDefine.SCOPE);
    		String application = (String) event.get(EventTableDefine.APPLICATION);
    		String messageId = (String) event.get(EventTableDefine.MESSAGE_ID);
    		String message = (String) event.get(EventTableDefine.MESSAGE);
    		Integer confirmFlg = (Integer) event.get(EventTableDefine.CONFIRMED);
    		String confirmUser = (String) event.get(EventTableDefine.CONFIRM_USER);
    		
    		EventLogData eventLogData = new EventLogData();
    		eventLogData.setPriority(priority);
    		eventLogData.setOutputDate(outputDate);
    		eventLogData.setGenerationDate(generationDate);
    		eventLogData.setPluginId(pluginId);
    		eventLogData.setMonitorId(monitorId);
    		eventLogData.setFacilityId(facilityId);
    		eventLogData.setScopeText(scopeText);
    		eventLogData.setApplication(application);
    		eventLogData.setMessageId(messageId);
    		eventLogData.setMessage(message);
    		eventLogData.setConfirmFlg(confirmFlg);
    		eventLogData.setConfirmUser(confirmUser);
    		
    		eventLogDataList.add(eventLogData);
    	    		
    	}

    	return eventLogDataList;
    	
	}
	
    public static ArrayList statusInfoDataListToArrayList(ArrayList<StatusInfoData> list) {
    	
    	ArrayList ret  = new ArrayList();
    	Iterator<StatusInfoData> itr = list.iterator();
    	
    	while(itr.hasNext()) {
    		ArrayList status = new ArrayList();
    		StatusInfoData statusInfoData = itr.next();
    		status.add(StatusTableDefine.PRIORITY, statusInfoData.getPriority());
    		status.add(StatusTableDefine.PLUGIN_ID, statusInfoData.getPluginId());
    		status.add(StatusTableDefine.MONITOR_ID, statusInfoData.getMonitorId());
    		status.add(StatusTableDefine.FACILITY_ID, statusInfoData.getFacilityId());
    		status.add(StatusTableDefine.SCOPE, statusInfoData.getFacilityPath());
    		status.add(StatusTableDefine.APPLICATION, statusInfoData.getApplication());
    		status.add(StatusTableDefine.UPDATE_TIME, new Date(statusInfoData.getOutputDate().getTime()));
    		status.add(StatusTableDefine.OUTPUT_TIME, new Date(statusInfoData.getGenerationDate().getTime()));
    		status.add(StatusTableDefine.MESSAGE_ID, statusInfoData.getMessageId());
    		status.add(StatusTableDefine.MESSAGE, statusInfoData.getMessage());
    		
    		ret.add(status);
    	}
    	
    	return ret;
    	
    }
    
    public static ArrayList<StatusInfoData> listToStatusInfoDataList(List list) {
    	

	    ArrayList<StatusInfoData> ret = new ArrayList<StatusInfoData>();
		Iterator itr = list.iterator();
		
		while (itr.hasNext()) {
			
			ArrayList status = (ArrayList) itr.next();
			
			String monitorId = (String) status.get(StatusTableDefine.MONITOR_ID);
			String pluginId = (String) status.get(StatusTableDefine.PLUGIN_ID); 
			String facilityId = (String) status.get(StatusTableDefine.FACILITY_ID); 
			String application = (String) status.get(StatusTableDefine.APPLICATION); 
			Timestamp generationDate = new Timestamp(((Date) status.get(StatusTableDefine.OUTPUT_TIME)).getTime());    		
			String messageId = (String) status.get(StatusTableDefine.MESSAGE_ID); 
			String message = (String) status.get(StatusTableDefine.MESSAGE);
			Integer priority = (Integer) status.get(StatusTableDefine.PRIORITY);
			
			StatusInfoData statusInfoData = new StatusInfoData();
			statusInfoData.setMonitorId(monitorId);
			statusInfoData.setPluginId(pluginId);
			statusInfoData.setFacilityId(facilityId);
			statusInfoData.setApplication(application);
			statusInfoData.setGenerationDate(generationDate);
			statusInfoData.setMessageId(messageId);
			statusInfoData.setMessage(message);
			statusInfoData.setPriority(priority);
			
			ret.add(statusInfoData);
		}
		
		return ret;
	}
    
    
    
    public static ArrayList scopeInfoDataListToArrayList(ArrayList<ScopeInfoData> list) {
    	
    	ArrayList ret  = new ArrayList();
    	
    	Iterator<ScopeInfoData> itr = list.iterator();
    	while(itr.hasNext()) {
    		ArrayList status = new ArrayList();
    		ScopeInfoData scopeInfoData = itr.next();
    		status.add(ScopeTableDefine.PRIORITY, scopeInfoData.getPriority());
    		status.add(ScopeTableDefine.FACILITY_ID, scopeInfoData.getFacilityId());
    		status.add(ScopeTableDefine.SCOPE, scopeInfoData.getFacilityPath());
    		status.add(ScopeTableDefine.UPDATE_TIME, new Date(scopeInfoData.getOutputDate().getTime()));
    		status.add(ScopeTableDefine.SORT_VALUE, scopeInfoData.getSortValue());
    		
    		ret.add(status);
    	}
    	
    	return ret;
    	
    }
    
}
