/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.message;

import java.sql.Timestamp;

/**
 * 並列処理用のログ出力情報を保持するクラス<BR>
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class ParallelLogOutputInfo implements java.io.Serializable{

	private static final long serialVersionUID = -4905245980492992775L;
	
	private LogOutputInfo logOutputInfo;	// ログ出力情報
	private Timestamp outputDate;			// 出力日時

	/**
	 * ログ出力情報を返します。
	 * 
	 * @return ログ出力情報
	 */
	public LogOutputInfo getLogOutputInfo() {
		return logOutputInfo;
	}
	
	/**
	 * ログ出力情報を設定します。
	 * 
	 * @param logOutputInfo ログ出力情報
	 */
	public void setLogOutputInfo(LogOutputInfo logOutputInfo) {
		this.logOutputInfo = logOutputInfo;
	}
	
	/** 
	 * 受信日時を返します。
	 * 
	 * @return 受信日時
	 */
	public Timestamp getOutputDate() {
		return outputDate;
	}
	
	/**
	 * 受信日時を設定します。
	 * 
	 * @param outputDate 受信日時
	 */
	public void setOutputDate(Timestamp outputDate) {
		this.outputDate = outputDate;
	}
}
