/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorNumericValueInfoLocal;

/**
 * 数値監視の判定情報を検索する抽象クラス<BR>
 * <p>
 * 数値監視を行う各監視管理クラスで継承してください。
 *
 * @version 2.0.0
 * @since 2.0.0
 */
abstract public class SelectMonitorNumericValueType extends SelectMonitor{
	
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( SelectMonitorNumericValueType.class );

	/**
	 * 監視情報より数値監視の判定情報を返します。
	 * <p>
	 * <ol>
	 * <li>監視情報より、数値監視判定情報を取得します。</li>
	 * <li>１判定情報をビーン（{@link com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo}）にセットします。</li>
	 * <li>このビーンを、判定情報を保持するリスト（{@link ArrayList}）にセットし返します。<BR>
	 * </ol>
	 * 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorInfoBean
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorNumericValueInfoBean
	 * @see com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo
	 */
	@Override
	public ArrayList getJudgementInfo() throws FinderException, NamingException {
		
		// 数値監視判定情報を取得
		Collection ct = m_monitor.getMonitorNumericValueInfo();
        Iterator itr = ct.iterator();
		
		ArrayList<MonitorNumericValueInfo> valueList = new ArrayList<MonitorNumericValueInfo>();
		
        MonitorNumericValueInfoLocal local = null;
        while(itr.hasNext()){
            local = (MonitorNumericValueInfoLocal)itr.next();
            MonitorNumericValueInfo value = new MonitorNumericValueInfo(
            		local.getMessage(),
            		local.getMessageId(),
            		local.getMonitorId(),
            		local.getMonitorTypeId(),
            		local.getPriority(),
            		local.getThresholdLowerLimit(),
            		local.getThresholdUpperLimit(),
            		local.getJobRun(),
            		local.getJobId(),
            		local.getJobInhibitionFlg(),
            		local.getJobFailurePriority());
            valueList.add(value);
        }
		return valueList;
	}
}
