/*
 
Copyright (C) 2008 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.mail.factory;

import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.monitor.bean.QueueConstant;
import com.clustercontrol.notify.bean.NotifyEventInfo;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.bean.NotifyInfoContext;
import com.clustercontrol.notify.ejb.entity.NotifyEventInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyEventInfoUtil;
import com.clustercontrol.notify.ejb.entity.NotifyInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyInfoUtil;
import com.clustercontrol.notify.mail.ejb.entity.MailTemplateInfo;
import com.clustercontrol.notify.mail.ejb.entity.MailTemplateInfoData;
import com.clustercontrol.notify.mail.ejb.entity.MailTemplateInfoLocal;
import com.clustercontrol.notify.mail.ejb.entity.MailTemplateInfoUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * メールテンプレート情報を変更するクラス<BR>
 *
 * @version 2.4.0
 * @since 2.4.0
 */
public class ModifyMailTemplate {
	
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( ModifyMailTemplate.class );
	
	/**
	 * メールテンプレート情報を変更します。
	 * <p>
	 * <ol>
	 *  <li>メールテンプレートIDより、メールテンプレート情報を取得し、
	 *      メールテンプレート情報を変更します。</li>
	 * </ol>
	 * 
	 * @param info 変更対象のメールテンプレート情報
	 * @param name 変更したユーザ名
	 * @return 変更に成功した場合、<code> true </code>
	 * @throws FinderException
	 * @throws NamingException
	 * 
	 * @see com.clustercontrol.notify.ejb.entity.MailTemplateInfoBean
	 */
	public boolean modify(MailTemplateInfoData data, String name) throws FinderException, NamingException {
    	//アクセスロック
    	AccessLock.lock(AccessLock.NOTIFY);
    	
    	try {
	    	//メールテンプレート情報を取得
	    	MailTemplateInfoLocal mailTemplateInfo = MailTemplateInfoUtil
	    			.getLocalHome().findByPrimaryKey(data.getMailTemplateId());
	    	
	    	//メールテンプレート情報を更新
	    	if (mailTemplateInfo != null) {
	    		mailTemplateInfo.setDescription(data.getDescription());
	    		mailTemplateInfo.setSubject(data.getSubject());
	    		mailTemplateInfo.setBody(data.getBody());
//	    		mailTemplateInfo.setRegDate(data.getRegDate());
	    		mailTemplateInfo.setUpdateDate(new Timestamp(new Date().getTime()));
//	    		mailTemplateInfo.setRegUser(data.getRegUser());
	    		mailTemplateInfo.setUpdateUser(name);
	    		
	    	}
		} catch (FinderException e) {
			AplLogger apllog = new AplLogger("MAILTEMP", "mail_template");
	        String[] args = { data.getMailTemplateId() };
	        apllog.put("SYS", "002", args);
	        m_log.warn("modify():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			AplLogger apllog = new AplLogger("MAILTEMP", "mail_template");
	        String[] args = { data.getMailTemplateId() };
	        apllog.put("SYS", "002", args);
	        m_log.warn("modify():" + e.getMessage());
			throw e;
		}
    	
    	return true;
	}
			
}
