/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.view.action;

import javax.ejb.RemoveException;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.performance.action.RecordController;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performance.view.CurrentListView;

/**
 * 収集済みデータの削除を行うアクションクラス
 * 
 * @version 1.0
 * @since 1.0
 */
public class DeleteCollectedDataAction implements IViewActionDelegate {
    public static final String ID = "com.clustercontrol.performance.view.action.DeleteCollectedDataAction";
	
    private IViewPart viewPart; // ビュー

    /**
     * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
     * 
     * @param view ビューのインスタンス
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart view) {
        this.viewPart = view;
    }

    /**
     * 性能[収集データ]ビューで選択されている収集を削除します。
     *  
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        /*
         * 呼び出し元のViewを持ってきます。
         */
        IWorkbenchPage page = PlatformUI.getWorkbench()
                .getActiveWorkbenchWindow().getActivePage();
        CurrentListView listView = (CurrentListView) page
                .findView(Messages.getString("VIEW_CURRENT_LIST"));

        /*
         * テーブルで選ばれている収集のIDを取得します。
         */
        if (listView.getSelectedID() != null) {
    		// アクセス権なしの場合、エラーダイアログを表示する
        	if(!RecordController.getInstance().checkPermissionWrite()){
        		MessageDialog.openInformation(null, com.clustercontrol.util.Messages.getString("message"),
        				com.clustercontrol.util.Messages.getString("message.accesscontrol.16"));
        		return;
        	}
        	
            String msg = Messages.getString("MESSAGE_0028") + " " + 
            listView.getSelectedID() + 
            Messages.getString("MESSAGE_0016");

            if (MessageDialog.openQuestion(null, Messages
                    .getString("MESSAGE_0020"), msg)) { // "確認"

                // Beanを取得
                RecordController controller = RecordController.getInstance();
                // マネージャとの接続に失敗した場合はエラーダイアログを表示
                if (controller == null) {
                    MessageDialog.openError(this.viewPart.getSite().getShell(),
                            Messages.getString("MESSAGE_0020"),
                            Messages.getString("CONNECTION_ERROR_MESSAGE"));
                    return;
                }

                try {
                    // 削除ロックを解除
                    RecordController.getInstance().unlock();
                	
                    // 収集データを削除
                    if (!controller.deleteRecordCollector(listView
                            .getSelectedID())) {
                        // 収集データの削除に失敗した場合はエラーダイアログを表示
                        MessageDialog.openError(
                                        this.viewPart.getSite().getShell(),
                                        Messages.getString("MESSAGE_0020"),
                                        Messages.getString("DELETE_DATA_ERROR_MESSAGE"));
                    }
                } catch (RemoveException e) {
                    // 削除ロックがかかっているため削除できない場合の処理
                    MessageDialog.openError(this.viewPart.getSite().getShell(),
                            Messages.getString("MESSAGE_0020"),
                            Messages.getString("DELETE_DATA_LOCKED_MESSAGE"));
                }

                //収集済みのリストのリフレッシュを行います。
                listView.refresh();
            } else {
            }
        } else {

            String msg = Messages.getString("MESSAGE_0014");

            MessageDialog.openError(null,
                    Messages.getString("ERROR_IN_JP"), msg);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {

    }

}