/*
Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/
package com.clustercontrol.performanceMGR.bean;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.performanceMGR.ejb.bmp.CollectorLocalHome;

/**
 * Quartz関連定数クラス
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class QuartzConstant {
	private static Log m_log = LogFactory.getLog( QuartzConstant.class );
	
	public static final String GROUP_COLLECT  = "PERF_COLLECT";
	public static final String GROUP_MONITOR  = "PERF_MONITOR";
	public static final String JNDI_NAME = CollectorLocalHome.JNDI_NAME;
	public static final String QUARTZ_NAME = getQuartzName();
	//public static final String JNDI_NAME_PERF = CollectorRunManagementHome.JNDI_NAME;
	public static final String JNDI_NAME_PERF_MNG ="CollectorRunController";
	public static final String METHOD_NAME_PERF_MNG = "managePresavePeriod";
	
	// 計算処理実行開始を設定するための、SNMPポーリングからのディレイタイム
	private static int delayTimeUnder1min = -1;
	private static int delayTimeOver1min = -1;
	
	/**
	 * 性能管理機能で利用するQuartzスケジューラへ参照可能なJNDI名を返す。
	 * 
	 * @return JNDI名
	 */
	public static String getQuartzName() {
		try {
			Properties properties = getProperties();
			return properties.getProperty("QuartzJndiName");
		} catch (Exception e) {
			// エラー処理
			m_log.error(e.getMessage(), e);
			return null;
		}
	}

	/**
	 * 計算処理実行開始を設定するための、SNMPポーリングからのディレイタイムを
	 * propertyファイルから読み出し返します。
	 * 対象は、収集間隔1分未満のもの
	 * @return ディレイタイム
	 */
	public static int getDelayTimeUnder1min() {
		if(delayTimeUnder1min == -1){
			try {
				Properties properties = getProperties();

				String time = properties.getProperty("performance.delaytime.under1min");
				delayTimeUnder1min = Integer.parseInt(time);
			} catch (Exception e) {
				// エラー処理
				delayTimeUnder1min = 3;
			}
		}
		
		return delayTimeUnder1min;
	}

	/**
	 * 計算処理実行開始を設定するための、SNMPポーリングからのディレイタイムを
	 * propertyファイルから読み出し返します。
	 * 対象は、収集間隔1分以上のもの
	 * @return ディレイタイム
	 */
	public static int getDelayTimeOver1min() {
		if(delayTimeOver1min == -1){
			try {
				Properties properties = getProperties();

				String time = properties.getProperty("performance.delaytime.over1min");
				delayTimeOver1min = Integer.parseInt(time);
			} catch (Exception e) {
				// エラー処理
				delayTimeOver1min = 10;
			}
		}
		
		return delayTimeOver1min;
	}
	
	private static Properties getProperties() throws IOException, FileNotFoundException {
		// 性能値算出用設定ファイルを読み込む
	    Properties properties = new Properties();
		
		// デフォルトロケールを取得
		Locale locale = Locale.getDefault();
		
		String homeDir = System.getProperty("jboss.server.home.dir");
		String confDir = homeDir + File.separator + "conf" + File.separator;
		String propertyFile;
		// 言語が日本語の場合
		if(locale.getLanguage().equals("ja")){
			propertyFile = confDir + "performance_ja.properties";
		} else { // 日本語以外の場合
			propertyFile = confDir + "performance.properties";
		}
		
		// プロパティファイルからキーと値のリストを読み込みます
		properties.load(new FileInputStream(propertyFile));
		
		return properties;
	}
}
