/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performanceMGR.ejb.bmp;

import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.performanceMGR.bean.CollectorRunStatus;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorStatusPK;


/**
 *
 * <!-- begin-user-doc --> You can insert your documentation for '<em><b>CollectorBean</b></em>'. <!-- end-user-doc --> *
 <!--  begin-lomboz-definition -->
 <?xml version="1.0" encoding="UTF-8"?>
 <lomboz:EJB xmlns:j2ee="http://java.sun.com/xml/ns/j2ee" xmlns:lomboz="http://lomboz.objectlearn.com/xml/lomboz">
 <lomboz:entity>
 <lomboz:entityEjb>
 <j2ee:display-name>CollectorStatus</j2ee:display-name>
 <j2ee:ejb-name>CollectorStatusEjb</j2ee:ejb-name>
 <j2ee:ejb-class>com.clustercontrol.performanceMGR.ejb.bmp.CollectorStatusBean</j2ee:ejb-class>
 <j2ee:persistence-type>Bean</j2ee:persistence-type>
 <j2ee:cmp-version>2.x</j2ee:cmp-version>
 <j2ee:abstract-schema-name>mySchema</j2ee:abstract-schema-name>
 </lomboz:entityEjb>
 <lomboz:tableName></lomboz:tableName>
 <lomboz:dataSourceName></lomboz:dataSourceName>
 </lomboz:entity>
 </lomboz:EJB>
 <!--  end-lomboz-definition -->
 *
 * <!-- begin-xdoclet-definition -->
 */

/**
 *
 * 収集ステータスのEntityBeanクラス
 *
 * @version 2.0.0
 * @since 2.0.0
 * 
 * @ejb.bean name="CollectorStatus"
 *	jndi-name="CollectorStatusEjb"
 * 	local-jndi-name="CollectorStatusLocalEJB"
 *	type="BMP"
 *  view-type="both"
 *
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.permission
 *  unchecked="true"
 * 
 * @ejb.dao 
 * class="com.clustercontrol.performanceMGR.ejb.bmp.CollectorStatusDAO"
 * impl-class="com.clustercontrol.performanceMGR.dao.CollectorStatusDAOImpl"  
 *  
 * <!-- end-xdoclet-defintion -->
 * @generated
 **/
public abstract class CollectorStatusBean implements EntityBean {
	// ログ出力
	protected static Log m_log = LogFactory.getLog(CollectorStatusBean.class );
	
	private String	collectorID;
	
	private int	runStatus;
	private int	errorStatus;
	private int	endStatus;
	private int	count;
	private Date lastCollectDate;
	
	/**
	 * EntityBeanを生成する際にコンテナから呼ばれるメソッド
	 * @param pk 収集ステータス設定のPKクラス
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * @throws CreateException
	 * @throws DuplicateKeyException
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public CollectorStatusPK ejbCreate(CollectorStatusPK pk) 
	throws CreateException, DuplicateKeyException{
		// フィールド変数の初期化
		collectorID = pk.getCollectorID();
		runStatus = CollectorRunStatus.READY;
		errorStatus = EndStatusConstant.TYPE_NORMAL;
		endStatus = EndStatusConstant.TYPE_NORMAL;
		count = 0;
		lastCollectDate = null;
		
		return new CollectorStatusPK(pk.getCollectorID());
	}
	
	/**
	 * プライマリキーをもとにEntityBeanを検索する際にコンテナから呼ばれます。
	 * @param pk 収集設定の一意識別子pk
	 * @return pk 収集設定の一意識別子pk
	 **/
	public CollectorStatusPK ejbFindByPrimaryKey(CollectorStatusPK pk) throws FinderException { 
		// ここでは何もせず、DAOの実装クラスに処理をまかせる		
		return null; 
	}
		
	/**
	 * EntityBeanのメソッドを呼び出す直前にコンテナから呼ばれます。
	 * 
	 * @generated
	 */
	public void ejbLoad(){
	}
	
	/**
	 * EntityBeanを生成直後にコンテナから呼ばれるメソッド
	 * 特に何もしません。
	 * 
	 * <!-- begin-user-doc -->
	 * The container invokes this method immediately after it calls ejbCreate.
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void ejbPostCreate() throws CreateException {
	}
	
	/**
	 * プライマリキーをもとにEntityBeanを削除する時にコンテナから呼ばます。
	 * @throws RemoveException
	 * @generated
	 */
	public void ejbRemove() throws RemoveException {

	}
	
	/**
	 * EntityBeanのメソッドが終了した直後にコンテナから呼ばれます。
	 * 
	 * @generated
	 */
	public void ejbStore(){
		
	}
	
	/**
	 * 収集IDを取得します。
	 * @return collectorID 収集ID
	 * 
	 * @ejb.persistence 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 *	view-type="both" 
	 */
	public String getCollectorID() {
		return collectorID;
	}
	
	/**
	 * 実行状態を取得します。
	 * @return runStatus 実行状態
	 * 
	 * @ejb.persistence  
	 * @ejb.interface-method
	 *	view-type="both" 
	 */
	public int getRunStatus() {
		return runStatus;
	}
	
	/**
	 * エラー状態を取得します。
	 * @return errorStatus エラー状態
	 * 
	 * @ejb.persistence 
	 * @ejb.interface-method
	 *	view-type="both" 
	 */
	public int getErrorStatus() {
		return errorStatus;
	}
	
	/**
	 * 終了状態を取得します。
	 * @return endStatus 終了状態
	 * 
	 * @ejb.persistence 
	 * @ejb.interface-method
	 *	view-type="both" 
	 */
	public int getEndStatus() {
		return endStatus;
	}
	
	/**
	 * 収集回数を取得します。
	 * @return count 収集回数
	 * 
	 * @ejb.persistence 
	 * @ejb.interface-method
	 *	view-type="both" 
	 */
	public int getCount() {
		return count;
	}
	
	/**
	 * 最終収集時刻を取得します。
	 * @return lastCollectDate 最終収集時刻
	 * 
	 * @ejb.persistence  
	 * @ejb.interface-method
	 *	view-type="both" 
	 */
	public Date getLastCollectDate() {
		return lastCollectDate;
	}
	
	/**
	 * 収集IDを設定します。
	 * @param collectorID 収集ID
	 * @ejb.interface-method
	 *	view-type="both" 
	 */
	public void setCollectorID(String collectorID) {
		this.collectorID = collectorID;
	}
	
	/**
	 * 実行状態を設定します。
	 * @param runStatus 実行状態
	 * @ejb.interface-method
	 *	view-type="both" 
	 */
	public void setRunStatus(int runStatus) {
		this.runStatus = runStatus;
	}
	
	/**
	 * エラー状態を設定します。
	 * @param errorStatus エラー状態
	 * @ejb.interface-method
	 *	view-type="both" 
	 */
	public void setErrorStatus(int errorStatus) {
		this.errorStatus = errorStatus;
	}
	
	/**
	 * 終了状態を設定します。
	 * @param endStatus 終了状態
	 * @ejb.interface-method
	 *	view-type="both" 
	 */
	public void setEndStatus(int endStatus) {
		this.endStatus = endStatus;
	}
	
	/**
	 * 収集回数を設定します。
	 * @param count 収集回数
	 * @ejb.interface-method
	 *	view-type="both" 
	 */
	public void setCount(int count) {
		this.count = count;
	}

	/**
	 * 最終収集時刻を設定します。
	 * @param lastCollectDate 最終収集時刻
	 * @ejb.interface-method
	 *	view-type="both" 
	 */
	public void setLastCollectDate(Date lastCollectDate) {
		this.lastCollectDate = lastCollectDate;
	}

}
