/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performanceMGR.util.code;

import java.io.Serializable;
import java.util.ArrayList;


/**
 * 収集情報のカテゴリーを保持するクラス
 * 実績グラフ表示の際に設定及び、グラフ描画のカテゴリー（CPU,Memmory,Disk,Net)の情報を保持するクラス
 * 
 * @version 1.0
 * @since 1.0
 */
public class CollectorItemCategoryInfo implements ICollectorItemInfo, Serializable {
    private String categoryCode;

    private String categoryName;

    private ArrayList<CollectorItemCodeInfo> itemCodeList; // 収集項目コードのリスト

    /**
     * 指定のカテゴリコード、カテゴリ名でCollectorItemCategoryInfoクラスのインスタンスを生成します。
     * @param categoryCode カテゴリコード
     * @param categoryName カテゴリ名
     */
    public CollectorItemCategoryInfo(String categoryCode, String categoryName) {
        this.categoryCode = categoryCode;
        this.categoryName = categoryName;
        this.itemCodeList = new ArrayList<CollectorItemCodeInfo>();
    }

    /**
     * カテゴリに収集項目を追加します。
     * 
     * @param item
     */
    public void addItem(CollectorItemCodeInfo item) {
        itemCodeList.add(item);
    }

    /**
     * カテゴリに含まれる収集項目を返します。
     * 
     * @param index
     */
    public CollectorItemCodeInfo getItem(int index) {
        return (CollectorItemCodeInfo) itemCodeList.get(index);
    }

    /**
     * カテゴリコードを取得します。
     * @return categoryCode カテゴリコード
     */
    public String getCategoryCode() {
        return categoryCode;
    }

    /**
     * カテゴリコードを設定します。
     * @param categoryCode カテゴリコード
     */
    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    /**
     * カテゴリ名を取得します。
     * @return categoryName カテゴリ名
     */
    public String getCategoryName() {
        return categoryName;
    }

    /**
     * カテゴリ名を設定します。
     * @param categoryName カテゴリ名
     */
    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    /**
     * カテゴリに含まれる収集項目コードのリストを取得します。
     * @return itemCodeList 収集項目コードのリスト
     */
    public ArrayList getItemCodeList() {
        return itemCodeList;
    }

    /**
     * カテゴリに含める収集項目コードのリストを設定します。
     * @param itemCodeList 収集項目コードのリスト
     */
    public void setItemCodeList(ArrayList<CollectorItemCodeInfo> itemCodeList) {
        this.itemCodeList = itemCodeList;
    }

    /**
     * カテゴリ名を取得します。
     */
	public String getName() {
		return getCategoryName();
	}

	/**
	 * カテゴリコードを取得します。
	 */
	public String getCode() {
		return getCategoryCode();
	}
}