/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.repository.factory;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.collectiverun.ejb.session.CollectiveRunControllerLocal;
import com.clustercontrol.collectiverun.ejb.session.CollectiveRunControllerUtil;
import com.clustercontrol.commons.ejb.UsedFacilityException;
import com.clustercontrol.jobmanagement.ejb.session.JobControllerLocal;
import com.clustercontrol.jobmanagement.ejb.session.JobControllerUtil;
import com.clustercontrol.logtransfer.ejb.session.LogTransferControllerLocal;
import com.clustercontrol.logtransfer.ejb.session.LogTransferControllerUtil;
import com.clustercontrol.monitor.run.ejb.session.MonitorRunControllerLocal;
import com.clustercontrol.monitor.run.ejb.session.MonitorRunControllerUtil;
import com.clustercontrol.performanceMGR.ejb.session.CollectorControllerLocal;
import com.clustercontrol.performanceMGR.ejb.session.CollectorControllerUtil;
import com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapControllerLocal;
import com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapControllerUtil;
import com.clustercontrol.syslogng.ejb.session.SyslogNGControllerLocal;
import com.clustercontrol.syslogng.ejb.session.SyslogNGControllerUtil;

/**
 * ファシリティのチェックを行うクラス<BR>
 *
 * @version 2.1.2
 * @since 2.1.2
 */
public class CheckFacility {
	protected static Log log = LogFactory.getLog( CheckFacility.class );
	
	/**
	 * 各機能で、ファシリティIDが使用されているかチェックします。
	 * <P>
	 * 使用されていたら、UsedFacilityException がスローされる。
	 * 
	 * @param facilityId ファシリティ
	 * @throws UsedFacilityException
	 * 
	 * @see com.clustercontrol.collectiverun.ejb.session.CollectiveRunControllerLocal#isUseFacilityId(java.lang.String)
	 * @see com.clustercontrol.jobmanagement.ejb.session.JobControllerLocal#isUseFacilityId(java.lang.String)
	 * @see com.clustercontrol.logtransfer.ejb.session.LogTransferControllerLocal#isUseFacilityId(java.lang.String)
	 * @see com.clustercontrol.monitor.run.ejb.session.MonitorRunControllerLocal#isUseFacilityId(java.lang.String)
	 * @see com.clustercontrol.performanceMGR.ejb.session.CollectorControllerLocal#isUseFacilityId(java.lang.String)
	 * @see com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapControllerLocal#isUseFacilityId(java.lang.String)
	 * @see com.clustercontrol.syslogng.ejb.session.SyslogNGControllerLocal#isUseFacilityId(java.lang.String)
	 */
	public void isUseFacility(String facilityId) throws UsedFacilityException {
		
		//各監視にて、ファシリティIDが使用されていないかチェック
		try {
			MonitorRunControllerLocal controller = 
				MonitorRunControllerUtil.getLocalHome().create();
			controller.isUseFacilityId(facilityId);
		} catch (CreateException e) {
			log.debug("isUseFacility() : " + e.getMessage());
		} catch (NamingException e) {
			log.debug("isUseFacility() : " + e.getMessage());
		}
		
		//syslog-ng監視にて、ファシリティIDが使用されていないかチェック
		try {
			SyslogNGControllerLocal controller = 
				SyslogNGControllerUtil.getLocalHome().create();
			controller.isUseFacilityId(facilityId);
		} catch (CreateException e) {
			log.debug("isUseFacility() : " + e.getMessage());
		} catch (NamingException e) {
			log.debug("isUseFacility() : " + e.getMessage());
		}
		
		//SNMPTRAP監視にて、ファシリティIDが使用されていないかチェック
		try {
			MonitorSnmpTrapControllerLocal controller = 
				MonitorSnmpTrapControllerUtil.getLocalHome().create();
			controller.isUseFacilityId(facilityId);
		} catch (CreateException e) {
			log.debug("isUseFacility() : " + e.getMessage());
		} catch (NamingException e) {
			log.debug("isUseFacility() : " + e.getMessage());
		}
		
		//ログ転送にて、ファシリティIDが使用されていないかチェック
		try {
			LogTransferControllerLocal controller = 
				LogTransferControllerUtil.getLocalHome().create();
			controller.isUseFacilityId(facilityId);
		} catch (CreateException e) {
			log.debug("isUseFacility() : " + e.getMessage());
		} catch (NamingException e) {
			log.debug("isUseFacility() : " + e.getMessage());
		}
		
		//ジョブ管理にて、ファシリティIDが使用されていないかチェック
		try {
			JobControllerLocal controller = 
				JobControllerUtil.getLocalHome().create();
			controller.isUseFacilityId(facilityId);
		} catch (CreateException e) {
			log.debug("isUseFacility() : " + e.getMessage());
		} catch (NamingException e) {
			log.debug("isUseFacility() : " + e.getMessage());
		}
		
		//一括制御にて、ファシリティIDが使用されていないかチェック
		try {
			CollectiveRunControllerLocal controller = 
				CollectiveRunControllerUtil.getLocalHome().create();
			controller.isUseFacilityId(facilityId);
		} catch (CreateException e) {
			log.debug("isUseFacility() : " + e.getMessage());
		} catch (NamingException e) {
			log.debug("isUseFacility() : " + e.getMessage());
		}
		
		//性能管理にて、ファシリティIDが使用されていないかチェック
		try {
			CollectorControllerLocal controller = 
				CollectorControllerUtil.getLocalHome().create();
			controller.isUseFacilityId(facilityId);
		} catch (CreateException e) {
			log.debug("isUseFacility() : " + e.getMessage());
		} catch (NamingException e) {
			log.debug("isUseFacility() : " + e.getMessage());
		}
	}
}
