/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.composite;

import com.clustercontrol.bean.Property;
import com.clustercontrol.collectiverun.action.GetParameterProperty;
import com.clustercontrol.collectiverun.bean.TypeConstant;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.util.Messages;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ParameterComposite
extends Composite {
    protected PropertySheet m_propertySheet = null;
    protected Combo m_type = null;

    public ParameterComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite composite = new Composite((Composite)this, 0);
        RowLayout compositeLayout = new RowLayout(256);
        composite.setLayout((Layout)compositeLayout);
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        Label management = new Label(composite, 16384);
        management.setText(String.valueOf(Messages.getString((String)"type")) + " : ");
        RowData rowData = new RowData();
        management.setLayoutData((Object)rowData);
        this.m_type = new Combo(composite, 8);
        rowData = new RowData(160, 20);
        this.m_type.setLayoutData((Object)rowData);
        this.m_type.add(Messages.getString((String)"installation.management"));
        this.m_type.add(Messages.getString((String)"start.stop.management"));
        this.m_type.add(Messages.getString((String)"user.management"));
        this.m_type.add(Messages.getString((String)"filesystem.management"));
        this.m_type.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ParameterComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_type.select(0);
        TableTree table = new TableTree((Composite)this, 66306);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.m_propertySheet = new PropertySheet(table);
        this.update();
    }

    public void update() {
        int type = this.getType();
        Property data = new GetParameterProperty().getProperty(type);
        if (data == null) {
            data = new Property(null, null, "");
        }
        this.m_propertySheet.setInput(data);
        this.m_propertySheet.expandAll();
    }

    public void update(String sessionId) {
        int type;
        GetParameterProperty parameter = new GetParameterProperty();
        if (sessionId != null && sessionId.length() > 0 && (type = parameter.getType(sessionId)) != -1) {
            Property data = parameter.getProperty(sessionId);
            this.m_propertySheet.setInput(data);
            this.m_propertySheet.expandAll();
            this.m_type.setText(TypeConstant.typeToString((int)type));
        }
    }

    public Property getInputData() {
        return (Property)this.m_propertySheet.getInput();
    }

    public void setInputData(Property data) {
        this.m_propertySheet.setInput(data);
        this.m_propertySheet.expandAll();
    }

    public int getType() {
        return TypeConstant.stringToType((String)this.m_type.getText());
    }

    public TableTree getTableTree() {
        return this.m_propertySheet.getTableTree();
    }
}

